/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.servers;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.servers.ZooKeeperServer;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperEphemeralStore;
import com.linkedin.util.ArgumentUtil;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperAnnouncer {
    public static final boolean DEFAULT_DARK_WARMUP_ENABLED = false;
    public static final int DEFAULT_DARK_WARMUP_DURATION = 0;
    public static final String DEFAULT_DARK_WARMUP_CLUSTER_NAME = null;
    private final ZooKeeperServer _server;
    private static final Logger _log = LoggerFactory.getLogger(ZooKeeperAnnouncer.class);
    private volatile String _cluster;
    private volatile URI _uri;
    private volatile Map<Integer, PartitionData> _partitionDataMap;
    private volatile Map<String, Object> _uriSpecificProperties;
    private boolean _isUp;
    private boolean _isWarmingUp;
    private boolean _isRetryWarmup;
    private final Deque<Callback<None>> _pendingMarkDown;
    private final Deque<Callback<None>> _pendingMarkUp;
    private final Deque<Callback<None>> _pendingWarmupMarkDown;
    private Runnable _nextOperation;
    private boolean _isRunningMarkUpOrMarkDown;
    private volatile boolean _shuttingDown;
    private volatile boolean _markUpFailed;
    private ScheduledExecutorService _executorService;
    private boolean _isDarkWarmupEnabled;
    private String _warmupClusterName;
    private int _warmupDuration;

    public ZooKeeperAnnouncer(ZooKeeperServer server) {
        this(server, true);
    }

    public ZooKeeperAnnouncer(ZooKeeperServer server, boolean initialIsUp) {
        this(server, initialIsUp, false, DEFAULT_DARK_WARMUP_CLUSTER_NAME, 0, null);
    }

    public ZooKeeperAnnouncer(ZooKeeperServer server, boolean initialIsUp, boolean isDarkWarmupEnabled, String warmupClusterName, int warmupDuration, ScheduledExecutorService executorService) {
        this._server = server;
        this._isUp = initialIsUp;
        this._isWarmingUp = false;
        this._isRetryWarmup = false;
        this._pendingMarkDown = new ArrayDeque<Callback<None>>();
        this._pendingMarkUp = new ArrayDeque<Callback<None>>();
        this._pendingWarmupMarkDown = new ArrayDeque<Callback<None>>();
        this._isDarkWarmupEnabled = isDarkWarmupEnabled;
        this._warmupClusterName = warmupClusterName;
        this._warmupDuration = warmupDuration;
        this._executorService = executorService;
    }

    public synchronized void start(Callback<None> callback) {
        if (this._isUp) {
            this.markUp(callback);
        } else {
            callback.onSuccess((Object)None.none());
        }
    }

    public synchronized void shutdown() {
        this._shuttingDown = true;
    }

    synchronized void retry(Callback<None> callback) {
        if (!this._pendingWarmupMarkDown.isEmpty() && this._isWarmingUp) {
            this._isRetryWarmup = true;
            this.markUp(callback);
        }
        if (!this._pendingMarkDown.isEmpty() || !this._pendingMarkUp.isEmpty()) {
            if (this._isUp) {
                this.markUp(callback);
            } else {
                this.markDown(callback);
            }
        }
    }

    public void reset(final Callback<None> callback) {
        this.markDown(new Callback<None>(){

            public void onSuccess(None none) {
                ZooKeeperAnnouncer.this.markUp((Callback<None>)callback);
            }

            public void onError(Throwable e) {
                callback.onError(e);
            }
        });
    }

    public synchronized void markUp(Callback<None> callback) {
        this._pendingMarkUp.add(callback);
        this._isUp = true;
        this.runNowOrEnqueue(() -> this.doMarkUp(callback));
    }

    private synchronized void doMarkUp(final Callback<None> callback) {
        Callback<None> markUpCallback = new Callback<None>(){

            public void onError(Throwable e) {
                if (e instanceof KeeperException.ConnectionLossException || e instanceof KeeperException.SessionExpiredException) {
                    _log.warn("failed to mark up uri {} for cluster {} due to {}.", new Object[]{ZooKeeperAnnouncer.this._uri, ZooKeeperAnnouncer.this._cluster, e.getClass().getSimpleName()});
                    ZooKeeperAnnouncer.this._nextOperation = null;
                    ZooKeeperAnnouncer.this._isRunningMarkUpOrMarkDown = false;
                    ZooKeeperAnnouncer.this._markUpFailed = false;
                } else {
                    _log.error("failed to mark up uri {}", (Object)ZooKeeperAnnouncer.this._uri, (Object)e);
                    ZooKeeperAnnouncer.this._markUpFailed = true;
                    callback.onError(e);
                    ZooKeeperAnnouncer.this.runNextMarkUpOrMarkDown();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(None result) {
                ZooKeeperAnnouncer.this._markUpFailed = false;
                _log.info("markUp for uri = {} on cluster {} succeeded.", (Object)ZooKeeperAnnouncer.this._uri, (Object)ZooKeeperAnnouncer.this._cluster);
                ZooKeeperAnnouncer zooKeeperAnnouncer = ZooKeeperAnnouncer.this;
                synchronized (zooKeeperAnnouncer) {
                    ZooKeeperAnnouncer.this.drain(ZooKeeperAnnouncer.this._pendingMarkUp, null);
                    if (ZooKeeperAnnouncer.this._isUp) {
                        ZooKeeperAnnouncer.this.drain(ZooKeeperAnnouncer.this._pendingMarkDown, new CancellationException("Cancelled markDown because a more recent markUp request succeeded."));
                    }
                }
                ZooKeeperAnnouncer.this.runNextMarkUpOrMarkDown();
            }
        };
        Callback<None> warmupMarkDownCallback = new Callback<None>((Callback)markUpCallback){
            final /* synthetic */ Callback val$markUpCallback;
            {
                this.val$markUpCallback = callback;
            }

            public void onError(Throwable e) {
                if (e instanceof KeeperException.ConnectionLossException || e instanceof KeeperException.SessionExpiredException) {
                    _log.warn("failed to markDown uri {} on warm-up cluster {} due to {}.", new Object[]{ZooKeeperAnnouncer.this._uri, ZooKeeperAnnouncer.this._warmupClusterName, e.getClass().getSimpleName()});
                    ZooKeeperAnnouncer.this._nextOperation = null;
                    ZooKeeperAnnouncer.this._isRunningMarkUpOrMarkDown = false;
                } else {
                    ZooKeeperAnnouncer.this._server.markUp(ZooKeeperAnnouncer.this._cluster, ZooKeeperAnnouncer.this._uri, ZooKeeperAnnouncer.this._partitionDataMap, ZooKeeperAnnouncer.this._uriSpecificProperties, (Callback<None>)this.val$markUpCallback);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(None result) {
                ZooKeeperAnnouncer.this._isWarmingUp = false;
                ZooKeeperAnnouncer zooKeeperAnnouncer = ZooKeeperAnnouncer.this;
                synchronized (zooKeeperAnnouncer) {
                    ZooKeeperAnnouncer.this._pendingWarmupMarkDown.clear();
                }
                _log.info("markDown for uri {} on warm-up cluster {} has completed, now marking up regular cluster {}", new Object[]{ZooKeeperAnnouncer.this._uri, ZooKeeperAnnouncer.this._warmupClusterName, ZooKeeperAnnouncer.this._cluster});
                ZooKeeperAnnouncer.this._server.markUp(ZooKeeperAnnouncer.this._cluster, ZooKeeperAnnouncer.this._uri, ZooKeeperAnnouncer.this._partitionDataMap, ZooKeeperAnnouncer.this._uriSpecificProperties, (Callback<None>)this.val$markUpCallback);
            }
        };
        Callback<None> doWarmupCallback = new Callback<None>((Callback)markUpCallback, (Callback)warmupMarkDownCallback){
            final /* synthetic */ Callback val$markUpCallback;
            final /* synthetic */ Callback val$warmupMarkDownCallback;
            {
                this.val$markUpCallback = callback;
                this.val$warmupMarkDownCallback = callback2;
            }

            public void onError(Throwable e) {
                if (e instanceof KeeperException.ConnectionLossException || e instanceof KeeperException.SessionExpiredException) {
                    _log.warn("failed to mark up uri {} for warm-up cluster {} due to {}.", new Object[]{ZooKeeperAnnouncer.this._uri, ZooKeeperAnnouncer.this._cluster, e.getClass().getSimpleName()});
                    ZooKeeperAnnouncer.this._nextOperation = null;
                    ZooKeeperAnnouncer.this._isRunningMarkUpOrMarkDown = false;
                    ZooKeeperAnnouncer.this._markUpFailed = false;
                } else {
                    _log.warn("failed to mark up uri {} for warm-up cluster {}", (Object)ZooKeeperAnnouncer.this._uri, (Object)e);
                    ZooKeeperAnnouncer.this._server.markUp(ZooKeeperAnnouncer.this._cluster, ZooKeeperAnnouncer.this._uri, ZooKeeperAnnouncer.this._partitionDataMap, ZooKeeperAnnouncer.this._uriSpecificProperties, (Callback<None>)this.val$markUpCallback);
                }
            }

            public void onSuccess(None result) {
                _log.info("markUp for uri {} on warm-up cluster {} succeeded", (Object)ZooKeeperAnnouncer.this._uri, (Object)ZooKeeperAnnouncer.this._warmupClusterName);
                ZooKeeperAnnouncer.this._isWarmingUp = true;
                ZooKeeperAnnouncer.this._pendingWarmupMarkDown.add(this.val$warmupMarkDownCallback);
                _log.debug("warm-up will run for {} seconds.", (Object)ZooKeeperAnnouncer.this._warmupDuration);
                ZooKeeperAnnouncer.this._executorService.schedule(() -> ZooKeeperAnnouncer.this._server.markDown(ZooKeeperAnnouncer.this._warmupClusterName, ZooKeeperAnnouncer.this._uri, (Callback<None>)this.val$warmupMarkDownCallback), (long)ZooKeeperAnnouncer.this._warmupDuration, TimeUnit.SECONDS);
            }
        };
        _log.info("overrideMarkUp is called for uri = " + this._uri);
        if (this._isRetryWarmup) {
            if (this._isWarmingUp) {
                this._server.markDown(this._warmupClusterName, this._uri, warmupMarkDownCallback);
            }
        } else if (this._isDarkWarmupEnabled && this._warmupDuration > 0 && this._warmupClusterName != null && this._executorService != null) {
            _log.info("Starting dark warm-up with cluster {}", (Object)this._warmupClusterName);
            this._server.markUp(this._warmupClusterName, this._uri, this._partitionDataMap, this._uriSpecificProperties, doWarmupCallback);
        } else {
            this._server.markUp(this._cluster, this._uri, this._partitionDataMap, this._uriSpecificProperties, markUpCallback);
        }
    }

    public synchronized void markDown(Callback<None> callback) {
        this._pendingMarkDown.add(callback);
        this._isUp = false;
        this.runNowOrEnqueue(() -> this.doMarkDown(callback));
    }

    private synchronized void doMarkDown(final Callback<None> callback) {
        this._server.markDown(this._cluster, this._uri, new Callback<None>(){

            public void onError(Throwable e) {
                if (e instanceof KeeperException.ConnectionLossException || e instanceof KeeperException.SessionExpiredException) {
                    _log.warn("failed to mark down uri {} due to {}.", (Object)ZooKeeperAnnouncer.this._uri, (Object)e.getClass().getSimpleName());
                    ZooKeeperAnnouncer.this._nextOperation = null;
                    ZooKeeperAnnouncer.this._isRunningMarkUpOrMarkDown = false;
                } else {
                    callback.onError(e);
                    ZooKeeperAnnouncer.this.runNextMarkUpOrMarkDown();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(None result) {
                _log.info("markDown for uri = {} succeeded.", (Object)ZooKeeperAnnouncer.this._uri);
                ZooKeeperAnnouncer zooKeeperAnnouncer = ZooKeeperAnnouncer.this;
                synchronized (zooKeeperAnnouncer) {
                    ZooKeeperAnnouncer.this.drain(ZooKeeperAnnouncer.this._pendingMarkDown, null);
                    if (!ZooKeeperAnnouncer.this._isUp) {
                        ZooKeeperAnnouncer.this.drain(ZooKeeperAnnouncer.this._pendingMarkUp, new CancellationException("Cancelled markUp because a more recent markDown request succeeded."));
                    }
                }
                ZooKeeperAnnouncer.this.runNextMarkUpOrMarkDown();
            }
        });
        _log.info("overrideMarkDown is called for uri = " + this._uri);
    }

    private synchronized void runNowOrEnqueue(Runnable requestedOperation) {
        if (this._shuttingDown) {
            return;
        }
        if (this._isRunningMarkUpOrMarkDown) {
            this._nextOperation = requestedOperation;
            return;
        }
        this._isRunningMarkUpOrMarkDown = true;
        requestedOperation.run();
    }

    private synchronized void runNextMarkUpOrMarkDown() {
        Runnable operation = this._nextOperation;
        this._nextOperation = null;
        this._isRunningMarkUpOrMarkDown = false;
        if (operation != null) {
            operation.run();
        }
    }

    private void drain(Deque<Callback<None>> callbacks, @Nullable Throwable t) {
        while (!callbacks.isEmpty()) {
            try {
                if (t != null) {
                    callbacks.poll().onError(t);
                    continue;
                }
                callbacks.poll().onSuccess((Object)None.none());
            }
            catch (Throwable throwable) {
                _log.error("Unexpected throwable from markUp/markDown callback.", throwable);
            }
        }
    }

    public void setStore(ZooKeeperEphemeralStore<UriProperties> store) {
        this._server.setStore(store);
    }

    public synchronized void changeWeight(Callback<None> callback, boolean doNotSlowStart) {
        this._server.changeWeight(this._cluster, this._uri, this._partitionDataMap, doNotSlowStart, this.getOperationCallback(callback, "changeWeight"));
        _log.info("changeWeight called for uri = {}.", (Object)this._uri);
    }

    public synchronized void setDoNotLoadBalance(Callback<None> callback, boolean doNotLoadBalance) {
        this._server.addUriSpecificProperty(this._cluster, "setDoNotLoadBalance", this._uri, this._partitionDataMap, "doNotLoadBalance", doNotLoadBalance, this.getOperationCallback(callback, "setDoNotLoadBalance"));
        _log.info("setDoNotLoadBalance called for uri = {}.", (Object)this._uri);
    }

    private Callback<None> getOperationCallback(final Callback<None> callback, final String operation) {
        return new Callback<None>(){

            public void onError(Throwable e) {
                _log.warn(operation + " for uri = {} failed.", (Object)ZooKeeperAnnouncer.this._uri);
                callback.onError(e);
            }

            public void onSuccess(None result) {
                _log.info(operation + " for uri = {} succeeded.", (Object)ZooKeeperAnnouncer.this._uri);
                callback.onSuccess((Object)result);
            }
        };
    }

    public String getCluster() {
        return this._cluster;
    }

    public void setCluster(String cluster) {
        this._cluster = cluster;
    }

    public String getUri() {
        return this._uri.toString();
    }

    public void setUri(String uri) {
        this._uri = URI.create(uri);
    }

    public void setUriSpecificProperties(Map<String, Object> uriSpecificProperties) {
        this._uriSpecificProperties = Collections.unmodifiableMap(uriSpecificProperties);
    }

    public Map<String, Object> getUriSpecificProperties() {
        return this._uriSpecificProperties == null ? Collections.emptyMap() : this._uriSpecificProperties;
    }

    public void setWeightOrPartitionData(Object data) {
        ArgumentUtil.notNull((Object)data, (String)"weightOrPartitionData");
        if (data instanceof Number) {
            this.setWeight(((Number)data).doubleValue());
        } else {
            try {
                Map partitionDataMap = (Map)data;
                this.setPartitionData(partitionDataMap);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("data: " + data + " is not an instance of Map", e);
            }
        }
    }

    public void setWeight(double weight) {
        int numberOfPartitions = this.getNumberOfPartitions();
        if (numberOfPartitions > 1) {
            throw new IllegalArgumentException("When a single announcer is serving multiple partitions, you cannot call setWeight since it would change the weight for multiple partitions. The partitionData should be changed instead.");
        }
        int partitionId = 0;
        if (numberOfPartitions == 1) {
            partitionId = this.getPartitionData().entrySet().iterator().next().getKey();
        }
        HashMap<Integer, PartitionData> partitionDataMap = new HashMap<Integer, PartitionData>(1);
        partitionDataMap.put(partitionId, new PartitionData(weight));
        this._partitionDataMap = Collections.unmodifiableMap(partitionDataMap);
    }

    public void setPartitionData(Map<Integer, PartitionData> partitionData) {
        this._partitionDataMap = Collections.unmodifiableMap(new HashMap<Integer, PartitionData>(partitionData));
    }

    public Map<Integer, PartitionData> getPartitionData() {
        return this._partitionDataMap;
    }

    private int getNumberOfPartitions() {
        Map<Integer, PartitionData> partitionDataMap = this.getPartitionData();
        return partitionDataMap == null ? 0 : partitionDataMap.size();
    }

    public boolean isMarkUpFailed() {
        return this._markUpFailed;
    }
}

