/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.servers;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.CallbackAdapter;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.servers.ZooKeeperAnnouncer;
import com.linkedin.d2.balancer.zkfs.ZKFSUtil;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZKConnectionBuilder;
import com.linkedin.d2.discovery.stores.zk.ZKPersistentConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperEphemeralStore;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperStore;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperConnectionManager.class);
    private final String _zkConnectString;
    private final int _zkSessionTimeout;
    private final String _zkBasePath;
    private final ZKStoreFactory<UriProperties, ZooKeeperEphemeralStore<UriProperties>> _factory;
    private final ZooKeeperAnnouncer[] _servers;
    private final AtomicReference<Callback<None>> _startupCallback = new AtomicReference();
    private final ZKPersistentConnection _zkConnection;
    private volatile boolean _storeStarted = false;
    private volatile boolean _managerStarted = false;
    private volatile boolean _storeReady = false;
    private volatile boolean _sessionEstablished = false;
    private volatile ZooKeeperEphemeralStore<UriProperties> _store;

    public ZooKeeperConnectionManager(ZKPersistentConnection zkConnection, String zkBasePath, ZKStoreFactory<UriProperties, ZooKeeperEphemeralStore<UriProperties>> factory, ZooKeeperAnnouncer ... servers) {
        this._zkBasePath = zkBasePath;
        this._zkConnection = zkConnection;
        this._factory = factory;
        this._servers = servers;
        this._zkConnection.addListeners(Collections.singletonList(new Listener()));
        this._zkConnectString = zkConnection.getZKConnection().getConnectString();
        this._zkSessionTimeout = zkConnection.getZKConnection().getTimeout();
    }

    public ZooKeeperConnectionManager(String zkConnectString, int zkSessionTimeout, String zkBasePath, ZKStoreFactory<UriProperties, ZooKeeperEphemeralStore<UriProperties>> factory, ZooKeeperAnnouncer ... servers) {
        this._zkConnectString = zkConnectString;
        this._zkSessionTimeout = zkSessionTimeout;
        this._zkBasePath = zkBasePath;
        this._factory = factory;
        this._servers = servers;
        this._zkConnection = new ZKPersistentConnection(new ZKConnectionBuilder(this._zkConnectString).setTimeout(this._zkSessionTimeout));
        this._zkConnection.addListeners(Collections.singletonList(new Listener()));
    }

    @Deprecated
    public ZooKeeperConnectionManager(String zkConnectString, int zkSessionTimeout, String zkBasePath, ZKStoreFactory<UriProperties, ZooKeeperEphemeralStore<UriProperties>> factory, int retryLimit, ZooKeeperAnnouncer ... servers) {
        this(zkConnectString, zkSessionTimeout, zkBasePath, factory, servers);
    }

    @Deprecated
    public ZooKeeperConnectionManager(String zkConnectString, int zkSessionTimeout, String zkBasePath, ZKStoreFactory<UriProperties, ZooKeeperEphemeralStore<UriProperties>> factory, int retryLimit, boolean exponentialBackoff, ScheduledExecutorService scheduler, long initInterval, ZooKeeperAnnouncer ... servers) {
        this(zkConnectString, zkSessionTimeout, zkBasePath, factory, servers);
    }

    public void start(Callback<None> callback) {
        this._managerStarted = true;
        if (!this._startupCallback.compareAndSet(null, callback)) {
            throw new IllegalStateException("Already starting");
        }
        try {
            this._zkConnection.start();
            this.tryStartStore();
            LOG.info("Started ZooKeeper connection to {}", (Object)this._zkConnectString);
        }
        catch (Exception e) {
            this._startupCallback.set(null);
            callback.onError((Throwable)e);
        }
    }

    public void shutdown(Callback<None> callback) {
        this._managerStarted = false;
        for (ZooKeeperAnnouncer server : this._servers) {
            server.shutdown();
        }
        CallbackAdapter<None, None> zkCloseCallback = new CallbackAdapter<None, None>(callback){

            protected None convertResponse(None none) throws Exception {
                ZooKeeperConnectionManager.this._zkConnection.shutdown();
                return none;
            }
        };
        if (this._store != null) {
            this._store.shutdown((Callback<None>)zkCloseCallback);
        } else {
            zkCloseCallback.onSuccess((Object)None.none());
        }
    }

    public void markDownAllServers(Callback<None> callback) {
        Callback<None> markDownCallback = callback != null ? callback : new Callback<None>(){

            public void onError(Throwable e) {
                LOG.error("failed to mark down servers", e);
            }

            public void onSuccess(None result) {
                LOG.info("mark down all servers successful");
            }
        };
        Callback multiCallback = Callbacks.countDown((Callback)markDownCallback, (int)this._servers.length);
        for (ZooKeeperAnnouncer server : this._servers) {
            server.markDown((Callback<None>)multiCallback);
        }
    }

    public void markUpAllServers(Callback<None> callback) {
        Callback<None> markUpCallback = callback != null ? callback : new Callback<None>(){

            public void onError(Throwable e) {
                LOG.error("failed to mark up servers", e);
            }

            public void onSuccess(None result) {
                LOG.info("mark up all servers successful");
            }
        };
        Callback multiCallback = Callbacks.countDown((Callback)markUpCallback, (int)this._servers.length);
        for (ZooKeeperAnnouncer server : this._servers) {
            server.markUp((Callback<None>)multiCallback);
        }
    }

    private void tryStartStore() {
        if (this._managerStarted && this._storeReady) {
            this.startStore();
        }
    }

    private void startStore() {
        final Callback callback = this._startupCallback.getAndSet(null);
        final Callback multiCallback = callback != null ? Callbacks.countDown((Callback)callback, (int)this._servers.length) : Callbacks.empty();
        this._store.start(new Callback<None>(){

            public void onError(Throwable e) {
                LOG.error("Failed to start ZooKeeperEphemeralStore", e);
                if (callback != null) {
                    callback.onError(e);
                }
            }

            public void onSuccess(None result) {
                LOG.info("ZooKeeperEphemeralStore started successfully, starting {} announcers", (Object)ZooKeeperConnectionManager.this._servers.length);
                ZooKeeperConnectionManager.this._storeStarted = true;
                for (ZooKeeperAnnouncer server : ZooKeeperConnectionManager.this._servers) {
                    server.setStore(ZooKeeperConnectionManager.this._store);
                    server.start(new Callback<None>(){

                        public void onError(Throwable e) {
                            LOG.error("Failed to start server", e);
                            multiCallback.onError(e);
                        }

                        public void onSuccess(None result) {
                            LOG.info("Started an announcer");
                            multiCallback.onSuccess((Object)result);
                        }
                    });
                }
            }
        });
    }

    public ZooKeeperAnnouncer[] getAnnouncers() {
        return this._servers;
    }

    public boolean isSessionEstablished() {
        return this._sessionEstablished;
    }

    public String getZooKeeperConnectString() {
        return this._zkConnectString;
    }

    public int getZooKeeperSessionTimeout() {
        return this._zkSessionTimeout;
    }

    public String getZooKeeperBasePath() {
        return this._zkBasePath;
    }

    public static interface ZKStoreFactory<P, Z extends ZooKeeperStore<P>> {
        public Z createStore(ZKConnection var1, String var2);
    }

    private class Listener
    implements ZKPersistentConnection.EventListener {
        private Listener() {
        }

        @Override
        public void notifyEvent(ZKPersistentConnection.Event event) {
            LOG.info("Received ZKPersistentConnection Event {}", (Object)event);
            switch (event) {
                case SESSION_ESTABLISHED: {
                    ZooKeeperConnectionManager.this._sessionEstablished = true;
                    ZooKeeperConnectionManager.this._store = (ZooKeeperEphemeralStore)ZooKeeperConnectionManager.this._factory.createStore(ZooKeeperConnectionManager.this._zkConnection.getZKConnection(), ZKFSUtil.uriPath(ZooKeeperConnectionManager.this._zkBasePath));
                    ZooKeeperConnectionManager.this._storeReady = true;
                    ZooKeeperConnectionManager.this.tryStartStore();
                    break;
                }
                case SESSION_EXPIRED: {
                    ZooKeeperConnectionManager.this._sessionEstablished = false;
                    ZooKeeperConnectionManager.this._store.shutdown((Callback<None>)Callbacks.empty());
                    ZooKeeperConnectionManager.this._storeStarted = false;
                    break;
                }
                case CONNECTED: {
                    if (!ZooKeeperConnectionManager.this._storeStarted) {
                        ZooKeeperConnectionManager.this.tryStartStore();
                        break;
                    }
                    for (ZooKeeperAnnouncer server : ZooKeeperConnectionManager.this._servers) {
                        server.retry((Callback<None>)Callbacks.empty());
                    }
                    break;
                }
            }
        }
    }
}

