/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.servers;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.LoadBalancerServer;
import com.linkedin.d2.balancer.ServiceUnavailableException;
import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperEphemeralStore;
import com.linkedin.d2.discovery.util.LogUtil;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServer
implements LoadBalancerServer {
    private static final Logger _log = LoggerFactory.getLogger(ZooKeeperServer.class);
    private volatile ZooKeeperEphemeralStore<UriProperties> _store;

    public ZooKeeperServer() {
    }

    public ZooKeeperServer(ZooKeeperEphemeralStore<UriProperties> store) {
        this._store = store;
    }

    @Override
    public void start(Callback<None> callback) {
        this._store.start(callback);
    }

    @Override
    public void shutdown(Callback<None> callback) {
        this._store.shutdown(callback);
    }

    @Override
    public void markUp(String clusterName, URI uri, Map<Integer, PartitionData> partitionDataMap, Callback<None> callback) {
        this.markUp(clusterName, uri, partitionDataMap, Collections.emptyMap(), callback);
    }

    @Override
    public void markUp(final String clusterName, final URI uri, final Map<Integer, PartitionData> partitionDataMap, final Map<String, Object> uriSpecificProperties, final Callback<None> callback) {
        Callback<None> doPutCallback = new Callback<None>(){

            public void onSuccess(None none) {
                Map<URI, Map<String, Object>> myUriSpecificProperties;
                HashMap<URI, Map<Integer, PartitionData>> partitionDesc = new HashMap<URI, Map<Integer, PartitionData>>();
                partitionDesc.put(uri, partitionDataMap);
                if (uriSpecificProperties != null && !uriSpecificProperties.isEmpty()) {
                    myUriSpecificProperties = new HashMap();
                    myUriSpecificProperties.put(uri, uriSpecificProperties);
                } else {
                    myUriSpecificProperties = Collections.emptyMap();
                }
                if (_log.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(ZooKeeperServer.this._store);
                    sb.append(" marked up for cluster: ");
                    sb.append(clusterName);
                    sb.append(", uri: ");
                    sb.append(uri);
                    sb.append(", announcing [partitionId: weight]s: {");
                    Iterator iterator = partitionDataMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        int partitionId = (Integer)iterator.next();
                        sb.append("[");
                        sb.append(partitionId);
                        sb.append(" : ");
                        sb.append(partitionDataMap.get(partitionId));
                        sb.append("]");
                    }
                    sb.append("}");
                    LogUtil.info(_log, sb);
                }
                ZooKeeperServer.this._store.put(clusterName, new UriProperties(clusterName, partitionDesc, myUriSpecificProperties), (Callback<None>)callback);
            }

            public void onError(Throwable e) {
                if (e instanceof KeeperException.NoNodeException) {
                    this.onSuccess(None.none());
                    return;
                }
                LogUtil.info(_log, ZooKeeperServer.this._store + " failed to mark up for cluster: " + clusterName + ", uri: " + uri);
                callback.onError(e);
            }
        };
        Callback<UriProperties> getCallback = new Callback<UriProperties>((Callback)doPutCallback, callback){
            final /* synthetic */ Callback val$doPutCallback;
            final /* synthetic */ Callback val$callback;
            {
                this.val$doPutCallback = callback;
                this.val$callback = callback2;
            }

            public void onSuccess(UriProperties uris) {
                if (uris != null && uris.Uris().contains(uri)) {
                    LogUtil.warn(_log, "markUp called on a uri that already exists in cluster ", clusterName, ": ", uri);
                    ZooKeeperServer.this.markDown(clusterName, uri, (Callback<None>)this.val$doPutCallback);
                } else {
                    this.val$doPutCallback.onSuccess((Object)None.none());
                }
            }

            public void onError(Throwable e) {
                LogUtil.info(_log, ZooKeeperServer.this._store + " failed to get current status on ZK for cluster: " + clusterName + ", uri: " + uri);
                this.val$callback.onError(e);
            }
        };
        this.storeGet(clusterName, getCallback);
    }

    @Override
    public void markDown(final String clusterName, final URI uri, final Callback<None> callback) {
        Callback<UriProperties> getCallback = new Callback<UriProperties>(){

            public void onSuccess(UriProperties uris) {
                if (uris == null) {
                    LogUtil.warn(_log, "markDown called on a cluster that doesn't exist in zk: ", clusterName);
                    callback.onSuccess((Object)None.none());
                } else if (!uris.Uris().contains(uri)) {
                    LogUtil.warn(_log, "markDown called on a uri that doesn't exist in cluster ", clusterName, ": ", uri);
                    callback.onSuccess((Object)None.none());
                } else {
                    LogUtil.warn(_log, ZooKeeperServer.this._store, " marked down for cluster ", clusterName, "with uri: ", uri);
                    HashMap<URI, Map<Integer, PartitionData>> partitionData = new HashMap<URI, Map<Integer, PartitionData>>(2);
                    partitionData.put(uri, Collections.emptyMap());
                    ZooKeeperServer.this._store.removePartial(clusterName, new UriProperties(clusterName, partitionData), (Callback<None>)callback);
                }
            }

            public void onError(Throwable e) {
                callback.onError(e);
            }
        };
        this.storeGet(clusterName, getCallback);
    }

    @Override
    public void changeWeight(String clusterName, URI uri, Map<Integer, PartitionData> partitionDataMap, boolean doNotSlowStart, Callback<None> callback) {
        this.addUriSpecificProperty(clusterName, "changeWeight", uri, partitionDataMap, "doNotSlowStart", doNotSlowStart, callback);
    }

    @Override
    public void addUriSpecificProperty(final String clusterName, final String operationName, final URI uri, final Map<Integer, PartitionData> partitionDataMap, final String uriSpecificPropertiesName, final Object uriSpecificPropertiesValue, final Callback<None> callback) {
        Callback<UriProperties> getCallback = new Callback<UriProperties>(){

            public void onSuccess(UriProperties uriProperties) {
                if (uriProperties == null) {
                    LogUtil.warn(_log, operationName, " called on a cluster that doesn't exist in zookeeper: ", clusterName);
                    callback.onError((Throwable)((Object)new ServiceUnavailableException("cluster: " + clusterName, "Cluster does not exist in zookeeper.")));
                } else if (!uriProperties.Uris().contains(uri)) {
                    LogUtil.warn(_log, operationName, " called on a uri that doesn't exist in cluster ", clusterName, ": ", uri);
                    callback.onError((Throwable)((Object)new ServiceUnavailableException(String.format("cluster: %s, uri: %s", clusterName, uri), "Uri does not exist in cluster.")));
                } else {
                    final Map uriSpecificProperties = uriProperties.getUriSpecificProperties().getOrDefault(uri, new HashMap());
                    uriSpecificProperties.put(uriSpecificPropertiesName, uriSpecificPropertiesValue);
                    Callback<None> markUpCallback = new Callback<None>(){

                        public void onError(Throwable e) {
                            callback.onError(e);
                        }

                        public void onSuccess(None result) {
                            ZooKeeperServer.this.markUp(clusterName, uri, partitionDataMap, uriSpecificProperties, (Callback<None>)callback);
                        }
                    };
                    ZooKeeperServer.this.markDown(clusterName, uri, markUpCallback);
                }
            }

            public void onError(Throwable e) {
                callback.onError(e);
            }
        };
        this.storeGet(clusterName, getCallback);
    }

    public void setStore(ZooKeeperEphemeralStore<UriProperties> store) {
        this._store = store;
        LogUtil.info(_log, "store set to new store: ", this._store);
    }

    public void shutdown() {
        LogUtil.info(_log, "shutting down zk server");
        FutureCallback callback = new FutureCallback();
        this._store.shutdown((Callback<None>)callback);
        try {
            callback.get(5L, TimeUnit.SECONDS);
            LogUtil.info(_log, "shutting down complete");
        }
        catch (TimeoutException e) {
            LogUtil.warn(_log, "unable to shut down propertly");
        }
        catch (InterruptedException | ExecutionException e) {
            LogUtil.warn(_log, "unable to shut down propertly.. got interrupt exception while waiting");
        }
    }

    private void storeGet(String clusterName, Callback<UriProperties> callback) {
        if (this._store == null) {
            callback.onError(new Throwable("ZK connection not ready yet"));
        } else {
            this._store.get(clusterName, callback);
        }
    }
}

