/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.servers;

import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.properties.UriPropertiesJsonSerializer;
import com.linkedin.d2.balancer.properties.UriPropertiesMerger;
import com.linkedin.d2.balancer.servers.ZooKeeperConnectionManager;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperEphemeralStore;
import com.linkedin.d2.discovery.stores.zk.ZookeeperChildFilter;
import com.linkedin.d2.discovery.stores.zk.ZookeeperEphemeralPrefixGenerator;
import com.linkedin.d2.discovery.stores.zk.builder.ZooKeeperEphemeralStoreBuilder;

public class ZooKeeperUriStoreFactory
implements ZooKeeperConnectionManager.ZKStoreFactory<UriProperties, ZooKeeperEphemeralStore<UriProperties>> {
    private ZookeeperChildFilter _childFilter;
    private ZookeeperEphemeralPrefixGenerator _prefixGenerator;
    private boolean _useHashEphemeralPrefix;

    public ZooKeeperUriStoreFactory() {
        this(null, null, false);
    }

    public ZooKeeperUriStoreFactory(ZookeeperChildFilter childFilter, ZookeeperEphemeralPrefixGenerator prefixGenerator, boolean useHashEphemeralPrefix) {
        this._childFilter = childFilter;
        this._prefixGenerator = prefixGenerator;
        this._useHashEphemeralPrefix = useHashEphemeralPrefix;
    }

    @Override
    public ZooKeeperEphemeralStore<UriProperties> createStore(ZKConnection connection, String path) {
        ZooKeeperEphemeralStoreBuilder<UriProperties> storeBuilder = new ZooKeeperEphemeralStoreBuilder<UriProperties>();
        storeBuilder.setZkConnection(connection);
        storeBuilder.setSerializer(new UriPropertiesJsonSerializer());
        storeBuilder.setMerger(new UriPropertiesMerger());
        storeBuilder.setPath(path);
        if (this._useHashEphemeralPrefix) {
            storeBuilder.setZookeeperChildFilter(this._childFilter);
            storeBuilder.setZookeeperEphemeralPrefixGenerator(this._prefixGenerator);
        }
        return storeBuilder.build();
    }
}

