/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.servers;

import com.linkedin.d2.discovery.stores.zk.ZookeeperChildFilter;
import com.linkedin.d2.discovery.stores.zk.ZookeeperEphemeralPrefixGenerator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ZookeeperPrefixChildFilter
implements ZookeeperChildFilter {
    private final ZookeeperEphemeralPrefixGenerator _prefixGenerator;

    public ZookeeperPrefixChildFilter(ZookeeperEphemeralPrefixGenerator prefixGenerator) {
        this._prefixGenerator = prefixGenerator;
    }

    @Override
    public List<String> filter(List<String> children) {
        if (children == null) {
            return null;
        }
        return children.stream().filter((? super T child) -> {
            int separatorIndex = child.lastIndexOf(45);
            String childPrefix = separatorIndex > 0 ? child.substring(0, separatorIndex) : child;
            String ephemeralStorePrefix = this._prefixGenerator.generatePrefix();
            return StringUtils.isEmpty((CharSequence)ephemeralStorePrefix) || childPrefix.equals(ephemeralStorePrefix) || childPrefix.equals("ephemoral");
        }).collect(Collectors.toList());
    }
}

