/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.simple;

import com.linkedin.d2.balancer.LoadBalancerState;
import com.linkedin.d2.discovery.event.PropertyEventBus;
import com.linkedin.d2.discovery.event.PropertyEventSubscriber;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.r2.util.ClosableQueue;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoadBalancerSubscriber<T>
implements PropertyEventSubscriber<T> {
    private static final Logger _log = LoggerFactory.getLogger(AbstractLoadBalancerSubscriber.class);
    private final String _name;
    private final int _type;
    private final PropertyEventBus<T> _eventBus;
    private final ConcurrentMap<String, ClosableQueue<LoadBalancerState.LoadBalancerStateListenerCallback>> _waiters = new ConcurrentHashMap<String, ClosableQueue<LoadBalancerState.LoadBalancerStateListenerCallback>>();

    public AbstractLoadBalancerSubscriber(int type, PropertyEventBus<T> eventBus) {
        this._name = this.getClass().getSimpleName();
        this._type = type;
        this._eventBus = eventBus;
    }

    public boolean isListeningToProperty(String propertyName) {
        ClosableQueue waiters = (ClosableQueue)this._waiters.get(propertyName);
        return waiters != null && waiters.isClosed();
    }

    public int propertyListenCount() {
        return this._waiters.size();
    }

    public void ensureListening(String propertyName, LoadBalancerState.LoadBalancerStateListenerCallback callback) {
        ClosableQueue waiters = (ClosableQueue)this._waiters.get(propertyName);
        boolean register = false;
        if (waiters == null) {
            waiters = new ClosableQueue();
            ClosableQueue previous = this._waiters.putIfAbsent(propertyName, (ClosableQueue<LoadBalancerState.LoadBalancerStateListenerCallback>)waiters);
            if (previous == null) {
                register = true;
            } else {
                waiters = previous;
            }
        }
        if (!waiters.offer((Object)callback)) {
            callback.done(this._type, propertyName);
        }
        if (register) {
            this._eventBus.register(Collections.singleton(propertyName), this);
        }
    }

    @Override
    public void onAdd(String propertyName, T propertyValue) {
        LogUtil.trace(_log, this._name, ".onAdd: ", propertyName, ": ", propertyValue);
        this.handlePut(propertyName, propertyValue);
        List queueList = ((ClosableQueue)this._waiters.get(propertyName)).ensureClosed();
        if (queueList != null) {
            for (LoadBalancerState.LoadBalancerStateListenerCallback waiter : queueList) {
                waiter.done(this._type, propertyName);
            }
        }
    }

    @Override
    public void onInitialize(String propertyName, T propertyValue) {
        LogUtil.trace(_log, this._name, ".onInitialize: ", propertyName, ": ", propertyValue);
        this.handlePut(propertyName, propertyValue);
        for (LoadBalancerState.LoadBalancerStateListenerCallback waiter : ((ClosableQueue)this._waiters.get(propertyName)).close()) {
            waiter.done(this._type, propertyName);
        }
    }

    @Override
    public void onRemove(String propertyName) {
        LogUtil.trace(_log, this._name, ".onRemove: ", propertyName);
        this.handleRemove(propertyName);
        List queueList = ((ClosableQueue)this._waiters.get(propertyName)).ensureClosed();
        if (queueList != null) {
            for (LoadBalancerState.LoadBalancerStateListenerCallback waiter : queueList) {
                waiter.done(this._type, propertyName);
            }
        }
    }

    protected abstract void handlePut(String var1, T var2);

    protected abstract void handleRemove(String var1);
}

