/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.simple;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.properties.ClusterProperties;
import com.linkedin.d2.balancer.simple.ClusterInfoItem;
import com.linkedin.d2.balancer.simple.SslSessionValidatorFactory;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.http.client.common.ssl.SslSessionValidator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class ClusterAwareTransportClient
implements TransportClient {
    private final String _clusterName;
    private final TransportClient _wrappedClient;
    private final Map<String, ClusterInfoItem> _clusterInfo;
    private final SslSessionValidatorFactory _sslSessionValidatorFactory;
    private final AtomicLong _cachedClusterVersion;
    private volatile SslSessionValidator _cachedSslSessionValidator;

    public ClusterAwareTransportClient(String clusterName, TransportClient client, Map<String, ClusterInfoItem> clusterInfo, SslSessionValidatorFactory sessionValidatorFactory) {
        this._clusterName = clusterName;
        this._wrappedClient = client;
        this._clusterInfo = clusterInfo;
        this._sslSessionValidatorFactory = sessionValidatorFactory;
        this._cachedClusterVersion = new AtomicLong(-1L);
        this._cachedSslSessionValidator = null;
    }

    public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
        this.updateRequestContext(requestContext);
        this.getWrappedClient().restRequest(request, requestContext, wireAttrs, callback);
    }

    public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
        this.updateRequestContext(requestContext);
        this.getWrappedClient().streamRequest(request, requestContext, wireAttrs, callback);
    }

    public void shutdown(Callback<None> callback) {
        this.getWrappedClient().shutdown(callback);
    }

    private void updateRequestContext(RequestContext requestContext) {
        SslSessionValidator sslSessionValidator = this.getValidator();
        if (sslSessionValidator != null) {
            requestContext.putLocalAttr("REQUESTED_SSL_SESSION_VALIDATOR", (Object)sslSessionValidator);
        }
    }

    private TransportClient getWrappedClient() {
        return this._wrappedClient;
    }

    private SslSessionValidator getValidator() {
        ClusterProperties clusterProperties;
        ClusterInfoItem clusterInfoItem = this._clusterInfo.get(this._clusterName);
        if (clusterInfoItem == null || clusterInfoItem.getClusterPropertiesItem() == null) {
            return null;
        }
        long cachedVersion = this._cachedClusterVersion.get();
        long currentVersion = clusterInfoItem.getClusterPropertiesItem().getVersion();
        if (currentVersion > cachedVersion && this._cachedClusterVersion.updateAndGet(prev -> clusterInfoItem.getClusterPropertiesItem().getVersion()) > cachedVersion && (clusterProperties = clusterInfoItem.getClusterPropertiesItem().getProperty()) != null) {
            this._cachedSslSessionValidator = this._sslSessionValidatorFactory.getSessionValidator(clusterProperties.getSslSessionValidationStrings());
        }
        return this._cachedSslSessionValidator;
    }
}

