/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.simple;

import com.linkedin.d2.balancer.LoadBalancerStateItem;
import com.linkedin.d2.balancer.properties.ClusterProperties;
import com.linkedin.d2.balancer.properties.FailoutProperties;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancerState;
import com.linkedin.d2.balancer.util.canary.CanaryDistributionProvider;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClusterInfoItem {
    private final LoadBalancerStateItem<ClusterProperties> _clusterPropertiesItem;
    private final LoadBalancerStateItem<PartitionAccessor> _partitionAccessorItem;
    private final LoadBalancerStateItem<FailoutProperties> _failoutPropertiesItem;

    public ClusterInfoItem(SimpleLoadBalancerState simpleLoadBalancerState, ClusterProperties clusterProperties, PartitionAccessor partitionAccessor) {
        this(simpleLoadBalancerState, clusterProperties, partitionAccessor, CanaryDistributionProvider.Distribution.STABLE);
    }

    public ClusterInfoItem(SimpleLoadBalancerState simpleLoadBalancerState, ClusterProperties clusterProperties, PartitionAccessor partitionAccessor, @Nonnull CanaryDistributionProvider.Distribution distribution) {
        this(simpleLoadBalancerState, clusterProperties, partitionAccessor, distribution, null);
    }

    public ClusterInfoItem(SimpleLoadBalancerState simpleLoadBalancerState, ClusterProperties clusterProperties, PartitionAccessor partitionAccessor, @Nonnull CanaryDistributionProvider.Distribution distribution, @Nullable FailoutProperties failoutProperties) {
        long version = simpleLoadBalancerState.getVersionAccess().incrementAndGet();
        this._clusterPropertiesItem = new LoadBalancerStateItem<ClusterProperties>(clusterProperties, version, System.currentTimeMillis(), distribution);
        this._partitionAccessorItem = new LoadBalancerStateItem<PartitionAccessor>(partitionAccessor, version, System.currentTimeMillis());
        this._failoutPropertiesItem = new LoadBalancerStateItem<FailoutProperties>(failoutProperties, version, System.currentTimeMillis());
    }

    public LoadBalancerStateItem<ClusterProperties> getClusterPropertiesItem() {
        return this._clusterPropertiesItem;
    }

    public LoadBalancerStateItem<PartitionAccessor> getPartitionAccessorItem() {
        return this._partitionAccessorItem;
    }

    LoadBalancerStateItem<FailoutProperties> getFailoutPropertiesItem() {
        return this._failoutPropertiesItem;
    }

    public String toString() {
        return "_clusterProperties = " + this._clusterPropertiesItem.getProperty();
    }
}

