/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.simple;

import com.linkedin.d2.balancer.config.CanaryDistributionStrategyConverter;
import com.linkedin.d2.balancer.properties.ClusterProperties;
import com.linkedin.d2.balancer.properties.ClusterStoreProperties;
import com.linkedin.d2.balancer.properties.FailoutProperties;
import com.linkedin.d2.balancer.simple.AbstractLoadBalancerSubscriber;
import com.linkedin.d2.balancer.simple.ClusterInfoItem;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancerState;
import com.linkedin.d2.balancer.util.canary.CanaryDistributionProvider;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessorFactory;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessorRegistry;
import com.linkedin.d2.discovery.event.PropertyEventBus;

class ClusterLoadBalancerSubscriber
extends AbstractLoadBalancerSubscriber<ClusterProperties> {
    private final SimpleLoadBalancerState _simpleLoadBalancerState;
    private final PartitionAccessorRegistry _partitionAccessorRegistry;

    public ClusterLoadBalancerSubscriber(SimpleLoadBalancerState simpleLoadBalancerState, PropertyEventBus<ClusterProperties> cPropertyEventBus, PartitionAccessorRegistry partitionAccessorRegistry) {
        super(1, cPropertyEventBus);
        this._simpleLoadBalancerState = simpleLoadBalancerState;
        this._partitionAccessorRegistry = partitionAccessorRegistry;
    }

    @Override
    protected void handlePut(String listenTo, ClusterProperties discoveryProperties) {
        if (discoveryProperties != null) {
            ActivePropertiesResult pickedPropertiesResult = this.pickActiveProperties(discoveryProperties);
            ClusterInfoItem newClusterInfoItem = new ClusterInfoItem(this._simpleLoadBalancerState, pickedPropertiesResult.clusterProperties, PartitionAccessorFactory.getPartitionAccessor(pickedPropertiesResult.clusterProperties.getClusterName(), this._partitionAccessorRegistry, pickedPropertiesResult.clusterProperties.getPartitionProperties()), pickedPropertiesResult.distribution, this.getFailoutProperties(discoveryProperties));
            this._simpleLoadBalancerState.getClusterInfo().put(listenTo, newClusterInfoItem);
            this._simpleLoadBalancerState.notifyListenersOnClusterInfoUpdates(newClusterInfoItem);
            this._simpleLoadBalancerState.notifyClusterListenersOnAdd(listenTo);
        } else {
            this._simpleLoadBalancerState.getClusterInfo().put(listenTo, new ClusterInfoItem(this._simpleLoadBalancerState, null, null, null));
        }
    }

    @Override
    protected void handleRemove(String listenTo) {
        ClusterInfoItem clusterInfoRemoved = this._simpleLoadBalancerState.getClusterInfo().remove(listenTo);
        this._simpleLoadBalancerState.notifyListenersOnClusterInfoRemovals(clusterInfoRemoved);
        this._simpleLoadBalancerState.notifyClusterListenersOnRemove(listenTo);
    }

    private ActivePropertiesResult pickActiveProperties(ClusterProperties discoveryProperties) {
        ClusterProperties pickedProperties = discoveryProperties;
        CanaryDistributionProvider.Distribution distribution = CanaryDistributionProvider.Distribution.STABLE;
        ClusterStoreProperties clusterStoreProperties = this.toClusterStoreProperties(discoveryProperties);
        if (clusterStoreProperties != null) {
            CanaryDistributionProvider canaryDistributionProvider = this._simpleLoadBalancerState.getCanaryDistributionProvider();
            if (clusterStoreProperties.hasCanary() && canaryDistributionProvider != null) {
                distribution = canaryDistributionProvider.distribute(CanaryDistributionStrategyConverter.toConfig(clusterStoreProperties.getCanaryDistributionStrategy()));
            }
            pickedProperties = clusterStoreProperties.getDistributedClusterProperties(distribution);
        }
        return new ActivePropertiesResult(distribution, pickedProperties);
    }

    private FailoutProperties getFailoutProperties(ClusterProperties clusterProperties) {
        ClusterStoreProperties clusterStoreProperties = this.toClusterStoreProperties(clusterProperties);
        if (clusterStoreProperties == null) {
            return null;
        }
        return clusterStoreProperties.getFailoutProperties();
    }

    private ClusterStoreProperties toClusterStoreProperties(ClusterProperties clusterProperties) {
        return clusterProperties instanceof ClusterStoreProperties ? (ClusterStoreProperties)clusterProperties : null;
    }

    private static class ActivePropertiesResult {
        final CanaryDistributionProvider.Distribution distribution;
        final ClusterProperties clusterProperties;

        ActivePropertiesResult(CanaryDistributionProvider.Distribution distribution, ClusterProperties clusterProperties) {
            this.distribution = distribution;
            this.clusterProperties = clusterProperties;
        }
    }
}

