/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.simple;

import com.linkedin.d2.balancer.LoadBalancerStateItem;
import com.linkedin.d2.balancer.config.CanaryDistributionStrategyConverter;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.properties.ServiceStoreProperties;
import com.linkedin.d2.balancer.simple.AbstractLoadBalancerSubscriber;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancerState;
import com.linkedin.d2.balancer.util.canary.CanaryDistributionProvider;
import com.linkedin.d2.discovery.event.PropertyEventBus;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceLoadBalancerSubscriber
extends AbstractLoadBalancerSubscriber<ServiceProperties> {
    private static final Logger _log = LoggerFactory.getLogger(ServiceLoadBalancerSubscriber.class);
    private final SimpleLoadBalancerState _simpleLoadBalancerState;

    public ServiceLoadBalancerSubscriber(PropertyEventBus<ServiceProperties> eventBus, SimpleLoadBalancerState simpleLoadBalancerState) {
        super(0, eventBus);
        this._simpleLoadBalancerState = simpleLoadBalancerState;
    }

    @Override
    protected void handlePut(String listenTo, ServiceProperties discoveryProperties) {
        Set<String> serviceNames;
        ServiceProperties oldServiceProperties;
        LoadBalancerStateItem<ServiceProperties> oldServicePropertiesItem = this._simpleLoadBalancerState.getServiceProperties().get(listenTo);
        ActivePropertiesResult pickedPropertiesResult = this.pickActiveProperties(discoveryProperties);
        ServiceProperties pickedProperties = pickedPropertiesResult.serviceProperties;
        LoadBalancerStateItem<ServiceProperties> newServiceProperties = new LoadBalancerStateItem<ServiceProperties>(pickedProperties, this._simpleLoadBalancerState.getVersionAccess().incrementAndGet(), System.currentTimeMillis(), pickedPropertiesResult.distribution);
        this._simpleLoadBalancerState.getServiceProperties().put(listenTo, newServiceProperties);
        if (pickedProperties != null) {
            Set<String> serviceNames2;
            ServiceProperties oldServiceProperties2;
            if (oldServicePropertiesItem != null && (oldServiceProperties2 = oldServicePropertiesItem.getProperty()) != null && oldServiceProperties2.getClusterName() != null && !oldServiceProperties2.getClusterName().equals(pickedProperties.getClusterName()) && (serviceNames2 = this._simpleLoadBalancerState.getServicesPerCluster().get(oldServiceProperties2.getClusterName())) != null) {
                serviceNames2.remove(oldServiceProperties2.getServiceName());
            }
            this._simpleLoadBalancerState.notifyListenersOnServicePropertiesUpdates(newServiceProperties);
            this._simpleLoadBalancerState.refreshServiceStrategies(pickedProperties);
            this._simpleLoadBalancerState.refreshClients(pickedProperties);
            Set<String> serviceNames3 = this._simpleLoadBalancerState.getServicesPerCluster().get(pickedProperties.getClusterName());
            if (serviceNames3 == null) {
                serviceNames3 = Collections.newSetFromMap(new ConcurrentHashMap());
                this._simpleLoadBalancerState.getServicesPerCluster().put(pickedProperties.getClusterName(), serviceNames3);
            }
            serviceNames3.add(pickedProperties.getServiceName());
        } else if (oldServicePropertiesItem != null && (oldServiceProperties = oldServicePropertiesItem.getProperty()) != null && (serviceNames = this._simpleLoadBalancerState.getServicesPerCluster().get(oldServiceProperties.getClusterName())) != null) {
            serviceNames.remove(oldServiceProperties.getServiceName());
        }
        if (discoveryProperties == null) {
            _log.warn("We receive a null service properties for {}. ", (Object)listenTo);
        }
    }

    @Override
    protected void handleRemove(String listenTo) {
        _log.warn("Received a service properties event to remove() for service = " + listenTo);
        LoadBalancerStateItem<ServiceProperties> serviceItem = this._simpleLoadBalancerState.getServiceProperties().remove(listenTo);
        if (serviceItem != null && serviceItem.getProperty() != null) {
            ServiceProperties serviceProperties = serviceItem.getProperty();
            Set<String> serviceNames = this._simpleLoadBalancerState.getServicesPerCluster().get(serviceProperties.getClusterName());
            if (serviceNames != null) {
                serviceNames.remove(serviceProperties.getServiceName());
            }
            this._simpleLoadBalancerState.notifyListenersOnServicePropertiesRemovals(serviceItem);
            this._simpleLoadBalancerState.shutdownClients(listenTo);
        }
    }

    private ActivePropertiesResult pickActiveProperties(ServiceProperties discoveryProperties) {
        ServiceProperties pickedProperties = discoveryProperties;
        CanaryDistributionProvider.Distribution distribution = CanaryDistributionProvider.Distribution.STABLE;
        if (discoveryProperties instanceof ServiceStoreProperties) {
            ServiceStoreProperties serviceStoreProperties = (ServiceStoreProperties)discoveryProperties;
            CanaryDistributionProvider canaryDistributionProvider = this._simpleLoadBalancerState.getCanaryDistributionProvider();
            if (serviceStoreProperties.hasCanary() && canaryDistributionProvider != null) {
                distribution = canaryDistributionProvider.distribute(CanaryDistributionStrategyConverter.toConfig(serviceStoreProperties.getCanaryDistributionStrategy()));
            }
            pickedProperties = serviceStoreProperties.getDistributedServiceProperties(distribution);
        }
        return new ActivePropertiesResult(distribution, pickedProperties);
    }

    private static class ActivePropertiesResult {
        final CanaryDistributionProvider.Distribution distribution;
        final ServiceProperties serviceProperties;

        ActivePropertiesResult(CanaryDistributionProvider.Distribution distribution, ServiceProperties serviceProperties) {
            this.distribution = distribution;
            this.serviceProperties = serviceProperties;
        }
    }
}

