/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.simple;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.DarkClusterConfigMap;
import com.linkedin.d2.balancer.KeyMapper;
import com.linkedin.d2.balancer.LoadBalancer;
import com.linkedin.d2.balancer.LoadBalancerClient;
import com.linkedin.d2.balancer.LoadBalancerClusterListener;
import com.linkedin.d2.balancer.LoadBalancerState;
import com.linkedin.d2.balancer.LoadBalancerStateItem;
import com.linkedin.d2.balancer.ServiceUnavailableException;
import com.linkedin.d2.balancer.WarmUpService;
import com.linkedin.d2.balancer.clients.RewriteLoadBalancerClient;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.clusterfailout.FailoutConfig;
import com.linkedin.d2.balancer.clusterfailout.FailoutConfigProvider;
import com.linkedin.d2.balancer.clusterfailout.FailoutConfigProviderFactory;
import com.linkedin.d2.balancer.properties.ClusterProperties;
import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.subsetting.SubsettingState;
import com.linkedin.d2.balancer.util.ClientFactoryProvider;
import com.linkedin.d2.balancer.util.ClusterInfoProvider;
import com.linkedin.d2.balancer.util.CustomAffinityRoutingURIProvider;
import com.linkedin.d2.balancer.util.HostOverrideList;
import com.linkedin.d2.balancer.util.HostToKeyMapper;
import com.linkedin.d2.balancer.util.KeysAndHosts;
import com.linkedin.d2.balancer.util.LoadBalancerUtil;
import com.linkedin.d2.balancer.util.MapKeyResult;
import com.linkedin.d2.balancer.util.hashing.HashFunction;
import com.linkedin.d2.balancer.util.hashing.HashRingProvider;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessException;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.PartitionInfoProvider;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.d2.discovery.util.Stats;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.http.client.TimeoutCallback;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLoadBalancer
implements LoadBalancer,
HashRingProvider,
ClientFactoryProvider,
PartitionInfoProvider,
WarmUpService,
ClusterInfoProvider {
    private static final String HOST_OVERRIDE_LIST = "HOST_OVERRIDE_LIST";
    private static final Logger _log = LoggerFactory.getLogger(SimpleLoadBalancer.class);
    private static final String D2_SCHEME_NAME = "d2";
    private final LoadBalancerState _state;
    private final Stats _serviceUnavailableStats;
    private final Stats _serviceAvailableStats;
    private final long _timeout;
    private final TimeUnit _unit;
    private final ScheduledExecutorService _executor;
    private final Random _random = new Random();
    private final FailoutConfigProvider _failoutConfigProvider;

    public SimpleLoadBalancer(LoadBalancerState state, ScheduledExecutorService executorService) {
        this(state, new Stats(1000L), new Stats(1000L), 0L, TimeUnit.SECONDS, executorService, null);
    }

    public SimpleLoadBalancer(LoadBalancerState state, long timeout, TimeUnit unit, ScheduledExecutorService executor) {
        this(state, new Stats(1000L), new Stats(1000L), timeout, unit, executor, null);
    }

    public SimpleLoadBalancer(LoadBalancerState state, long timeout, TimeUnit unit, ScheduledExecutorService executor, FailoutConfigProviderFactory failoutConfigProviderFactory) {
        this(state, new Stats(1000L), new Stats(1000L), timeout, unit, executor, failoutConfigProviderFactory);
    }

    public SimpleLoadBalancer(LoadBalancerState state, Stats serviceAvailableStats, Stats serviceUnavailableStats, long timeout, TimeUnit unit, ScheduledExecutorService executor, FailoutConfigProviderFactory failoutConfigProviderFactory) {
        this._state = state;
        this._serviceUnavailableStats = serviceUnavailableStats;
        this._serviceAvailableStats = serviceAvailableStats;
        this._timeout = timeout;
        this._unit = unit;
        this._executor = executor;
        if (failoutConfigProviderFactory != null) {
            this._failoutConfigProvider = failoutConfigProviderFactory.create(state);
            _log.debug("Created failoutConfigProvider.");
        } else {
            this._failoutConfigProvider = null;
        }
    }

    public Stats getServiceUnavailableStats() {
        return this._serviceUnavailableStats;
    }

    public Stats getServiceAvailableStats() {
        return this._serviceAvailableStats;
    }

    @Override
    public void start(final Callback<None> callback) {
        this._state.start(new Callback<None>(){

            public void onError(Throwable e) {
                callback.onError(e);
            }

            public void onSuccess(None result) {
                if (SimpleLoadBalancer.this._failoutConfigProvider != null) {
                    SimpleLoadBalancer.this._failoutConfigProvider.start();
                    _log.info("Started failoutConfigProvider.");
                }
                callback.onSuccess((Object)result);
            }
        });
    }

    @Override
    public void shutdown(PropertyEventThread.PropertyEventShutdownCallback shutdown) {
        this._state.shutdown(() -> {
            if (this._failoutConfigProvider != null) {
                this._failoutConfigProvider.shutdown();
            }
            shutdown.done();
        });
    }

    @Override
    public void getClient(Request request, RequestContext requestContext, Callback<TransportClient> clientCallback) {
        URI uri = request.getURI();
        LogUtil.debug(_log, "get client for uri: ", uri);
        if (!D2_SCHEME_NAME.equalsIgnoreCase(uri.getScheme())) {
            throw new IllegalArgumentException("Unsupported scheme in URI " + uri);
        }
        String extractedServiceName = LoadBalancerUtil.getServiceNameFromUri(uri);
        this.listenToServiceAndCluster(extractedServiceName, (Callback<ServiceProperties>)Callbacks.handle(service -> {
            String serviceName = service.getServiceName();
            String clusterName = service.getClusterName();
            try {
                URI override;
                ClusterProperties cluster = this.getClusterProperties(serviceName, clusterName);
                URI targetService = LoadBalancerUtil.TargetHints.getRequestContextTargetService(requestContext);
                HostOverrideList overrides = (HostOverrideList)requestContext.getLocalAttr(HOST_OVERRIDE_LIST);
                URI uRI = override = overrides == null ? null : overrides.getOverride(clusterName, serviceName);
                if (targetService == null && override == null) {
                    LoadBalancerStateItem<UriProperties> uriItem = this.getUriItem(serviceName, clusterName, cluster);
                    UriProperties uris = uriItem.getProperty();
                    List<LoadBalancerState.SchemeStrategyPair> orderedStrategies = this._state.getStrategiesForService(serviceName, service.getPrioritizedSchemes());
                    LoadBalancerClient trackerClient = null;
                    CustomAffinityRoutingURIProvider customAffinityRoutingURIProvider = (CustomAffinityRoutingURIProvider)requestContext.getLocalAttr("D2_CUSTOM_AFFINITY_ROUTING_URI_PROVIDER");
                    boolean enableCustomAffinityRouting = this.isCustomAffinityRoutingEnabled(requestContext, customAffinityRoutingURIProvider);
                    if (enableCustomAffinityRouting) {
                        trackerClient = customAffinityRoutingURIProvider.getTargetHostURI(clusterName).map(targetHost -> this._state.getClient(serviceName, (URI)targetHost)).orElse(null);
                    }
                    if (trackerClient == null) {
                        trackerClient = this.chooseTrackerClient(request, requestContext, serviceName, clusterName, cluster, uriItem, uris, orderedStrategies, (ServiceProperties)service);
                        if (enableCustomAffinityRouting) {
                            customAffinityRoutingURIProvider.setTargetHostURI(clusterName, trackerClient.getUri());
                        }
                    }
                    String clusterAndServiceUriString = trackerClient.getUri() + service.getPath();
                    this._serviceAvailableStats.inc();
                    clientCallback.onSuccess((Object)new RewriteLoadBalancerClient(serviceName, URI.create(clusterAndServiceUriString), trackerClient));
                } else {
                    TransportClient transportClient;
                    URI target;
                    URI uRI2 = target = override == null ? targetService : URI.create(override + service.getPath());
                    if (targetService != null && override != null) {
                        _log.warn("Both TargetHints and HostOverrideList are found. HostOverList will take precedence %s.", (Object)target);
                    }
                    if (_log.isDebugEnabled()) {
                        _log.debug("Rewrite URI as specified in the TargetHints/HostOverrideList {} for cluster {} and service {}.", new Object[]{target, clusterName, serviceName});
                    }
                    if ((transportClient = this._state.getClient(serviceName, target.getScheme())) == null) {
                        throw new ServiceUnavailableException(serviceName, String.format("PEGA_1001. Cannot find transportClient for service %s and scheme %s with URI specified inTargetHints/HostOverrideList %s", serviceName, target.getScheme(), target));
                    }
                    clientCallback.onSuccess((Object)new RewriteLoadBalancerClient(serviceName, target, transportClient));
                }
            }
            catch (ServiceUnavailableException e) {
                clientCallback.onError((Throwable)((Object)e));
            }
        }, clientCallback));
    }

    private boolean isCustomAffinityRoutingEnabled(RequestContext requestContext, @Nullable CustomAffinityRoutingURIProvider affinityRoutingURIProvider) {
        return affinityRoutingURIProvider != null && affinityRoutingURIProvider.isEnabled() && KeyMapper.TargetHostHints.getRequestContextTargetHost(requestContext) == null;
    }

    @Override
    public <K> MapKeyResult<Ring<URI>, K> getRings(URI serviceUri, Iterable<K> keys) throws ServiceUnavailableException {
        ServiceProperties service = this.listenToServiceAndCluster(serviceUri);
        String serviceName = service.getServiceName();
        String clusterName = service.getClusterName();
        ClusterProperties cluster = this.getClusterProperties(serviceName, clusterName);
        LoadBalancerStateItem<UriProperties> uriItem = this.getUriItem(serviceName, clusterName, cluster);
        UriProperties uris = uriItem.getProperty();
        List<LoadBalancerState.SchemeStrategyPair> orderedStrategies = this._state.getStrategiesForService(serviceName, service.getPrioritizedSchemes());
        if (!orderedStrategies.isEmpty()) {
            PartitionAccessor accessor = this.getPartitionAccessor(serviceName, clusterName);
            HashMap<Integer, Set> partitionSet = new HashMap<Integer, Set>();
            ArrayList unmappedKeys = new ArrayList();
            for (K key : keys) {
                int partitionId;
                try {
                    partitionId = accessor.getPartitionId(key.toString());
                }
                catch (PartitionAccessException e) {
                    unmappedKeys.add(new MapKeyResult.UnmappedKey<K>(key, MapKeyResult.ErrorType.FAIL_TO_FIND_PARTITION));
                    continue;
                }
                Set set = partitionSet.computeIfAbsent(partitionId, k -> new HashSet());
                set.add(key);
            }
            HashMap ringMap = new HashMap(partitionSet.size() * 2);
            for (Map.Entry entry : partitionSet.entrySet()) {
                int partitionId = (Integer)entry.getKey();
                Ring<URI> ring = null;
                for (LoadBalancerState.SchemeStrategyPair pair : orderedStrategies) {
                    TrackerClientSubsetItem subsetItem = this.getPotentialClients(serviceName, service, cluster, uris, pair.getScheme(), partitionId, uriItem.getVersion());
                    ring = pair.getStrategy().getRing(uriItem.getVersion(), partitionId, subsetItem.getWeightedSubset(), subsetItem.shouldForceUpdate());
                    if (ring.isEmpty()) continue;
                    break;
                }
                ringMap.put(ring, entry.getValue());
            }
            return new MapKeyResult(ringMap, unmappedKeys);
        }
        throw new ServiceUnavailableException(serviceName, "PEGA_1002. Unable to find a load balancer strategy. Server Schemes: [" + String.join((CharSequence)", ", service.getPrioritizedSchemes()) + ']');
    }

    @Override
    public TransportClientFactory getClientFactory(String scheme) {
        return ((ClientFactoryProvider)((Object)this._state)).getClientFactory(scheme);
    }

    @Override
    public Map<Integer, Ring<URI>> getRings(URI serviceUri) throws ServiceUnavailableException {
        ServiceProperties service = this.listenToServiceAndCluster(serviceUri);
        String serviceName = service.getServiceName();
        String clusterName = service.getClusterName();
        ClusterProperties cluster = this.getClusterProperties(serviceName, clusterName);
        LoadBalancerStateItem<UriProperties> uriItem = this.getUriItem(serviceName, clusterName, cluster);
        UriProperties uris = uriItem.getProperty();
        List<LoadBalancerState.SchemeStrategyPair> orderedStrategies = this._state.getStrategiesForService(serviceName, service.getPrioritizedSchemes());
        if (!orderedStrategies.isEmpty()) {
            PartitionAccessor accessor = this.getPartitionAccessor(serviceName, clusterName);
            int maxPartitionId = accessor.getMaxPartitionId();
            HashMap<Integer, Ring<URI>> ringMap = new HashMap<Integer, Ring<URI>>((maxPartitionId + 1) * 2);
            block0: for (int partitionId = 0; partitionId <= maxPartitionId; ++partitionId) {
                for (LoadBalancerState.SchemeStrategyPair pair : orderedStrategies) {
                    TrackerClientSubsetItem subsetItem = this.getPotentialClients(serviceName, service, cluster, uris, pair.getScheme(), partitionId, uriItem.getVersion());
                    Ring<URI> ring = pair.getStrategy().getRing(uriItem.getVersion(), partitionId, subsetItem.getWeightedSubset(), subsetItem.shouldForceUpdate());
                    ringMap.put(partitionId, ring);
                    if (ring.isEmpty()) continue;
                    continue block0;
                }
            }
            return ringMap;
        }
        throw new ServiceUnavailableException(serviceName, "PEGA_1003. Unable to find a load balancer strategyServer Schemes: [" + String.join((CharSequence)", ", service.getPrioritizedSchemes()) + ']');
    }

    @Override
    public HashFunction<Request> getRequestHashFunction(String serviceName) throws ServiceUnavailableException {
        ServiceProperties service = this.listenToServiceAndCluster(serviceName);
        List<LoadBalancerState.SchemeStrategyPair> orderedStrategies = this._state.getStrategiesForService(serviceName, service.getPrioritizedSchemes());
        if (!orderedStrategies.isEmpty()) {
            return orderedStrategies.get(0).getStrategy().getHashFunction();
        }
        throw new ServiceUnavailableException(serviceName, "PEGA_1017. Unable to find a load balancer strategyServer Schemes: [" + String.join((CharSequence)", ", service.getPrioritizedSchemes()) + ']');
    }

    private void listenToServiceAndCluster(final String serviceName, Callback<ServiceProperties> callback) {
        boolean waitForUpdatedValue;
        boolean bl = waitForUpdatedValue = this._timeout > 0L;
        if (waitForUpdatedValue) {
            final TimeoutCallback finalCallback = callback;
            callback = new TimeoutCallback(this._executor, this._timeout, this._unit, (Callback)new Callback<ServiceProperties>(){

                public void onError(Throwable e) {
                    finalCallback.onError((Throwable)((Object)new ServiceUnavailableException(serviceName, "PEGA_1004. " + e.getMessage(), e)));
                }

                public void onSuccess(ServiceProperties result) {
                    finalCallback.onSuccess((Object)result);
                }
            }, "Timeout while fetching service");
        }
        this.listenToServiceAndCluster(serviceName, waitForUpdatedValue, (Callback<ServiceProperties>)callback);
    }

    private ServiceProperties listenToServiceAndCluster(URI uri) throws ServiceUnavailableException {
        if (!D2_SCHEME_NAME.equalsIgnoreCase(uri.getScheme())) {
            throw new IllegalArgumentException("Unsupported scheme in URI " + uri);
        }
        String serviceName = LoadBalancerUtil.getServiceNameFromUri(uri);
        return this.listenToServiceAndCluster(serviceName);
    }

    private ServiceProperties listenToServiceAndCluster(String serviceName) throws ServiceUnavailableException {
        FutureCallback servicePropertiesFutureCallback = new FutureCallback();
        boolean waitForUpdatedValue = this._timeout > 0L;
        this.listenToServiceAndCluster(serviceName, waitForUpdatedValue, (Callback<ServiceProperties>)servicePropertiesFutureCallback);
        try {
            return (ServiceProperties)servicePropertiesFutureCallback.get(this._timeout, this._unit);
        }
        catch (TimeoutException e) {
            throw new ServiceUnavailableException(serviceName, "PEGA_1005. Timeout occurred while fetching property. Timeout:" + this._timeout, e);
        }
        catch (Exception e) {
            throw new ServiceUnavailableException(serviceName, "PEGA_1006. Exception while fetching property. Message:" + e.getMessage(), e);
        }
    }

    private void listenToServiceAndCluster(String serviceName, boolean waitForUpdatedValue, Callback<ServiceProperties> callback) {
        this.getLoadBalancedServiceProperties(serviceName, waitForUpdatedValue, (Callback<ServiceProperties>)Callbacks.handle(service -> {
            String clusterName = service.getClusterName();
            this.listenToCluster(clusterName, waitForUpdatedValue, (type, name) -> callback.onSuccess(service));
        }, callback));
    }

    public void listenToCluster(String clusterName, boolean waitForUpdatedValue, LoadBalancerState.LoadBalancerStateListenerCallback callback) {
        if (waitForUpdatedValue) {
            this._state.listenToCluster(clusterName, callback);
        } else {
            this._state.listenToCluster(clusterName, new LoadBalancerState.NullStateListenerCallback());
            callback.done(0, null);
        }
    }

    @Override
    public void warmUpService(String serviceName, Callback<None> callback) {
        this.listenToServiceAndCluster(serviceName, true, (Callback<ServiceProperties>)Callbacks.handle(service -> callback.onSuccess((Object)None.none()), callback));
    }

    private LoadBalancerStateItem<UriProperties> getUriItem(String serviceName, String clusterName, ClusterProperties cluster) throws ServiceUnavailableException {
        LoadBalancerStateItem<UriProperties> uriItem = this._state.getUriProperties(clusterName);
        if (uriItem == null || uriItem.getProperty() == null) {
            LogUtil.warn(_log, "unable to find uris: ", clusterName);
            this.die(serviceName, "PEGA_1007. no uri properties in lb state. Check your service being announced correctly to ZK");
        }
        LogUtil.debug(_log, "got uris: ", cluster);
        return uriItem;
    }

    private ClusterProperties getClusterProperties(String serviceName, String clusterName) throws ServiceUnavailableException {
        LoadBalancerStateItem<ClusterProperties> clusterItem = this._state.getClusterProperties(clusterName);
        if (clusterItem == null || clusterItem.getProperty() == null) {
            LogUtil.warn(_log, "unable to find cluster: ", clusterName);
            this.die(serviceName, "PEGA_1008. no cluster properties in lb state for cluster: " + clusterName);
        }
        return clusterItem.getProperty();
    }

    @Override
    public <K> HostToKeyMapper<K> getPartitionInformation(URI serviceUri, Collection<K> keys, int limitHostPerPartition, int hash) throws ServiceUnavailableException {
        if (limitHostPerPartition <= 0) {
            throw new IllegalArgumentException("limitHostPartition cannot be 0 or less");
        }
        ServiceProperties service = this.listenToServiceAndCluster(serviceUri);
        String serviceName = service.getServiceName();
        String clusterName = service.getClusterName();
        ClusterProperties cluster = this.getClusterProperties(serviceName, clusterName);
        LoadBalancerStateItem<UriProperties> uriItem = this.getUriItem(serviceName, clusterName, cluster);
        UriProperties uris = uriItem.getProperty();
        List<LoadBalancerState.SchemeStrategyPair> orderedStrategies = this._state.getStrategiesForService(serviceName, service.getPrioritizedSchemes());
        HashMap<Integer, Integer> partitionWithoutEnoughHost = new HashMap<Integer, Integer>();
        if (!orderedStrategies.isEmpty()) {
            PartitionAccessor accessor = this.getPartitionAccessor(serviceName, clusterName);
            int maxPartitionId = accessor.getMaxPartitionId();
            ArrayList unmappedKeys = new ArrayList();
            Map<Integer, Set<K>> partitionSet = this.getPartitionSet(keys, accessor, unmappedKeys);
            HashMap<Integer, KeysAndHosts<Integer>> partitionDataMap = new HashMap<Integer, KeysAndHosts<Integer>>();
            block0: for (Integer partitionId : partitionSet.keySet()) {
                for (LoadBalancerState.SchemeStrategyPair pair : orderedStrategies) {
                    TrackerClientSubsetItem subsetItem = this.getPotentialClients(serviceName, service, cluster, uris, pair.getScheme(), partitionId, uriItem.getVersion());
                    Map<URI, TrackerClient> trackerClients = subsetItem.getWeightedSubset();
                    int size = Math.min(trackerClients.size(), limitHostPerPartition);
                    ArrayList<URI> rankedUri = new ArrayList<URI>(size);
                    Ring<URI> ring = pair.getStrategy().getRing(uriItem.getVersion(), partitionId, trackerClients, subsetItem.shouldForceUpdate());
                    Iterator<URI> iterator = ring.getIterator(hash);
                    while (iterator.hasNext() && rankedUri.size() < size) {
                        URI uri = iterator.next();
                        if (rankedUri.contains(uri)) continue;
                        rankedUri.add(uri);
                    }
                    if (rankedUri.size() < limitHostPerPartition) {
                        partitionWithoutEnoughHost.put(partitionId, limitHostPerPartition - rankedUri.size());
                    }
                    KeysAndHosts keysAndHosts = new KeysAndHosts((Collection)partitionSet.get(partitionId), rankedUri);
                    partitionDataMap.put(partitionId, keysAndHosts);
                    if (rankedUri.isEmpty()) continue;
                    continue block0;
                }
            }
            return new HostToKeyMapper(unmappedKeys, partitionDataMap, limitHostPerPartition, maxPartitionId + 1, partitionWithoutEnoughHost);
        }
        throw new ServiceUnavailableException(serviceName, "PEGA_1009. Unable to find a load balancer strategyServer Schemes: [" + String.join((CharSequence)", ", service.getPrioritizedSchemes()) + ']');
    }

    private <K> Map<Integer, Set<K>> getPartitionSet(Collection<K> keys, PartitionAccessor accessor, Collection<K> unmappedKeys) {
        TreeMap<Integer, Set<Integer>> partitionSet = new TreeMap<Integer, Set<Integer>>();
        if (keys == null) {
            for (int i = 0; i <= accessor.getMaxPartitionId(); ++i) {
                partitionSet.put(i, new HashSet());
            }
        } else {
            for (K key : keys) {
                int partitionId;
                try {
                    partitionId = accessor.getPartitionId(key.toString());
                }
                catch (PartitionAccessException e) {
                    unmappedKeys.add(key);
                    continue;
                }
                HashSet<K> set = (HashSet<K>)partitionSet.get(partitionId);
                if (set == null) {
                    set = new HashSet<K>();
                    partitionSet.put(partitionId, set);
                }
                set.add(key);
            }
        }
        return partitionSet;
    }

    @Override
    public PartitionAccessor getPartitionAccessor(String serviceName) throws ServiceUnavailableException {
        ServiceProperties service = this.listenToServiceAndCluster(serviceName);
        String clusterName = service.getClusterName();
        return this.getPartitionAccessor(serviceName, clusterName);
    }

    private PartitionAccessor getPartitionAccessor(String serviceName, String clusterName) throws ServiceUnavailableException {
        LoadBalancerStateItem<PartitionAccessor> partitionAccessorItem = this._state.getPartitionAccessor(clusterName);
        if (partitionAccessorItem == null || partitionAccessorItem.getProperty() == null) {
            LogUtil.warn(_log, "unable to find partition accessor for cluster: ", clusterName);
            this.die(serviceName, "PEGA_1010. No partition accessor available for cluster: " + clusterName);
        }
        return partitionAccessorItem.getProperty();
    }

    @Override
    public void getLoadBalancedServiceProperties(final String serviceName, Callback<ServiceProperties> callback) {
        boolean waitForUpdatedValue;
        boolean bl = waitForUpdatedValue = this._timeout > 0L;
        if (waitForUpdatedValue) {
            final TimeoutCallback finalCallback = callback;
            callback = new TimeoutCallback(this._executor, this._timeout, this._unit, (Callback)new Callback<ServiceProperties>(){

                public void onError(Throwable e) {
                    finalCallback.onError((Throwable)((Object)new ServiceUnavailableException(serviceName, "PEGA_1011. " + e.getMessage(), e)));
                }

                public void onSuccess(ServiceProperties result) {
                    finalCallback.onSuccess((Object)result);
                }
            }, "Timeout while fetching service");
        }
        this.getLoadBalancedServiceProperties(serviceName, waitForUpdatedValue, (Callback<ServiceProperties>)callback);
    }

    public void getLoadBalancedServiceProperties(String serviceName, boolean waitForUpdatedValue, Callback<ServiceProperties> servicePropertiesCallback) {
        Runnable callback = () -> {
            LoadBalancerStateItem<ServiceProperties> serviceItem = this._state.getServiceProperties(serviceName);
            if (serviceItem == null || serviceItem.getProperty() == null) {
                LogUtil.warn(_log, "unable to find service: ", serviceName);
                this.die(servicePropertiesCallback, serviceName, "PEGA_1012. no service properties in lb state");
                return;
            }
            LogUtil.debug(_log, "got service: ", serviceItem);
            servicePropertiesCallback.onSuccess((Object)serviceItem.getProperty());
        };
        if (waitForUpdatedValue) {
            this._state.listenToService(serviceName, (type, name) -> callback.run());
        } else {
            _log.info("No timeout for service {}", (Object)serviceName);
            this._state.listenToService(serviceName, new LoadBalancerState.NullStateListenerCallback());
            callback.run();
        }
    }

    private TrackerClientSubsetItem getPotentialClients(String serviceName, ServiceProperties serviceProperties, ClusterProperties clusterProperties, UriProperties uris, String scheme, int partitionId, long version) {
        Set<URI> possibleUris = uris.getUriBySchemeAndPartition(scheme, partitionId);
        Map<URI, Double> weightedUris = possibleUris == null ? Collections.emptyMap() : possibleUris.stream().collect(Collectors.toMap(uri -> uri, uri -> uris.getPartitionDataMap((URI)uri).get(partitionId).getWeight()));
        SubsettingState.SubsetItem subsetItem = serviceProperties.isEnableClusterSubsetting() ? this._state.getClientsSubset(serviceName, serviceProperties.getMinClusterSubsetSize(), partitionId, weightedUris, version) : new SubsettingState.SubsetItem(false, false, weightedUris, Collections.emptySet());
        Map<URI, TrackerClient> clientsToBalance = this.getPotentialClients(serviceName, serviceProperties, clusterProperties, possibleUris, partitionId, subsetItem);
        if (clientsToBalance.isEmpty()) {
            LogUtil.info(_log, "Can not find a host for service: ", serviceName, ", scheme: ", scheme, ", partition: ", partitionId);
        }
        return new TrackerClientSubsetItem(subsetItem.shouldForceUpdate(), clientsToBalance);
    }

    private Map<URI, TrackerClient> getPotentialClients(String serviceName, ServiceProperties serviceProperties, ClusterProperties clusterProperties, Set<URI> possibleUris, int partitionId, SubsettingState.SubsetItem subsetItem) {
        Map<URI, TrackerClient> clientsToLoadBalance;
        if (possibleUris == null) {
            clientsToLoadBalance = Collections.emptyMap();
        } else {
            Map<URI, Double> weightedSubset = subsetItem.getWeightedUriSubset();
            Set<URI> doNotSlowStartUris = subsetItem.getDoNotSlowStartUris();
            clientsToLoadBalance = new HashMap(possibleUris.size());
            for (URI possibleUri : possibleUris) {
                if (!serviceProperties.isBanned(possibleUri) && !clusterProperties.isBanned(possibleUri)) {
                    TrackerClient possibleTrackerClient;
                    if (!weightedSubset.containsKey(possibleUri) || (possibleTrackerClient = this._state.getClient(serviceName, possibleUri)) == null) continue;
                    if (doNotSlowStartUris.contains(possibleUri)) {
                        possibleTrackerClient.setDoNotSlowStart(true);
                    }
                    if (subsetItem.isWeightedSubset()) {
                        possibleTrackerClient.setSubsetWeight(partitionId, weightedSubset.get(possibleUri));
                    }
                    clientsToLoadBalance.put(possibleUri, possibleTrackerClient);
                    continue;
                }
                LogUtil.warn(_log, "skipping banned uri: ", possibleUri);
            }
        }
        LogUtil.debug(_log, "got clients to load balancer for ", serviceName, ": ", clientsToLoadBalance);
        return clientsToLoadBalance;
    }

    private TrackerClient chooseTrackerClient(Request request, RequestContext requestContext, String serviceName, String clusterName, ClusterProperties cluster, LoadBalancerStateItem<UriProperties> uriItem, UriProperties uris, List<LoadBalancerState.SchemeStrategyPair> orderedStrategies, ServiceProperties serviceProperties) throws ServiceUnavailableException {
        TrackerClient trackerClient = null;
        URI targetHost = KeyMapper.TargetHostHints.getRequestContextTargetHost(requestContext);
        int partitionId = -1;
        URI requestUri = request.getURI();
        if (targetHost == null) {
            PartitionAccessor accessor = this.getPartitionAccessor(serviceName, clusterName);
            try {
                partitionId = accessor.getPartitionId(requestUri);
            }
            catch (PartitionAccessException e) {
                LogUtil.debug(_log, "PEGA_1013. Mapped URI to default partition as there was error in finding the partition for URI: " + requestUri + ", in cluster: " + clusterName + ", " + e.getMessage());
                partitionId = 0;
            }
        } else {
            Map<Integer, PartitionData> partitionDataMap = uris.getPartitionDataMap(targetHost);
            if (partitionDataMap == null || partitionDataMap.isEmpty()) {
                this.die(serviceName, "PEGA_1014. There is no partition data for server host: " + targetHost + ". URI: " + requestUri);
            }
            Set<Integer> partitions = partitionDataMap.keySet();
            Iterator<Integer> iterator = partitions.iterator();
            int index = this._random.nextInt(partitions.size());
            for (int i = 0; i <= index; ++i) {
                partitionId = iterator.next();
            }
        }
        Map<URI, TrackerClient> clientsToLoadBalance = null;
        for (LoadBalancerState.SchemeStrategyPair pair : orderedStrategies) {
            LoadBalancerStrategy strategy = pair.getStrategy();
            String scheme = pair.getScheme();
            TrackerClientSubsetItem subsetItem = this.getPotentialClients(serviceName, serviceProperties, cluster, uris, scheme, partitionId, uriItem.getVersion());
            clientsToLoadBalance = subsetItem.getWeightedSubset();
            trackerClient = strategy.getTrackerClient(request, requestContext, uriItem.getVersion(), partitionId, clientsToLoadBalance, subsetItem.shouldForceUpdate());
            LogUtil.debug(_log, "load balancer strategy for ", serviceName, " returned: ", trackerClient);
            if (trackerClient == null) continue;
            break;
        }
        if (trackerClient == null) {
            if (clientsToLoadBalance == null || clientsToLoadBalance.isEmpty()) {
                String requestedSchemes = orderedStrategies.stream().map(LoadBalancerState.SchemeStrategyPair::getScheme).collect(Collectors.joining(","));
                this.die(serviceName, "PEGA_1015. Service: " + serviceName + " unable to find a host to route the request in partition: " + partitionId + " cluster: " + clusterName + " scheme: [" + requestedSchemes + "], total hosts in cluster: " + uris.Uris().size() + ". Check what cluster and scheme your servers are announcing to.");
            } else {
                this.die(serviceName, "PEGA_1016. Service: " + serviceName + " is in a bad state (high latency/high error). Dropping request. Cluster: " + clusterName + ", partitionId:" + partitionId + " (choosable: " + clientsToLoadBalance.size() + " hosts, total in cluster: " + uris.Uris().size() + ")");
            }
        }
        return trackerClient;
    }

    private void die(String serviceName, String message) throws ServiceUnavailableException {
        this._serviceUnavailableStats.inc();
        throw new ServiceUnavailableException(serviceName, message);
    }

    private void die(Callback<?> callback, String serviceName, String message) {
        this._serviceUnavailableStats.inc();
        callback.onError((Throwable)((Object)new ServiceUnavailableException(serviceName, message)));
    }

    @Override
    public int getClusterCount(String clusterName, String scheme, int partitionId) throws ServiceUnavailableException {
        FutureCallback clusterCountFutureCallback = new FutureCallback();
        this._state.listenToCluster(clusterName, (type, name) -> {
            if (this._state.getUriProperties(clusterName).getProperty() != null) {
                Set<URI> uris = this._state.getUriProperties(clusterName).getProperty().getUriBySchemeAndPartition(scheme, partitionId);
                clusterCountFutureCallback.onSuccess((Object)(uris != null ? uris.size() : 0));
            } else {
                clusterCountFutureCallback.onSuccess((Object)0);
            }
        });
        try {
            return (Integer)clusterCountFutureCallback.get(this._timeout, this._unit);
        }
        catch (IllegalStateException | InterruptedException | ExecutionException | TimeoutException e) {
            this.die("ClusterInfo", "PEGA_1017, unable to retrieve cluster count for cluster: " + clusterName + ", scheme: " + scheme + ", partition: " + partitionId + ", exception: " + e);
            return -1;
        }
    }

    @Override
    public DarkClusterConfigMap getDarkClusterConfigMap(String clusterName) throws ServiceUnavailableException {
        FutureCallback darkClusterConfigMapFutureCallback = new FutureCallback();
        this.getDarkClusterConfigMap(clusterName, (Callback<DarkClusterConfigMap>)darkClusterConfigMapFutureCallback);
        try {
            return (DarkClusterConfigMap)darkClusterConfigMapFutureCallback.get(this._timeout, this._unit);
        }
        catch (IllegalStateException | InterruptedException | ExecutionException | TimeoutException e) {
            this.die("ClusterInfo", "PEGA_1018, unable to retrieve dark cluster info for cluster: " + clusterName + ", exception: " + e);
            return new DarkClusterConfigMap();
        }
    }

    @Override
    public void getDarkClusterConfigMap(String clusterName, Callback<DarkClusterConfigMap> callback) {
        TimeoutCallback wrappedCallback = new TimeoutCallback(this._executor, this._timeout, this._unit, callback);
        this._state.listenToCluster(clusterName, (arg_0, arg_1) -> this.lambda$getDarkClusterConfigMap$12(clusterName, (Callback)wrappedCallback, arg_0, arg_1));
    }

    @Override
    public FailoutConfig getFailoutConfig(String clusterName) {
        return this._failoutConfigProvider != null ? this._failoutConfigProvider.getFailoutConfig(clusterName) : null;
    }

    @Override
    public void registerClusterListener(LoadBalancerClusterListener clusterListener) {
        this._state.registerClusterListener(clusterListener);
    }

    @Override
    public void unregisterClusterListener(LoadBalancerClusterListener clusterListener) {
        this._state.unregisterClusterListener(clusterListener);
    }

    private /* synthetic */ void lambda$getDarkClusterConfigMap$12(String clusterName, Callback wrappedCallback, int type, String name) {
        ClusterProperties clusterProperties = this._state.getClusterProperties(clusterName).getProperty();
        DarkClusterConfigMap darkClusterConfigMap = clusterProperties != null ? clusterProperties.accessDarkClusters() : new DarkClusterConfigMap();
        wrappedCallback.onSuccess((Object)darkClusterConfigMap);
    }

    public static class TrackerClientSubsetItem {
        private final boolean _shouldForceUpdate;
        private final Map<URI, TrackerClient> _trackerClientMap;

        public TrackerClientSubsetItem(boolean shouldForceUpdate, Map<URI, TrackerClient> trackerClientMap) {
            this._shouldForceUpdate = shouldForceUpdate;
            this._trackerClientMap = trackerClientMap;
        }

        public boolean shouldForceUpdate() {
            return this._shouldForceUpdate;
        }

        public Map<URI, TrackerClient> getWeightedSubset() {
            return this._trackerClientMap;
        }
    }

    public static class SimpleLoadBalancerCountDownCallback
    implements LoadBalancerState.LoadBalancerStateListenerCallback {
        private CountDownLatch _latch;

        public SimpleLoadBalancerCountDownCallback(CountDownLatch latch) {
            this._latch = latch;
        }

        @Override
        public void done(int type, String name) {
            this._latch.countDown();
        }
    }
}

