/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.simple;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.common.callback.SimpleCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.LoadBalancerClusterListener;
import com.linkedin.d2.balancer.LoadBalancerState;
import com.linkedin.d2.balancer.LoadBalancerStateItem;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.clients.TrackerClientFactory;
import com.linkedin.d2.balancer.properties.ClusterProperties;
import com.linkedin.d2.balancer.properties.FailoutProperties;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.simple.ClusterAwareTransportClient;
import com.linkedin.d2.balancer.simple.ClusterInfoItem;
import com.linkedin.d2.balancer.simple.ClusterLoadBalancerSubscriber;
import com.linkedin.d2.balancer.simple.ServiceLoadBalancerSubscriber;
import com.linkedin.d2.balancer.simple.SslSessionValidatorFactory;
import com.linkedin.d2.balancer.simple.UriLoadBalancerSubscriber;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.subsetting.DeterministicSubsettingMetadataProvider;
import com.linkedin.d2.balancer.subsetting.SubsettingState;
import com.linkedin.d2.balancer.subsetting.SubsettingStrategyFactoryImpl;
import com.linkedin.d2.balancer.util.ClientFactoryProvider;
import com.linkedin.d2.balancer.util.LoadBalancerUtil;
import com.linkedin.d2.balancer.util.canary.CanaryDistributionProvider;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessorRegistry;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessorRegistryImpl;
import com.linkedin.d2.discovery.event.PropertyEventBus;
import com.linkedin.d2.discovery.event.PropertyEventBusImpl;
import com.linkedin.d2.discovery.event.PropertyEventPublisher;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.internal.common.util.CollectionUtils;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLoadBalancerState
implements LoadBalancerState,
ClientFactoryProvider {
    private static final int LOG_SUBSET_MAX_SIZE = 20;
    private static final Logger _log = LoggerFactory.getLogger(SimpleLoadBalancerState.class);
    private final UriLoadBalancerSubscriber _uriSubscriber;
    private final ClusterLoadBalancerSubscriber _clusterSubscriber;
    private final ServiceLoadBalancerSubscriber _serviceSubscriber;
    private final Map<String, LoadBalancerStateItem<UriProperties>> _uriProperties;
    private final Map<String, ClusterInfoItem> _clusterInfo;
    private final Map<String, LoadBalancerStateItem<ServiceProperties>> _serviceProperties;
    private final AtomicLong _version;
    private final Map<String, Set<String>> _servicesPerCluster;
    private final ScheduledExecutorService _executor;
    private final List<SimpleLoadBalancerStateListener> _listeners;
    private volatile long _delayedExecution;
    private final Map<String, Map<URI, TrackerClient>> _trackerClients;
    private final Map<String, Map<String, TransportClient>> _serviceClients;
    private final Map<String, TransportClientFactory> _clientFactories;
    private final Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> _loadBalancerStrategyFactories;
    private final Map<String, Map<String, LoadBalancerStrategy>> _serviceStrategies;
    private final Map<String, List<LoadBalancerState.SchemeStrategyPair>> _serviceStrategiesCache;
    private final List<LoadBalancerClusterListener> _clusterListeners;
    private final SSLContext _sslContext;
    private final SSLParameters _sslParameters;
    private final boolean _isSSLEnabled;
    private final SslSessionValidatorFactory _sslSessionValidatorFactory;
    private final SubsettingState _subsettingState;
    private final CanaryDistributionProvider _canaryDistributionProvider;

    public SimpleLoadBalancerState(ScheduledExecutorService executorService, PropertyEventPublisher<UriProperties> uriPublisher, PropertyEventPublisher<ClusterProperties> clusterPublisher, PropertyEventPublisher<ServiceProperties> servicePublisher, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories) {
        this(executorService, uriPublisher, clusterPublisher, servicePublisher, clientFactories, loadBalancerStrategyFactories, null, null, false);
    }

    public SimpleLoadBalancerState(ScheduledExecutorService executorService, PropertyEventPublisher<UriProperties> uriPublisher, PropertyEventPublisher<ClusterProperties> clusterPublisher, PropertyEventPublisher<ServiceProperties> servicePublisher, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories, SSLContext sslContext, SSLParameters sslParameters, boolean isSSLEnabled) {
        this(executorService, new PropertyEventBusImpl<UriProperties>(executorService, uriPublisher), new PropertyEventBusImpl<ClusterProperties>(executorService, clusterPublisher), new PropertyEventBusImpl<ServiceProperties>(executorService, servicePublisher), clientFactories, loadBalancerStrategyFactories, sslContext, sslParameters, isSSLEnabled, Collections.emptyMap(), new PartitionAccessorRegistryImpl(), (List<String> validationStrings) -> null);
    }

    public SimpleLoadBalancerState(ScheduledExecutorService executorService, PropertyEventBus<UriProperties> uriBus, PropertyEventBus<ClusterProperties> clusterBus, PropertyEventBus<ServiceProperties> serviceBus, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories, SSLContext sslContext, SSLParameters sslParameters, boolean isSSLEnabled) {
        this(executorService, uriBus, clusterBus, serviceBus, clientFactories, loadBalancerStrategyFactories, sslContext, sslParameters, isSSLEnabled, new PartitionAccessorRegistryImpl(), validationStrings -> null);
    }

    public SimpleLoadBalancerState(ScheduledExecutorService executorService, PropertyEventBus<UriProperties> uriBus, PropertyEventBus<ClusterProperties> clusterBus, PropertyEventBus<ServiceProperties> serviceBus, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories, SSLContext sslContext, SSLParameters sslParameters, boolean isSSLEnabled, Map<String, Map<String, Object>> clientServicesConfig, PartitionAccessorRegistry partitionAccessorRegistry, SslSessionValidatorFactory sessionValidatorFactory) {
        this(executorService, uriBus, clusterBus, serviceBus, clientFactories, loadBalancerStrategyFactories, sslContext, sslParameters, isSSLEnabled, partitionAccessorRegistry, sessionValidatorFactory);
    }

    public SimpleLoadBalancerState(ScheduledExecutorService executorService, PropertyEventBus<UriProperties> uriBus, PropertyEventBus<ClusterProperties> clusterBus, PropertyEventBus<ServiceProperties> serviceBus, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories, SSLContext sslContext, SSLParameters sslParameters, boolean isSSLEnabled, PartitionAccessorRegistry partitionAccessorRegistry, SslSessionValidatorFactory sessionValidatorFactory) {
        this(executorService, uriBus, clusterBus, serviceBus, clientFactories, loadBalancerStrategyFactories, sslContext, sslParameters, isSSLEnabled, partitionAccessorRegistry, sessionValidatorFactory, null);
    }

    public SimpleLoadBalancerState(ScheduledExecutorService executorService, PropertyEventBus<UriProperties> uriBus, PropertyEventBus<ClusterProperties> clusterBus, PropertyEventBus<ServiceProperties> serviceBus, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories, SSLContext sslContext, SSLParameters sslParameters, boolean isSSLEnabled, PartitionAccessorRegistry partitionAccessorRegistry, SslSessionValidatorFactory sessionValidatorFactory, DeterministicSubsettingMetadataProvider deterministicSubsettingMetadataProvider) {
        this(executorService, uriBus, clusterBus, serviceBus, clientFactories, loadBalancerStrategyFactories, sslContext, sslParameters, isSSLEnabled, partitionAccessorRegistry, sessionValidatorFactory, deterministicSubsettingMetadataProvider, null);
    }

    public SimpleLoadBalancerState(ScheduledExecutorService executorService, PropertyEventBus<UriProperties> uriBus, PropertyEventBus<ClusterProperties> clusterBus, PropertyEventBus<ServiceProperties> serviceBus, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories, SSLContext sslContext, SSLParameters sslParameters, boolean isSSLEnabled, PartitionAccessorRegistry partitionAccessorRegistry, SslSessionValidatorFactory sessionValidatorFactory, DeterministicSubsettingMetadataProvider deterministicSubsettingMetadataProvider, CanaryDistributionProvider canaryDistributionProvider) {
        this._executor = executorService;
        this._uriProperties = new ConcurrentHashMap<String, LoadBalancerStateItem<UriProperties>>();
        this._clusterInfo = new ConcurrentHashMap<String, ClusterInfoItem>();
        this._serviceProperties = new ConcurrentHashMap<String, LoadBalancerStateItem<ServiceProperties>>();
        this._version = new AtomicLong(0L);
        this._uriSubscriber = new UriLoadBalancerSubscriber(uriBus, this);
        this._clusterSubscriber = new ClusterLoadBalancerSubscriber(this, clusterBus, partitionAccessorRegistry);
        this._serviceSubscriber = new ServiceLoadBalancerSubscriber(serviceBus, this);
        this._clientFactories = Collections.unmodifiableMap(new HashMap<String, TransportClientFactory>(clientFactories));
        this._loadBalancerStrategyFactories = Collections.unmodifiableMap(new HashMap<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>>(loadBalancerStrategyFactories));
        this._servicesPerCluster = new ConcurrentHashMap<String, Set<String>>();
        this._serviceStrategies = new ConcurrentHashMap<String, Map<String, LoadBalancerStrategy>>();
        this._serviceStrategiesCache = new ConcurrentHashMap<String, List<LoadBalancerState.SchemeStrategyPair>>();
        this._trackerClients = new ConcurrentHashMap<String, Map<URI, TrackerClient>>();
        this._serviceClients = new ConcurrentHashMap<String, Map<String, TransportClient>>();
        this._listeners = Collections.synchronizedList(new ArrayList());
        this._delayedExecution = 1000L;
        this._sslContext = sslContext;
        this._sslParameters = sslParameters;
        this._isSSLEnabled = isSSLEnabled;
        this._sslSessionValidatorFactory = sessionValidatorFactory;
        this._clusterListeners = Collections.synchronizedList(new ArrayList());
        this._subsettingState = deterministicSubsettingMetadataProvider != null ? new SubsettingState(new SubsettingStrategyFactoryImpl(), deterministicSubsettingMetadataProvider) : null;
        this._canaryDistributionProvider = canaryDistributionProvider;
    }

    public void register(final SimpleLoadBalancerStateListener listener) {
        LogUtil.trace(_log, "register listener: ", listener);
        this._executor.execute(new PropertyEventThread.PropertyEvent("add listener for state"){

            @Override
            public void innerRun() {
                SimpleLoadBalancerState.this._listeners.add(listener);
            }
        });
    }

    public void unregister(final SimpleLoadBalancerStateListener listener) {
        LogUtil.trace(_log, "unregister listener: ", listener);
        this._executor.execute(new PropertyEventThread.PropertyEvent("remove listener for state"){

            @Override
            public void innerRun() {
                SimpleLoadBalancerState.this._listeners.remove(listener);
            }
        });
    }

    @Override
    public void registerClusterListener(final LoadBalancerClusterListener listener) {
        LogUtil.trace(_log, "register listener: ", listener);
        this._executor.execute(new PropertyEventThread.PropertyEvent("add cluster listener for state"){

            @Override
            public void innerRun() {
                if (!SimpleLoadBalancerState.this._clusterListeners.contains(listener)) {
                    SimpleLoadBalancerState.this._clusterListeners.add(listener);
                }
            }
        });
    }

    @Override
    public void unregisterClusterListener(final LoadBalancerClusterListener listener) {
        LogUtil.trace(_log, "unregister listener: ", listener);
        this._executor.execute(new PropertyEventThread.PropertyEvent("remove cluster listener for state"){

            @Override
            public void innerRun() {
                SimpleLoadBalancerState.this._clusterListeners.remove(listener);
            }
        });
    }

    @Override
    public void start(Callback<None> callback) {
        callback.onSuccess((Object)None.none());
    }

    @Override
    public void shutdown(final PropertyEventThread.PropertyEventShutdownCallback shutdown) {
        LogUtil.trace(_log, "shutdown");
        this._executor.execute(new PropertyEventThread.PropertyEvent("shutdown load balancer state"){

            @Override
            public void innerRun() {
                for (Object strategyEntry : SimpleLoadBalancerState.this._serviceStrategies.values()) {
                    strategyEntry.values().forEach(LoadBalancerStrategy::shutdown);
                }
                HashSet transportClients = new HashSet();
                for (Map clientsByScheme : SimpleLoadBalancerState.this._serviceClients.values()) {
                    transportClients.addAll(clientsByScheme.values());
                }
                Callback trackerCallback = Callbacks.countDown((Callback)Callbacks.adaptSimple((SimpleCallback)new SimpleCallback(){

                    public void onDone() {
                        shutdown.done();
                    }
                }), (int)transportClients.size());
                LogUtil.info(_log, "shutting down cluster clients");
                for (TransportClient transportClient : transportClients) {
                    transportClient.shutdown(trackerCallback);
                }
                for (SimpleLoadBalancerStateListener listener : SimpleLoadBalancerState.this._listeners) {
                    for (LoadBalancerStateItem loadBalancerStateItem : SimpleLoadBalancerState.this._serviceProperties.values()) {
                        listener.onServicePropertiesRemoval(loadBalancerStateItem);
                    }
                    for (ClusterInfoItem clusterInfoItem : SimpleLoadBalancerState.this._clusterInfo.values()) {
                        listener.onClusterInfoRemoval(clusterInfoItem);
                    }
                    for (Map.Entry entry : SimpleLoadBalancerState.this._serviceStrategies.entrySet()) {
                        for (Map.Entry strategyEntry : ((Map)entry.getValue()).entrySet()) {
                            listener.onStrategyRemoved((String)entry.getKey(), (String)strategyEntry.getKey(), (LoadBalancerStrategy)strategyEntry.getValue());
                        }
                        Map trackerClients = (Map)SimpleLoadBalancerState.this._trackerClients.get(entry.getKey());
                        if (trackerClients == null) continue;
                        for (TrackerClient client : trackerClients.values()) {
                            listener.onClientRemoved((String)entry.getKey(), client);
                        }
                    }
                }
                for (LoadBalancerClusterListener clusterListener : SimpleLoadBalancerState.this._clusterListeners) {
                    for (String string : SimpleLoadBalancerState.this._clusterInfo.keySet()) {
                        clusterListener.onClusterRemoved(string);
                    }
                }
            }
        });
    }

    @Override
    public void listenToService(String serviceName, LoadBalancerState.LoadBalancerStateListenerCallback callback) {
        LogUtil.trace(_log, "listenToService: ", serviceName);
        this._serviceSubscriber.ensureListening(serviceName, callback);
    }

    @Override
    public void listenToCluster(final String clusterName, final LoadBalancerState.LoadBalancerStateListenerCallback callback) {
        LogUtil.trace(_log, "listenToCluster: ", clusterName);
        LoadBalancerState.LoadBalancerStateListenerCallback wrappedCallback = new LoadBalancerState.LoadBalancerStateListenerCallback(){
            private final AtomicInteger _count = new AtomicInteger(2);

            @Override
            public void done(int type, String name) {
                if (this._count.decrementAndGet() <= 0) {
                    callback.done(type, clusterName);
                }
            }
        };
        this._clusterSubscriber.ensureListening(clusterName, wrappedCallback);
        this._uriSubscriber.ensureListening(clusterName, wrappedCallback);
    }

    @Override
    public LoadBalancerStateItem<UriProperties> getUriProperties(String clusterName) {
        return this._uriProperties.get(clusterName);
    }

    @Override
    public LoadBalancerStateItem<ClusterProperties> getClusterProperties(String clusterName) {
        ClusterInfoItem clusterInfoItem = this._clusterInfo.get(clusterName);
        return clusterInfoItem == null ? null : clusterInfoItem.getClusterPropertiesItem();
    }

    @Override
    public LoadBalancerStateItem<FailoutProperties> getFailoutProperties(String clusterName) {
        ClusterInfoItem clusterInfoItem = this._clusterInfo.get(clusterName);
        return clusterInfoItem == null ? null : clusterInfoItem.getFailoutPropertiesItem();
    }

    @Override
    public LoadBalancerStateItem<PartitionAccessor> getPartitionAccessor(String clusterName) {
        ClusterInfoItem clusterInfoItem = this._clusterInfo.get(clusterName);
        return clusterInfoItem == null ? null : clusterInfoItem.getPartitionAccessorItem();
    }

    @Override
    public LoadBalancerStateItem<ServiceProperties> getServiceProperties(String serviceName) {
        return this._serviceProperties.get(serviceName);
    }

    List<SimpleLoadBalancerStateListener> getListeners() {
        return this._listeners;
    }

    Map<String, Set<String>> getServicesPerCluster() {
        return this._servicesPerCluster;
    }

    Map<String, Map<URI, TrackerClient>> getTrackerClients() {
        return this._trackerClients;
    }

    Map<String, LoadBalancerStateItem<UriProperties>> getUriProperties() {
        return this._uriProperties;
    }

    Map<String, ClusterInfoItem> getClusterInfo() {
        return this._clusterInfo;
    }

    public Map<String, LoadBalancerStateItem<ServiceProperties>> getServiceProperties() {
        return this._serviceProperties;
    }

    public long getVersion() {
        return this._version.get();
    }

    public AtomicLong getVersionAccess() {
        return this._version;
    }

    public int getClusterCount() {
        return this._clusterInfo.size();
    }

    public int getClusterListenCount() {
        return this._clusterSubscriber.propertyListenCount();
    }

    public int getListenerCount() {
        return this._listeners.size();
    }

    public int getServiceCount() {
        return this._serviceProperties.size();
    }

    public int getServiceListenCount() {
        return this._serviceSubscriber.propertyListenCount();
    }

    public Set<String> getSupportedSchemes() {
        return this._clientFactories.keySet();
    }

    public Set<String> getSupportedStrategies() {
        return this._loadBalancerStrategyFactories.keySet();
    }

    public CanaryDistributionProvider getCanaryDistributionProvider() {
        return this._canaryDistributionProvider;
    }

    public int getTrackerClientCount(String clusterName) {
        Set<String> serviceNames = this._servicesPerCluster.get(clusterName);
        int count = 0;
        for (String serviceName : serviceNames) {
            count += ((Map)LoadBalancerUtil.getOrElse(this._trackerClients, serviceName, new HashMap())).size();
        }
        return count;
    }

    public Set<String> getServicesForCluster(String clusterName) {
        Set<String> services = this._servicesPerCluster.get(clusterName);
        if (services == null) {
            return Collections.emptySet();
        }
        return services;
    }

    public int getUriCount() {
        return this._uriProperties.size();
    }

    public void setVersion(final long version) {
        LogUtil.trace(_log, "setVersion: ", version);
        this._executor.execute(new PropertyEventThread.PropertyEvent("set version to: " + version){

            @Override
            public void innerRun() {
                LogUtil.info(_log, "set global version to: ", version);
                SimpleLoadBalancerState.this._version.set(version);
            }
        });
    }

    @Override
    public boolean isListeningToCluster(String clusterName) {
        return this._clusterSubscriber.isListeningToProperty(clusterName);
    }

    @Override
    public boolean isListeningToService(String serviceName) {
        return this._serviceSubscriber.isListeningToProperty(serviceName);
    }

    public long getDelayedExecution() {
        return this._delayedExecution;
    }

    public void setDelayedExecution(long delayedExecution) {
        this._delayedExecution = delayedExecution;
    }

    @Override
    public SubsettingState.SubsetItem getClientsSubset(String serviceName, int minClusterSubsetSize, int partitionId, Map<URI, Double> possibleUris, long version) {
        if (this._subsettingState == null) {
            return new SubsettingState.SubsetItem(false, false, possibleUris, Collections.emptySet());
        }
        SubsettingState.SubsetItem subsetItem = this._subsettingState.getClientsSubset(serviceName, minClusterSubsetSize, partitionId, possibleUris, version, this);
        LogUtil.debug(_log, "get cluster subset for service ", serviceName, ": [", subsetItem.getWeightedUriSubset().entrySet().stream().limit(20L).map(uri -> uri.getKey() + ":" + uri.getValue()).collect(Collectors.joining(",")), " (total ", subsetItem.getWeightedUriSubset().size(), ")], shouldForceUpdate = ", subsetItem.shouldForceUpdate());
        return subsetItem;
    }

    @Override
    public TrackerClient getClient(String serviceName, URI uri) {
        Map<URI, TrackerClient> trackerClients = this._trackerClients.get(serviceName);
        TrackerClient trackerClient = null;
        if (trackerClients != null) {
            trackerClient = trackerClients.get(uri);
        } else {
            LogUtil.warn(_log, "get client called on unknown service ", serviceName, ": ", uri);
        }
        return trackerClient;
    }

    public List<URI> getServerUrisForServiceName(String clusterName) {
        Map<URI, TrackerClient> trackerClients = this._trackerClients.get(clusterName);
        if (trackerClients == null) {
            return Collections.emptyList();
        }
        return new ArrayList<URI>(trackerClients.keySet());
    }

    @Override
    public TransportClient getClient(String serviceName, String scheme) {
        Map<String, TransportClient> transportClients = this._serviceClients.get(serviceName);
        TransportClient transportClient = null;
        if (transportClients != null) {
            transportClient = transportClients.get(scheme.toLowerCase());
            if (transportClient == null) {
                LogUtil.warn(_log, "no generic transport client for service " + serviceName + " and scheme: " + scheme);
            }
        } else {
            LogUtil.warn(_log, "get client called on unknown service ", serviceName);
        }
        return transportClient;
    }

    @Override
    public LoadBalancerStrategy getStrategy(String serviceName, String scheme) {
        Map<String, LoadBalancerStrategy> strategies = this._serviceStrategies.get(serviceName);
        LoadBalancerStrategy strategy = null;
        if (strategies != null) {
            strategy = strategies.get(scheme);
        } else {
            LogUtil.warn(_log, "get strategy called on unknown service ", serviceName);
        }
        return strategy;
    }

    @Override
    public List<LoadBalancerState.SchemeStrategyPair> getStrategiesForService(String serviceName, List<String> prioritizedSchemes) {
        List<LoadBalancerState.SchemeStrategyPair> cached = this._serviceStrategiesCache.get(serviceName);
        if (cached != null && !cached.isEmpty()) {
            return cached;
        }
        ArrayList<LoadBalancerState.SchemeStrategyPair> orderedStrategies = new ArrayList<LoadBalancerState.SchemeStrategyPair>(prioritizedSchemes.size());
        for (String scheme : prioritizedSchemes) {
            if ("https".equals(scheme) && !this._isSSLEnabled) continue;
            LoadBalancerStrategy strategy = this.getStrategy(serviceName, scheme);
            if (strategy != null) {
                orderedStrategies.add(new LoadBalancerState.SchemeStrategyPair(scheme, strategy));
                continue;
            }
            LogUtil.warn(_log, "unable to find a load balancer strategy for ", serviceName, " with scheme: ", scheme);
        }
        this._serviceStrategiesCache.put(serviceName, orderedStrategies);
        return orderedStrategies;
    }

    @Override
    public TransportClientFactory getClientFactory(String scheme) {
        return this._clientFactories.get(scheme);
    }

    void removeTrackerClients(String clusterName) {
        LogUtil.warn(_log, "removing all tracker clients for cluster: ", clusterName);
        Set<String> serviceNames = this._servicesPerCluster.get(clusterName);
        if (serviceNames != null) {
            for (String serviceName : serviceNames) {
                Map<URI, TrackerClient> clients = this._trackerClients.remove(serviceName);
                if (clients == null) continue;
                for (TrackerClient client : clients.values()) {
                    for (SimpleLoadBalancerStateListener listener : this._listeners) {
                        listener.onClientRemoved(serviceName, client);
                    }
                }
            }
        }
    }

    @Nullable
    public TrackerClient buildTrackerClient(URI uri, UriProperties uriProperties, String serviceName) {
        LoadBalancerStateItem<ServiceProperties> servicePropertiesItem = this._serviceProperties.get(serviceName);
        ServiceProperties serviceProperties = servicePropertiesItem == null ? null : servicePropertiesItem.getProperty();
        return this.buildTrackerClient(uri, uriProperties, serviceName, serviceProperties);
    }

    @Nullable
    private TrackerClient buildTrackerClient(URI uri, UriProperties uriProperties, String serviceName, ServiceProperties serviceProperties) {
        TransportClient transportClient = this.getTransportClient(serviceName, uri);
        LoadBalancerStrategy loadBalancerStrategy = this._serviceStrategies.get(serviceName).get(uri.getScheme().toLowerCase());
        if (transportClient == null) {
            return null;
        }
        if (loadBalancerStrategy == null) {
            return null;
        }
        return serviceProperties == null ? null : TrackerClientFactory.createTrackerClient(uri, uriProperties, serviceProperties, loadBalancerStrategy.getName(), transportClient);
    }

    @Nullable
    private TransportClient getTransportClient(String serviceName, URI uri) {
        Map<String, TransportClient> clientsByScheme = this._serviceClients.get(serviceName);
        if (clientsByScheme == null || uri == null || uri.getScheme() == null) {
            LogUtil.warn(_log, "Issue building client for service ", serviceName, " and uri ", uri);
            return null;
        }
        TransportClient client = clientsByScheme.get(uri.getScheme().toLowerCase());
        if (client == null) {
            LogUtil.debug(_log, "No TransportClient for scheme ", uri.getScheme(), " service ", serviceName, "URI ", uri);
            return null;
        }
        return client;
    }

    void refreshClients(ServiceProperties serviceProperties) {
        ConcurrentHashMap<URI, TrackerClient> newTrackerClients;
        UriProperties uriProperties;
        String serviceName = serviceProperties.getServiceName();
        Map<String, TransportClient> newTransportClients = this.createTransportClients(serviceProperties);
        newTransportClients = Collections.unmodifiableMap(newTransportClients);
        Map<String, TransportClient> oldTransportClients = this._serviceClients.put(serviceName, newTransportClients);
        LoadBalancerStateItem<UriProperties> uriItem = this._uriProperties.get(serviceProperties.getClusterName());
        UriProperties uriProperties2 = uriProperties = uriItem == null ? null : uriItem.getProperty();
        if (uriProperties != null) {
            Set<URI> uris = uriProperties.Uris();
            newTrackerClients = new ConcurrentHashMap(CollectionUtils.getMapInitialCapacity((int)uris.size(), (float)0.75f), 0.75f, 1);
            for (URI uri : uris) {
                TrackerClient trackerClient = this.buildTrackerClient(uri, uriProperties, serviceName, serviceProperties);
                if (trackerClient == null) continue;
                newTrackerClients.put(uri, trackerClient);
            }
        } else {
            newTrackerClients = new ConcurrentHashMap<URI, TrackerClient>();
        }
        this._trackerClients.put(serviceName, newTrackerClients);
        this.shutdownTransportClients(oldTransportClients, serviceName);
    }

    private Map<String, TransportClient> createTransportClients(ServiceProperties serviceProperties) {
        HashMap<String, Object> transportClientProperties = new HashMap<String, Object>(serviceProperties.getTransportClientProperties());
        List<String> schemes = serviceProperties.getPrioritizedSchemes();
        HashMap<String, TransportClient> newTransportClients = new HashMap<String, TransportClient>();
        if (schemes == null || schemes.isEmpty()) {
            LogUtil.warn(_log, "Prioritized schemes is null for service properties = ", serviceProperties.getServiceName());
            return newTransportClients;
        }
        for (String scheme : schemes) {
            TransportClientFactory factory = this._clientFactories.get(scheme);
            if ("https".equals(scheme)) {
                if (!this._isSSLEnabled) continue;
                if (this._sslContext != null && this._sslParameters != null) {
                    transportClientProperties.put("http.sslContext", this._sslContext);
                    transportClientProperties.put("http.sslParams", this._sslParameters);
                } else {
                    LogUtil.error(_log, "https specified as a prioritized scheme for service: ", serviceProperties.getServiceName(), " but no SSLContext or SSLParameters have been configured.");
                    if (schemes.size() != 1) continue;
                    throw new IllegalStateException("SSL enabled but required SSLContext and SSLParameterswere not both present.");
                }
            }
            if (factory == null) {
                LogUtil.warn(_log, "Failed to find client factory for scheme ", scheme);
                continue;
            }
            String clusterName = serviceProperties.getClusterName();
            transportClientProperties.put("http.serviceName", serviceProperties.getServiceName());
            transportClientProperties.put("http.poolStatsNamePrefix", clusterName);
            ClusterAwareTransportClient client = this._sslSessionValidatorFactory == null ? factory.getClient(transportClientProperties) : new ClusterAwareTransportClient(clusterName, factory.getClient(transportClientProperties), this._clusterInfo, this._sslSessionValidatorFactory);
            newTransportClients.put(scheme.toLowerCase(), client);
        }
        return newTransportClients;
    }

    private void shutdownTransportClients(Map<String, TransportClient> schemeToTransportClients, final String serviceName) {
        if (schemeToTransportClients != null) {
            this._executor.schedule(() -> {
                for (final Map.Entry entry : schemeToTransportClients.entrySet()) {
                    Callback<None> callback = new Callback<None>(){

                        public void onError(Throwable e) {
                            LogUtil.warn(_log, "Failed to shut down old ", serviceName, " TransportClient with scheme = ", entry.getKey(), e);
                            if (SimpleLoadBalancerState.this._subsettingState != null) {
                                SimpleLoadBalancerState.this._subsettingState.invalidateCache(serviceName);
                            }
                        }

                        public void onSuccess(None result) {
                            LogUtil.info(_log, "Shut down old ", serviceName, " TransportClient with scheme = ", entry.getKey());
                            if (SimpleLoadBalancerState.this._subsettingState != null) {
                                SimpleLoadBalancerState.this._subsettingState.invalidateCache(serviceName);
                            }
                        }
                    };
                    ((TransportClient)entry.getValue()).shutdown((Callback)callback);
                }
            }, this._delayedExecution, TimeUnit.MILLISECONDS);
        }
    }

    void shutdownClients(String serviceName) {
        _log.warn("shutting down all tracker clients and transport clients for service " + serviceName);
        Map<URI, TrackerClient> clients = this._trackerClients.remove(serviceName);
        if (clients != null) {
            for (TrackerClient client : clients.values()) {
                for (SimpleLoadBalancerStateListener listener : this._listeners) {
                    listener.onClientRemoved(serviceName, client);
                }
            }
        }
        Map<String, TransportClient> schemeToTransportClients = this._serviceClients.get(serviceName);
        this.shutdownTransportClients(schemeToTransportClients, serviceName);
    }

    void refreshServiceStrategies(ServiceProperties serviceProperties) {
        LogUtil.info(_log, "refreshing service strategies for service: ", serviceProperties);
        Map<String, LoadBalancerStrategy> newStrategies = this.createNewStrategies(serviceProperties);
        Map<String, LoadBalancerStrategy> oldStrategies = this._serviceStrategies.put(serviceProperties.getServiceName(), newStrategies);
        this._serviceStrategiesCache.remove(serviceProperties.getServiceName());
        LogUtil.info(_log, "removing strategies ", serviceProperties.getServiceName(), ": ", oldStrategies);
        if (oldStrategies != null) {
            for (Map.Entry entry : oldStrategies.entrySet()) {
                ((LoadBalancerStrategy)entry.getValue()).shutdown();
                for (SimpleLoadBalancerStateListener simpleLoadBalancerStateListener : this._listeners) {
                    simpleLoadBalancerStateListener.onStrategyRemoved(serviceProperties.getServiceName(), (String)entry.getKey(), (LoadBalancerStrategy)entry.getValue());
                }
            }
        }
        if (!newStrategies.isEmpty()) {
            for (SimpleLoadBalancerStateListener simpleLoadBalancerStateListener : this._listeners) {
                for (Map.Entry entry : newStrategies.entrySet()) {
                    simpleLoadBalancerStateListener.onStrategyAdded(serviceProperties.getServiceName(), (String)entry.getKey(), (LoadBalancerStrategy)entry.getValue());
                }
            }
        }
    }

    private Map<String, LoadBalancerStrategy> createNewStrategies(ServiceProperties serviceProperties) {
        List<String> strategyList = serviceProperties.getLoadBalancerStrategyList();
        LoadBalancerStrategyFactory<? extends LoadBalancerStrategy> factory = null;
        if (strategyList != null && !strategyList.isEmpty()) {
            String strategy;
            Iterator<String> iterator = strategyList.iterator();
            while (iterator.hasNext() && (factory = this._loadBalancerStrategyFactories.get(strategy = iterator.next())) == null) {
            }
        }
        ConcurrentHashMap<String, LoadBalancerStrategy> newStrategies = new ConcurrentHashMap<String, LoadBalancerStrategy>();
        if (factory == null && strategyList != null && strategyList.size() == 1 && strategyList.contains("relative") && !this._loadBalancerStrategyFactories.containsKey("relative")) {
            factory = this._loadBalancerStrategyFactories.get("degrader");
            LogUtil.warn(_log, "unable to find cluster or factory for ", serviceProperties, ", defaulting to ", factory);
        }
        if (factory == null || serviceProperties.getPrioritizedSchemes() == null || serviceProperties.getPrioritizedSchemes().isEmpty()) {
            LogUtil.warn(_log, "unable to find cluster or factory for ", serviceProperties, ": ", factory);
        } else {
            List<String> schemes = serviceProperties.getPrioritizedSchemes();
            for (String scheme : schemes) {
                LoadBalancerStrategy strategy = factory.newLoadBalancer(serviceProperties);
                newStrategies.put(scheme, strategy);
            }
        }
        LogUtil.info(_log, "putting strategies ", serviceProperties.getServiceName(), ": ", newStrategies);
        return newStrategies;
    }

    void notifyListenersOnServicePropertiesUpdates(LoadBalancerStateItem<ServiceProperties> serviceProperties) {
        for (SimpleLoadBalancerStateListener listener : this._listeners) {
            listener.onServicePropertiesUpdate(serviceProperties);
        }
    }

    void notifyListenersOnServicePropertiesRemovals(LoadBalancerStateItem<ServiceProperties> serviceProperties) {
        for (SimpleLoadBalancerStateListener listener : this._listeners) {
            listener.onServicePropertiesRemoval(serviceProperties);
        }
    }

    void notifyListenersOnClusterInfoUpdates(ClusterInfoItem clusterInfoItem) {
        for (SimpleLoadBalancerStateListener listener : this._listeners) {
            listener.onClusterInfoUpdate(clusterInfoItem);
        }
    }

    void notifyListenersOnClusterInfoRemovals(ClusterInfoItem clusterInfoItem) {
        for (SimpleLoadBalancerStateListener listener : this._listeners) {
            listener.onClusterInfoRemoval(clusterInfoItem);
        }
    }

    void notifyClusterListenersOnAdd(String clusterName) {
        for (LoadBalancerClusterListener clusterListener : this._clusterListeners) {
            clusterListener.onClusterAdded(clusterName);
        }
    }

    void notifyClusterListenersOnRemove(String clusterName) {
        for (LoadBalancerClusterListener clusterListener : this._clusterListeners) {
            clusterListener.onClusterRemoved(clusterName);
        }
    }

    public static interface SimpleLoadBalancerStateListener {
        public void onStrategyAdded(String var1, String var2, LoadBalancerStrategy var3);

        public void onStrategyRemoved(String var1, String var2, LoadBalancerStrategy var3);

        public void onClientAdded(String var1, TrackerClient var2);

        public void onClientRemoved(String var1, TrackerClient var2);

        default public void onClusterInfoUpdate(ClusterInfoItem clusterInfoItem) {
        }

        default public void onClusterInfoRemoval(ClusterInfoItem clusterInfoItem) {
        }

        default public void onServicePropertiesUpdate(LoadBalancerStateItem<ServiceProperties> serviceProperties) {
        }

        default public void onServicePropertiesRemoval(LoadBalancerStateItem<ServiceProperties> serviceProperties) {
        }
    }
}

