/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.simple;

import com.linkedin.d2.balancer.LoadBalancerStateItem;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.simple.AbstractLoadBalancerSubscriber;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancerState;
import com.linkedin.d2.discovery.event.PropertyEventBus;
import com.linkedin.d2.discovery.util.LogUtil;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UriLoadBalancerSubscriber
extends AbstractLoadBalancerSubscriber<UriProperties> {
    private static final Logger _log = LoggerFactory.getLogger(UriLoadBalancerSubscriber.class);
    private SimpleLoadBalancerState _simpleLoadBalancerState;

    public UriLoadBalancerSubscriber(PropertyEventBus<UriProperties> uPropertyEventBus, SimpleLoadBalancerState simpleLoadBalancerState) {
        super(1, uPropertyEventBus);
        this._simpleLoadBalancerState = simpleLoadBalancerState;
    }

    @Override
    protected void handlePut(String cluster, UriProperties uriProperties) {
        if (uriProperties != null) {
            String clusterName = uriProperties.getClusterName();
            Set<String> serviceNames = this._simpleLoadBalancerState.getServicesPerCluster().get(clusterName);
            if (serviceNames != null) {
                for (String serviceName : serviceNames) {
                    Map<URI, TrackerClient> trackerClients = this._simpleLoadBalancerState.getTrackerClients().get(serviceName);
                    if (trackerClients == null) {
                        trackerClients = new ConcurrentHashMap<URI, TrackerClient>();
                        this._simpleLoadBalancerState.getTrackerClients().put(serviceName, trackerClients);
                    }
                    for (URI uri : uriProperties.Uris()) {
                        Map<Integer, PartitionData> partitionDataMap = uriProperties.getPartitionDataMap(uri);
                        TrackerClient client = trackerClients.get(uri);
                        Optional<Map> newUriSpecificProperties = Optional.ofNullable(uriProperties.getUriSpecificProperties()).map(uriSpecificProperties -> (Map)uriSpecificProperties.get(uri));
                        Optional<Map> oldUriSpecificProperties = Optional.ofNullable(this._simpleLoadBalancerState.getUriProperties(clusterName)).map(LoadBalancerStateItem::getProperty).map(UriProperties::getUriSpecificProperties).map(uriSpecificProperties -> (Map)uriSpecificProperties.get(uri));
                        if (client != null && client.getPartitionDataMap().equals(partitionDataMap) && newUriSpecificProperties.equals(oldUriSpecificProperties) || (client = this._simpleLoadBalancerState.buildTrackerClient(uri, uriProperties, serviceName)) == null) continue;
                        LogUtil.debug(_log, "adding new tracker client from updated uri properties: ", client);
                        for (SimpleLoadBalancerState.SimpleLoadBalancerStateListener listener : this._simpleLoadBalancerState.getListeners()) {
                            listener.onClientAdded(serviceName, client);
                        }
                        trackerClients.put(uri, client);
                    }
                }
            }
        }
        this._simpleLoadBalancerState.getUriProperties().put(cluster, new LoadBalancerStateItem<UriProperties>(uriProperties, this._simpleLoadBalancerState.getVersionAccess().incrementAndGet(), System.currentTimeMillis()));
        if (uriProperties != null) {
            Set<String> serviceNames = this._simpleLoadBalancerState.getServicesPerCluster().get(uriProperties.getClusterName());
            if (serviceNames != null) {
                for (String serviceName : serviceNames) {
                    Map<URI, TrackerClient> trackerClients = this._simpleLoadBalancerState.getTrackerClients().get(serviceName);
                    if (trackerClients == null) continue;
                    for (URI uri : trackerClients.keySet()) {
                        if (uriProperties.Uris().contains(uri)) continue;
                        TrackerClient client = trackerClients.remove(uri);
                        LogUtil.debug(_log, "removing dead tracker client: ", client);
                        for (SimpleLoadBalancerState.SimpleLoadBalancerStateListener listener : this._simpleLoadBalancerState.getListeners()) {
                            listener.onClientRemoved(serviceName, client);
                        }
                    }
                }
            }
        } else {
            LogUtil.warn(_log, "received a null uri properties for cluster: ", cluster);
        }
    }

    @Override
    protected void handleRemove(String cluster) {
        this._simpleLoadBalancerState.getUriProperties().remove(cluster);
        LogUtil.warn(_log, "received a uri properties event remove() for cluster: ", cluster);
        this._simpleLoadBalancerState.removeTrackerClients(cluster);
    }
}

