/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies;

import com.linkedin.d2.balancer.strategies.RingFactory;
import com.linkedin.d2.balancer.util.hashing.BoundedLoadConsistentHashRing;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.util.degrader.CallTracker;
import java.util.Map;

public class BoundedLoadConsistentHashRingFactory<T>
implements RingFactory<T> {
    private final double _boundedLoadBalancingFactor;
    private final RingFactory<T> _ringFactory;

    public BoundedLoadConsistentHashRingFactory(RingFactory<T> ringFactory, double boundedLoadBalancingFactor) {
        this._boundedLoadBalancingFactor = boundedLoadBalancingFactor;
        this._ringFactory = ringFactory;
    }

    @Override
    public Ring<T> createRing(Map<T, Integer> pointsMap) {
        throw new UnsupportedOperationException("Bounded-load requires a callTrackerMap to update load information.");
    }

    @Override
    public Ring<T> createRing(Map<T, Integer> pointsMap, Map<T, CallTracker> callTrackerMap) {
        return new BoundedLoadConsistentHashRing<T>(this._ringFactory, pointsMap, callTrackerMap, this._boundedLoadBalancingFactor);
    }
}

