/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies;

import com.linkedin.d2.ConsistentHashAlgorithm;
import com.linkedin.d2.D2RingProperties;
import com.linkedin.d2.HashMethod;
import com.linkedin.d2.balancer.strategies.BoundedLoadConsistentHashRingFactory;
import com.linkedin.d2.balancer.strategies.DistributionNonDiscreteRingFactory;
import com.linkedin.d2.balancer.strategies.MPConsistentHashRingFactory;
import com.linkedin.d2.balancer.strategies.PointBasedConsistentHashRingFactory;
import com.linkedin.d2.balancer.strategies.RingFactory;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyConfig;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.util.degrader.CallTracker;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingRingFactory<T>
implements RingFactory<T> {
    public static final String POINT_BASED_CONSISTENT_HASH = "pointBased";
    public static final String MULTI_PROBE_CONSISTENT_HASH = "multiProbe";
    public static final String DISTRIBUTION_NON_HASH = "distributionBased";
    private static final Logger _log = LoggerFactory.getLogger(DelegatingRingFactory.class);
    private final RingFactory<T> _ringFactory;

    public DelegatingRingFactory(DegraderLoadBalancerStrategyConfig config) {
        this(DelegatingRingFactory.toD2RingProperties(config));
    }

    public DelegatingRingFactory(D2RingProperties ringProperties) {
        RingFactory factory;
        ConsistentHashAlgorithm consistentHashAlgorithm = ringProperties.getConsistentHashAlgorithm();
        HashMethod hashMethod = this.getOrDefault(ringProperties.getHashMethod(), HashMethod.RANDOM);
        int numProbes = this.getOrDefault(ringProperties.getNumberOfProbes(), 21);
        int numPointsPerHost = this.getOrDefault(ringProperties.getNumberOfPointsPerHost(), 1);
        if (consistentHashAlgorithm == null) {
            if (this.isAffinityRoutingEnabled(hashMethod)) {
                _log.info("URI Regex hash is specified, use multiProbe algorithm for consistent hashing");
                factory = new MPConsistentHashRingFactory(numProbes, numPointsPerHost);
            } else {
                _log.info("DistributionBased algorithm is used for consistent hashing");
                factory = new DistributionNonDiscreteRingFactory();
            }
        } else if (consistentHashAlgorithm == ConsistentHashAlgorithm.POINT_BASED) {
            double hashPointCleanupRate = this.getOrDefault(ringProperties.getHashRingPointCleanupRate(), 0.2);
            factory = new PointBasedConsistentHashRingFactory(hashPointCleanupRate);
        } else if (consistentHashAlgorithm == ConsistentHashAlgorithm.MULTI_PROBE) {
            factory = new MPConsistentHashRingFactory(numProbes, numPointsPerHost);
        } else if (consistentHashAlgorithm == ConsistentHashAlgorithm.DISTRIBUTION_BASED) {
            if (this.isAffinityRoutingEnabled(hashMethod)) {
                _log.warn("URI Regex hash is specified but distribution based ring is picked, falling back to multiProbe ring");
                factory = new MPConsistentHashRingFactory(numProbes, numPointsPerHost);
            } else {
                factory = new DistributionNonDiscreteRingFactory();
            }
        } else {
            _log.warn("Unknown consistent hash algorithm {}, falling back to multiprobe hash ring with default settings", (Object)consistentHashAlgorithm);
            factory = new MPConsistentHashRingFactory(21, 1);
        }
        double boundedLoadBalancingFactor = this.getOrDefault(ringProperties.getBoundedLoadBalancingFactor(), -1.0);
        if (boundedLoadBalancingFactor > 1.0) {
            factory = new BoundedLoadConsistentHashRingFactory(factory, boundedLoadBalancingFactor);
        }
        this._ringFactory = factory;
    }

    @Override
    public Ring<T> createRing(Map<T, Integer> pointsMap) {
        return this._ringFactory.createRing(pointsMap);
    }

    @Override
    public Ring<T> createRing(Map<T, Integer> pointsMap, Map<T, CallTracker> callTrackerMap) {
        return this._ringFactory.createRing(pointsMap, callTrackerMap);
    }

    private boolean isAffinityRoutingEnabled(HashMethod hashMethod) {
        return hashMethod == HashMethod.URI_REGEX;
    }

    private static D2RingProperties toD2RingProperties(DegraderLoadBalancerStrategyConfig config) {
        D2RingProperties ringProperties = new D2RingProperties().setNumberOfProbes(config.getNumProbes()).setNumberOfPointsPerHost(config.getPointsPerHost()).setBoundedLoadBalancingFactor(config.getBoundedLoadBalancingFactor());
        if (config.getConsistentHashAlgorithm() != null) {
            ringProperties.setConsistentHashAlgorithm(DelegatingRingFactory.toConsistentHashAlgorithm(config.getConsistentHashAlgorithm()));
        }
        if (config.getHashMethod() != null) {
            ringProperties.setHashMethod(DelegatingRingFactory.toHashMethod(config.getHashMethod()));
        }
        return ringProperties;
    }

    private static ConsistentHashAlgorithm toConsistentHashAlgorithm(String consistentHashAlgorithm) {
        switch (consistentHashAlgorithm) {
            case "pointBased": {
                return ConsistentHashAlgorithm.POINT_BASED;
            }
            case "multiProbe": {
                return ConsistentHashAlgorithm.MULTI_PROBE;
            }
        }
        return ConsistentHashAlgorithm.DISTRIBUTION_BASED;
    }

    private static HashMethod toHashMethod(String hashMethod) {
        switch (hashMethod) {
            case "uriRegex": {
                return HashMethod.URI_REGEX;
            }
        }
        return HashMethod.RANDOM;
    }

    private <R> R getOrDefault(R value, R defaultValue) {
        return value == null ? defaultValue : value;
    }
}

