/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.d2.balancer.clients.DegraderTrackerClient;
import com.linkedin.d2.balancer.strategies.DelegatingRingFactory;
import com.linkedin.d2.balancer.strategies.LoadBalancerQuarantine;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyConfig;
import com.linkedin.d2.balancer.strategies.degrader.DegraderTrackerClientUpdater;
import com.linkedin.d2.balancer.strategies.degrader.Partition;
import com.linkedin.d2.balancer.strategies.degrader.PartitionDegraderLoadBalancerState;
import com.linkedin.d2.balancer.strategies.degrader.PartitionDegraderLoadBalancerStateListener;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheck;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public class DegraderLoadBalancerState {
    private final ConcurrentMap<Integer, Partition> _partitions;
    private final String _serviceName;
    private final Map<String, String> _degraderProperties;
    private final DegraderLoadBalancerStrategyConfig _config;
    private final AtomicBoolean _quarantineEnabled;
    private final AtomicInteger _quarantineRetries;
    private final ConcurrentMap<DegraderTrackerClientUpdater, HealthCheck> _healthCheckMap;
    private final List<PartitionDegraderLoadBalancerStateListener.Factory> _degraderStateListenerFactories;

    DegraderLoadBalancerState(String serviceName, Map<String, String> degraderProperties, DegraderLoadBalancerStrategyConfig config, List<PartitionDegraderLoadBalancerStateListener.Factory> degraderStateListenerFactories) {
        this._degraderProperties = degraderProperties != null ? degraderProperties : Collections.emptyMap();
        this._partitions = new ConcurrentHashMap<Integer, Partition>();
        this._serviceName = serviceName;
        this._config = config;
        this._degraderStateListenerFactories = degraderStateListenerFactories;
        this._quarantineEnabled = new AtomicBoolean(false);
        this._quarantineRetries = new AtomicInteger(0);
        this._healthCheckMap = new ConcurrentHashMap<DegraderTrackerClientUpdater, HealthCheck>();
    }

    public Partition getPartition(int partitionId) {
        Partition partition = (Partition)this._partitions.get(partitionId);
        if (partition == null) {
            Partition newValue = new Partition(partitionId, new ReentrantLock(), new PartitionDegraderLoadBalancerState(-1L, this._config.getClock().currentTimeMillis(), false, new DelegatingRingFactory<URI>(this._config), new HashMap<URI, Integer>(), PartitionDegraderLoadBalancerState.Strategy.LOAD_BALANCE, 0.0, 0.0, new HashMap<DegraderTrackerClient, Double>(), this._serviceName, this._degraderProperties, 0L, 0L, 0L, new HashMap<DegraderTrackerClient, LoadBalancerQuarantine>(), new HashMap<DegraderTrackerClient, LoadBalancerQuarantine>(), null, 0), this._degraderStateListenerFactories.stream().map(factory -> factory.create(partitionId, this._config)).collect(Collectors.toList()));
            Partition oldValue = this._partitions.putIfAbsent(partitionId, newValue);
            partition = oldValue == null ? newValue : oldValue;
        }
        return partition;
    }

    Ring<URI> getRing(int partitionId) {
        if (this._partitions.get(partitionId) != null) {
            PartitionDegraderLoadBalancerState state = ((Partition)this._partitions.get(partitionId)).getState();
            return state.getRing();
        }
        return null;
    }

    public PartitionDegraderLoadBalancerState getPartitionState(int partitionId) {
        return this.getPartition(partitionId).getState();
    }

    void setPartitionState(int partitionId, PartitionDegraderLoadBalancerState newState) {
        this.getPartition(partitionId).setState(newState);
    }

    void putHealthCheckClient(DegraderTrackerClientUpdater updater, HealthCheck client) {
        this._healthCheckMap.put(updater, client);
    }

    Map<DegraderTrackerClientUpdater, HealthCheck> getHealthCheckMap() {
        return this._healthCheckMap;
    }

    String getServiceName() {
        return this._serviceName;
    }

    boolean isQuarantineEnabled() {
        return this._quarantineEnabled.get();
    }

    boolean tryEnableQuarantine() {
        return this._quarantineEnabled.compareAndSet(false, true);
    }

    int incrementAndGetQuarantineRetries() {
        return this._quarantineRetries.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(DegraderLoadBalancerStrategyConfig config) {
        if (config.getQuarantineMaxPercent() <= 0.0 || !this._quarantineEnabled.get()) {
            return;
        }
        for (Partition par : this._partitions.values()) {
            Lock lock = par.getLock();
            lock.lock();
            try {
                PartitionDegraderLoadBalancerState curState = par.getState();
                curState.getQuarantineMap().values().forEach(LoadBalancerQuarantine::shutdown);
            }
            finally {
                lock.unlock();
            }
        }
    }

    public String toString() {
        return "PartitionStates: [" + this._partitions + "]";
    }
}

