/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.d2.balancer.event.EventEmitter;
import com.linkedin.d2.balancer.event.NoopEventEmitter;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyConfig;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyV3;
import com.linkedin.d2.balancer.strategies.degrader.DegraderMonitorEventEmitter;
import com.linkedin.d2.balancer.strategies.degrader.PartitionDegraderLoadBalancerStateListener;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckOperations;
import com.linkedin.d2.discovery.util.LogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegraderLoadBalancerStrategyFactoryV3
implements LoadBalancerStrategyFactory<DegraderLoadBalancerStrategyV3> {
    private static final Logger LOG = LoggerFactory.getLogger(DegraderLoadBalancerStrategyFactoryV3.class);
    private final HealthCheckOperations _healthCheckOperations;
    private final ScheduledExecutorService _executorService;
    private final EventEmitter _eventEmitter;
    private final List<PartitionDegraderLoadBalancerStateListener.Factory> _degraderStateListenerFactories;

    public DegraderLoadBalancerStrategyFactoryV3() {
        this._healthCheckOperations = null;
        this._executorService = null;
        this._eventEmitter = new NoopEventEmitter();
        this._degraderStateListenerFactories = Collections.emptyList();
    }

    public DegraderLoadBalancerStrategyFactoryV3(HealthCheckOperations healthCheckOperations, ScheduledExecutorService executorService, EventEmitter emitter, List<PartitionDegraderLoadBalancerStateListener.Factory> degraderStateListenerFactories) {
        this._healthCheckOperations = healthCheckOperations;
        this._executorService = executorService;
        this._eventEmitter = emitter == null ? new NoopEventEmitter() : emitter;
        this._degraderStateListenerFactories = degraderStateListenerFactories;
    }

    @Override
    public DegraderLoadBalancerStrategyV3 newLoadBalancer(ServiceProperties serviceProperties) {
        return this.newLoadBalancer(serviceProperties.getServiceName(), serviceProperties.getLoadBalancerStrategyProperties(), serviceProperties.getDegraderProperties(), serviceProperties.getPath(), serviceProperties.getClusterName());
    }

    private DegraderLoadBalancerStrategyV3 newLoadBalancer(String serviceName, Map<String, Object> strategyProperties, Map<String, String> degraderProperties, String path, String clusterName) {
        LogUtil.debug(LOG, "created a degrader load balancer strategyV3");
        HashMap<String, Object> strategyPropertiesCopy = new HashMap<String, Object>(strategyProperties);
        strategyPropertiesCopy.put("path", path);
        strategyPropertiesCopy.put("clusterName", clusterName);
        DegraderLoadBalancerStrategyConfig config = DegraderLoadBalancerStrategyConfig.createHttpConfigFromMap(strategyPropertiesCopy, this._healthCheckOperations, this._executorService, degraderProperties, this._eventEmitter);
        ArrayList<PartitionDegraderLoadBalancerStateListener.Factory> listeners = new ArrayList<PartitionDegraderLoadBalancerStateListener.Factory>();
        listeners.add(new DegraderMonitorEventEmitter.Factory(serviceName));
        listeners.addAll(this._degraderStateListenerFactories);
        return new DegraderLoadBalancerStrategyV3(config, serviceName, degraderProperties, listeners);
    }
}

