/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.MapUtil;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.KeyMapper;
import com.linkedin.d2.balancer.clients.DegraderTrackerClient;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.strategies.DelegatingRingFactory;
import com.linkedin.d2.balancer.strategies.LoadBalancerQuarantine;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerState;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyConfig;
import com.linkedin.d2.balancer.strategies.degrader.DegraderTrackerClientUpdater;
import com.linkedin.d2.balancer.strategies.degrader.Partition;
import com.linkedin.d2.balancer.strategies.degrader.PartitionDegraderLoadBalancerState;
import com.linkedin.d2.balancer.strategies.degrader.PartitionDegraderLoadBalancerStateListener;
import com.linkedin.d2.balancer.util.hashing.HashFunction;
import com.linkedin.d2.balancer.util.hashing.RandomHash;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.balancer.util.hashing.SeededRandomHash;
import com.linkedin.d2.balancer.util.hashing.URIRegexHash;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheck;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckClientBuilder;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.timing.TimingContextUtil;
import com.linkedin.r2.message.timing.TimingImportance;
import com.linkedin.r2.message.timing.TimingKey;
import com.linkedin.util.RateLimitedLogger;
import com.linkedin.util.degrader.Degrader;
import com.linkedin.util.degrader.DegraderControl;
import com.linkedin.util.degrader.DegraderImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegraderLoadBalancerStrategyV3
implements LoadBalancerStrategy {
    public static final String DEGRADER_STRATEGY_NAME = "degrader";
    public static final String HASH_METHOD_NONE = "none";
    public static final String HASH_METHOD_URI_REGEX = "uriRegex";
    public static final String HASH_SEED = "hashSeed";
    public static final long DEFAULT_SEED = 123456789L;
    public static final double EPSILON = 1.0E-5;
    private static final Logger _log = LoggerFactory.getLogger(DegraderLoadBalancerStrategyV3.class);
    private static final int MAX_HOSTS_TO_CHECK_QUARANTINE = 10;
    private static final int MAX_RETRIES_TO_CHECK_QUARANTINE = 5;
    private static final double SLOW_START_THRESHOLD = 0.0;
    private static final double FAST_RECOVERY_THRESHOLD = 1.0;
    private static final double FAST_RECOVERY_MAX_DROPRATE = 0.5;
    private static final TimingKey TIMING_KEY = TimingKey.registerNewKey((String)"d2_update_partition", (TimingImportance)TimingImportance.LOW);
    private boolean _updateEnabled = true;
    private volatile DegraderLoadBalancerStrategyConfig _config;
    private volatile HashFunction<Request> _hashFunction;
    private final DegraderLoadBalancerState _state;
    private final RateLimitedLogger _rateLimitedLogger;

    public DegraderLoadBalancerStrategyV3(DegraderLoadBalancerStrategyConfig config, String serviceName, Map<String, String> degraderProperties, List<PartitionDegraderLoadBalancerStateListener.Factory> degraderStateListenerFactories) {
        this.setConfig(config);
        if (degraderProperties == null) {
            degraderProperties = Collections.emptyMap();
        }
        this._state = new DegraderLoadBalancerState(serviceName, degraderProperties, config, degraderStateListenerFactories);
        this._rateLimitedLogger = new RateLimitedLogger(_log, 5000L, config.getClock());
    }

    @Override
    public String getName() {
        return DEGRADER_STRATEGY_NAME;
    }

    private List<DegraderTrackerClient> castToDegraderTrackerClients(Map<URI, TrackerClient> trackerClients) {
        ArrayList<DegraderTrackerClient> degraderTrackerClients = new ArrayList<DegraderTrackerClient>(trackerClients.size());
        for (TrackerClient trackerClient : trackerClients.values()) {
            if (trackerClient instanceof DegraderTrackerClient) {
                degraderTrackerClients.add((DegraderTrackerClient)trackerClient);
                continue;
            }
            LogUtil.warn(_log, "Client passed to DegraderV3 not an instance of DegraderTrackerClient, will not load balance to it.", trackerClient);
        }
        return degraderTrackerClients;
    }

    @Override
    public TrackerClient getTrackerClient(Request request, RequestContext requestContext, long clusterGenerationId, int partitionId, Map<URI, TrackerClient> trackerClients) {
        return this.getTrackerClient(request, requestContext, clusterGenerationId, partitionId, trackerClients, false);
    }

    @Override
    public TrackerClient getTrackerClient(Request request, RequestContext requestContext, long clusterGenerationId, int partitionId, Map<URI, TrackerClient> trackerClients, boolean shouldForceUpdate) {
        DegraderTrackerClient client;
        LogUtil.debug(_log, "getTrackerClient with generation id ", clusterGenerationId, " partition id: ", partitionId, " on tracker clients: ", trackerClients);
        if (trackerClients == null || trackerClients.size() == 0) {
            LogUtil.warn(_log, "getTrackerClient called with null/empty trackerClients, so returning null");
            return null;
        }
        List<DegraderTrackerClient> degraderTrackerClients = this.castToDegraderTrackerClients(trackerClients);
        TimingContextUtil.markTiming((RequestContext)requestContext, (TimingKey)TIMING_KEY);
        this.checkUpdatePartitionState(clusterGenerationId, partitionId, degraderTrackerClients, shouldForceUpdate);
        TimingContextUtil.markTiming((RequestContext)requestContext, (TimingKey)TIMING_KEY);
        Ring<URI> ring = this._state.getRing(partitionId);
        URI targetHostUri = KeyMapper.TargetHostHints.getRequestContextTargetHost(requestContext);
        Set<URI> excludedUris = LoadBalancerStrategy.ExcludedHostHints.getRequestContextExcludedHosts(requestContext);
        if (excludedUris == null) {
            excludedUris = new HashSet<URI>();
        }
        if (targetHostUri == null) {
            client = this.findValidClientFromRing(request, ring, degraderTrackerClients, excludedUris, requestContext);
        } else {
            LogUtil.debug(_log, "Degrader honoring target host header in request, skipping hashing.  URI: ", targetHostUri);
            client = this.searchClientFromUri(targetHostUri, degraderTrackerClients);
            if (client == null) {
                LogUtil.warn(_log, "No client found for ", targetHostUri, ". Target host specified is no longer part of cluster");
            } else {
                Boolean otherHostAcceptable = KeyMapper.TargetHostHints.getRequestContextOtherHostAcceptable(requestContext);
                if (otherHostAcceptable != null && otherHostAcceptable.booleanValue()) {
                    LoadBalancerStrategy.ExcludedHostHints.addRequestContextExcludedHost(requestContext, targetHostUri);
                }
            }
        }
        if (client == null) {
            return null;
        }
        Degrader degrader = client.getDegrader(partitionId);
        if (degrader.checkDrop()) {
            LogUtil.warn(_log, "client's degrader is dropping call for: ", client);
            return null;
        }
        LogUtil.debug(_log, "returning client: ", client);
        if (degrader.checkPreemptiveTimeout()) {
            DegraderControl degraderControl = client.getDegraderControl(partitionId);
            requestContext.putLocalAttr("PREEMPTIVE_TIMEOUT_RATE", (Object)degraderControl.getPreemptiveRequestTimeoutRate());
        }
        return client;
    }

    private DegraderTrackerClient findValidClientFromRing(Request request, Ring<URI> ring, List<DegraderTrackerClient> trackerClients, Set<URI> excludedUris, RequestContext requestContext) {
        int hashCode = this._hashFunction.hash(request);
        if (ring == null) {
            LogUtil.warn(_log, "Can not find hash ring to use");
        }
        HashMap<URI, DegraderTrackerClient> trackerClientMap = new HashMap<URI, DegraderTrackerClient>(trackerClients.size());
        for (DegraderTrackerClient trackerClient : trackerClients) {
            trackerClientMap.put(trackerClient.getUri(), trackerClient);
        }
        URI mostWantedURI = ring.get(hashCode);
        DegraderTrackerClient client = (DegraderTrackerClient)trackerClientMap.get(mostWantedURI);
        if (client != null && !excludedUris.contains(mostWantedURI)) {
            LoadBalancerStrategy.ExcludedHostHints.addRequestContextExcludedHost(requestContext, mostWantedURI);
            return client;
        }
        Iterator<URI> iterator = ring.getIterator(hashCode);
        URI targetHostUri = null;
        while (iterator.hasNext()) {
            targetHostUri = iterator.next();
            client = (DegraderTrackerClient)trackerClientMap.get(targetHostUri);
            if (targetHostUri == mostWantedURI || excludedUris.contains(targetHostUri) || client == null) continue;
            LoadBalancerStrategy.ExcludedHostHints.addRequestContextExcludedHost(requestContext, targetHostUri);
            return client;
        }
        if (client == null) {
            LogUtil.warn(_log, "No client found. Degrader load balancer state is inconsistent with cluster manager");
        } else if (excludedUris.contains(targetHostUri)) {
            client = null;
            LogUtil.warn(_log, "No client found. We have tried all hosts in the cluster");
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void checkUpdatePartitionState(long clusterGenerationId, int partitionId, List<DegraderTrackerClient> trackerClients, boolean shouldForceUpdate) {
        config = this.getConfig();
        partition = this._state.getPartition(partitionId);
        lock = partition.getLock();
        partitionUpdated = false;
        if (!partition.getState().isInitialized()) {
            lock.lock();
            try {
                if (partition.getState().isInitialized()) ** GOTO lbl30
                LogUtil.debug(DegraderLoadBalancerStrategyV3._log, new Object[]{"initializing partition state for partition: ", partitionId});
                this.updatePartitionState(clusterGenerationId, partition, trackerClients, config);
                if (!partition.getState().isInitialized()) {
                    DegraderLoadBalancerStrategyV3._log.error("Failed to initialize partition state for partition: ", (Object)partitionId);
                }
                partitionUpdated = true;
            }
            finally {
                lock.unlock();
            }
        } else if (DegraderLoadBalancerStrategyV3.shouldUpdatePartition(clusterGenerationId, partition.getState(), config, this._updateEnabled, shouldForceUpdate, trackerClients) && lock.tryLock()) {
            try {
                if (DegraderLoadBalancerStrategyV3.shouldUpdatePartition(clusterGenerationId, partition.getState(), config, this._updateEnabled, shouldForceUpdate, trackerClients)) {
                    LogUtil.debug(DegraderLoadBalancerStrategyV3._log, new Object[]{"updating for cluster generation id: ", clusterGenerationId, ", partitionId: ", partitionId});
                    LogUtil.debug(DegraderLoadBalancerStrategyV3._log, new Object[]{"old state was: ", partition.getState()});
                    this.updatePartitionState(clusterGenerationId, partition, trackerClients, config);
                    partitionUpdated = true;
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (partitionUpdated) {
            for (PartitionDegraderLoadBalancerStateListener listener : partition.getListeners()) {
                listener.onUpdate(partition.getState());
            }
        }
    }

    private DegraderTrackerClient searchClientFromUri(URI uri, List<DegraderTrackerClient> trackerClients) {
        for (DegraderTrackerClient trackerClient : trackerClients) {
            if (!trackerClient.getUri().equals(uri)) continue;
            return trackerClient;
        }
        return null;
    }

    private void updatePartitionState(long clusterGenerationId, Partition partition, List<DegraderTrackerClient> trackerClients, DegraderLoadBalancerStrategyConfig config) {
        PartitionDegraderLoadBalancerState partitionState = partition.getState();
        ArrayList<DegraderTrackerClientUpdater> clientUpdaters = new ArrayList<DegraderTrackerClientUpdater>();
        for (DegraderTrackerClient client : trackerClients) {
            clientUpdaters.add(new DegraderTrackerClientUpdater(client, partition.getId()));
        }
        boolean quarantineEnabled = this._state.isQuarantineEnabled();
        if (config.getQuarantineMaxPercent() > 0.0 && !quarantineEnabled && this._state.incrementAndGetQuarantineRetries() <= 5) {
            this._config.getExecutorService().submit(() -> this.checkQuarantineState(clientUpdaters, config));
        }
        partitionState = DegraderLoadBalancerStrategyV3.doUpdatePartitionState(clusterGenerationId, partition.getId(), partitionState, config, clientUpdaters, quarantineEnabled);
        partition.setState(partitionState);
        for (DegraderTrackerClientUpdater clientUpdater : clientUpdaters) {
            clientUpdater.update();
        }
    }

    static boolean isNewStateHealthy(PartitionDegraderLoadBalancerState newState, DegraderLoadBalancerStrategyConfig config, List<DegraderTrackerClientUpdater> degraderTrackerClientUpdaters, int partitionId) {
        if (newState.getCurrentAvgClusterLatency() > config.getLowWaterMark()) {
            return false;
        }
        return DegraderLoadBalancerStrategyV3.getUnhealthyTrackerClients(degraderTrackerClientUpdaters, newState.getPointsMap(), newState.getQuarantineMap(), config, partitionId).isEmpty();
    }

    private static boolean isNewStateHealthy(PartitionDegraderLoadBalancerState newState, DegraderLoadBalancerStrategyConfig config, List<DegraderTrackerClient> unHealthyClients) {
        return newState.getCurrentAvgClusterLatency() <= config.getLowWaterMark() && unHealthyClients.isEmpty();
    }

    static boolean isOldStateTheSameAsNewState(PartitionDegraderLoadBalancerState oldState, PartitionDegraderLoadBalancerState newState) {
        return oldState.getCurrentOverrideDropRate() == newState.getCurrentOverrideDropRate() && oldState.getPointsMap().equals(newState.getPointsMap()) && oldState.getRecoveryMap().equals(newState.getRecoveryMap()) && oldState.getQuarantineMap().equals(newState.getQuarantineMap());
    }

    private static void logState(PartitionDegraderLoadBalancerState oldState, PartitionDegraderLoadBalancerState newState, int partitionId, DegraderLoadBalancerStrategyConfig config, List<DegraderTrackerClient> unHealthyClients, boolean clientDegraded) {
        Map<URI, Integer> pointsMap = newState.getPointsMap();
        int LOG_UNHEALTHY_CLIENT_NUMBERS = 10;
        if (_log.isDebugEnabled()) {
            _log.debug("Strategy updated: partitionId= " + partitionId + ", newState=" + newState + ", unhealthyClients = [" + unHealthyClients.stream().map(client -> DegraderLoadBalancerStrategyV3.getClientStats(client, partitionId, pointsMap, config)).collect(Collectors.joining(",")) + "], config=" + config + ", HashRing coverage=" + newState.getRing());
        } else if (DegraderLoadBalancerStrategyV3.allowToLog(oldState, newState, clientDegraded)) {
            _log.info("Strategy updated: partitionId= " + partitionId + ", newState=" + newState + ", unhealthyClients = [" + unHealthyClients.stream().limit(10L).map(client -> DegraderLoadBalancerStrategyV3.getClientStats(client, partitionId, pointsMap, config)).collect(Collectors.joining(",")) + (unHealthyClients.size() > 10 ? "...(total " + unHealthyClients.size() + ")" : "") + "], oldState =" + oldState + ", new state's config=" + config);
        }
    }

    private static boolean allowToLog(PartitionDegraderLoadBalancerState oldState, PartitionDegraderLoadBalancerState newState, boolean clientDegraded) {
        if (oldState.getCurrentOverrideDropRate() != newState.getCurrentOverrideDropRate()) {
            return true;
        }
        if (oldState.getPointsMap().size() != newState.getPointsMap().size() || clientDegraded) {
            return true;
        }
        if (oldState.getUnHealthyClientNumber() != newState.getUnHealthyClientNumber()) {
            return true;
        }
        return oldState.getRecoveryMap().size() != newState.getRecoveryMap().size() || oldState.getQuarantineMap().size() != newState.getQuarantineMap().size();
    }

    private static String getClientStats(DegraderTrackerClient client, int partitionId, Map<URI, Integer> pointsMap, DegraderLoadBalancerStrategyConfig config) {
        DegraderControl degraderControl = client.getDegraderControl(partitionId);
        return client.getUri() + ":" + pointsMap.get(client.getUri()) + "/" + String.valueOf(client.getPartitionWeight(partitionId) * client.getSubsetWeight(partitionId) * (double)config.getPointsPerWeight()) + "(" + degraderControl.getCallTimeStats().getAverage() + "ms)";
    }

    private static List<DegraderTrackerClient> getUnhealthyTrackerClients(List<DegraderTrackerClientUpdater> degraderTrackerClientUpdaters, Map<URI, Integer> pointsMap, Map<DegraderTrackerClient, LoadBalancerQuarantine> quarantineMap, DegraderLoadBalancerStrategyConfig config, int partitionId) {
        ArrayList<DegraderTrackerClient> unhealthyClients = new ArrayList<DegraderTrackerClient>();
        for (DegraderTrackerClientUpdater clientUpdater : degraderTrackerClientUpdaters) {
            DegraderTrackerClient client = clientUpdater.getTrackerClient();
            int perfectHealth = (int)(client.getPartitionWeight(partitionId) * client.getSubsetWeight(partitionId) * (double)config.getPointsPerWeight());
            URI uri = client.getUri();
            if (!pointsMap.containsKey(uri)) {
                _log.warn("Client with URI {} is absent in point map, pointMap={}, quarantineMap={}", new Object[]{uri, pointsMap, quarantineMap});
                continue;
            }
            Integer point = pointsMap.get(uri);
            if (point >= perfectHealth) continue;
            unhealthyClients.add(client);
        }
        return unhealthyClients;
    }

    private static PartitionDegraderLoadBalancerState doUpdatePartitionState(long clusterGenerationId, int partitionId, PartitionDegraderLoadBalancerState oldState, DegraderLoadBalancerStrategyConfig config, List<DegraderTrackerClientUpdater> degraderTrackerClientUpdaters, boolean isQuarantineEnabled) {
        PartitionDegraderLoadBalancerState newState;
        boolean trackerClientInconsistency;
        LogUtil.debug(_log, "updating state for: ", degraderTrackerClientUpdaters);
        double sumOfClusterLatencies = 0.0;
        long totalClusterCallCount = 0L;
        boolean hashRingChanges = false;
        boolean clientDegraded = false;
        boolean recoveryMapChanges = false;
        boolean quarantineMapChanged = false;
        PartitionDegraderLoadBalancerState.Strategy strategy = oldState.getStrategy();
        Map<DegraderTrackerClient, Double> oldRecoveryMap = oldState.getRecoveryMap();
        HashMap<DegraderTrackerClient, Double> newRecoveryMap = new HashMap<DegraderTrackerClient, Double>(oldRecoveryMap);
        double currentOverrideDropRate = oldState.getCurrentOverrideDropRate();
        double initialRecoveryLevel = config.getInitialRecoveryLevel();
        double ringRampFactor = config.getRingRampFactor();
        int pointsPerWeight = config.getPointsPerWeight();
        Map<DegraderTrackerClient, LoadBalancerQuarantine> quarantineMap = oldState.getQuarantineMap();
        Map<DegraderTrackerClient, LoadBalancerQuarantine> quarantineHistory = oldState.getQuarantineHistory();
        HashSet<DegraderTrackerClient> activeClients = new HashSet<DegraderTrackerClient>();
        long clk = config.getClock().currentTimeMillis();
        long clusterErrorCount = 0L;
        long clusterDropCount = 0L;
        for (DegraderTrackerClientUpdater clientUpdater : degraderTrackerClientUpdaters) {
            LoadBalancerQuarantine quarantine;
            DegraderTrackerClient client = clientUpdater.getTrackerClient();
            DegraderControl degraderControl = client.getDegraderControl(partitionId);
            double averageLatency = degraderControl.getLatency();
            long callCount = degraderControl.getCallCount();
            clusterDropCount += (long)((int)(degraderControl.getCurrentDropRate() * (double)callCount));
            clusterErrorCount += (long)((int)(degraderControl.getErrorRate() * (double)callCount));
            oldState.getPreviousMaxDropRate().put(client, clientUpdater.getMaxDropRate());
            sumOfClusterLatencies += averageLatency * (double)callCount;
            totalClusterCallCount += callCount;
            activeClients.add(client);
            if (isQuarantineEnabled && (quarantine = quarantineMap.get(client)) != null && quarantine.checkUpdateQuarantineState()) {
                quarantineMap.remove(client);
                quarantineHistory.put(client, quarantine);
                _log.info("TrackerClient {} evicted from quarantine @ {}", (Object)client.getUri(), (Object)clk);
                newRecoveryMap.put(client, degraderControl.getMaxDropRate());
                clientUpdater.setMaxDropRate(1.0 - initialRecoveryLevel);
                quarantineMapChanged = true;
            }
            if (!newRecoveryMap.containsKey(client)) continue;
            recoveryMapChanges = DegraderLoadBalancerStrategyV3.handleClientInRecoveryMap(degraderControl, clientUpdater, initialRecoveryLevel, ringRampFactor, callCount, newRecoveryMap, strategy);
        }
        if (isQuarantineEnabled) {
            quarantineMap.entrySet().removeIf(e -> !activeClients.contains(e.getKey()));
            quarantineHistory.entrySet().removeIf(e -> !activeClients.contains(e.getKey()));
        }
        newRecoveryMap.entrySet().removeIf(e -> !activeClients.contains(e.getKey()));
        boolean bl = trackerClientInconsistency = degraderTrackerClientUpdaters.size() != oldState.getPointsMap().size();
        if (!(oldState.getClusterGenerationId() != clusterGenerationId || totalClusterCallCount > 0L || recoveryMapChanges || quarantineMapChanged || trackerClientInconsistency)) {
            LogUtil.debug(_log, "New state is the same as the old state so we're not changing anything. Old state = ", oldState, ", config= ", config);
            return new PartitionDegraderLoadBalancerState(oldState, clusterGenerationId, config.getClock().currentTimeMillis());
        }
        double newCurrentAvgClusterLatency = -1.0;
        if (totalClusterCallCount > 0L) {
            newCurrentAvgClusterLatency = sumOfClusterLatencies / (double)totalClusterCallCount;
        }
        LogUtil.debug(_log, "average cluster latency: ", newCurrentAvgClusterLatency);
        Map<URI, Integer> points = new HashMap<URI, Integer>();
        Map<URI, Integer> oldPointsMap = oldState.getPointsMap();
        for (DegraderTrackerClientUpdater clientUpdater : degraderTrackerClientUpdaters) {
            DegraderTrackerClient client = clientUpdater.getTrackerClient();
            URI clientUri = client.getUri();
            DegraderControl degraderControl = client.getDegraderControl(partitionId);
            double dropRate = Math.min(degraderControl.getCurrentComputedDropRate(), clientUpdater.getMaxDropRate());
            double clientWeight = client.getPartitionWeight(partitionId) * client.getSubsetWeight(partitionId);
            double successfulTransmissionWeight = clientWeight * (1.0 - dropRate);
            LogUtil.debug(_log, "computed new weight for uri ", clientUri, ": ", successfulTransmissionWeight);
            int newPoints = (int)(successfulTransmissionWeight * (double)pointsPerWeight);
            boolean quarantineEffect = false;
            if (isQuarantineEnabled) {
                if (quarantineMap.containsKey(client)) {
                    newPoints = 0;
                    quarantineEffect = true;
                } else if (successfulTransmissionWeight <= 0.0 && clientWeight > 1.0E-5 && degraderControl.isHigh()) {
                    if (1.0 * (double)quarantineMap.size() < Math.ceil((double)degraderTrackerClientUpdaters.size() * config.getQuarantineMaxPercent())) {
                        LoadBalancerQuarantine quarantine = quarantineHistory.remove(client);
                        if (quarantine == null) {
                            quarantine = new LoadBalancerQuarantine(clientUpdater.getTrackerClient(), config, oldState.getServiceName());
                        }
                        quarantine.reset(clk);
                        quarantineMap.put(client, quarantine);
                        newPoints = 0;
                        _log.warn("TrackerClient {} is put into quarantine {}. OverrideDropRate = {}, callCount = {}, latency = {}, errorRate = {}", new Object[]{client.getUri(), quarantine, degraderControl.getMaxDropRate(), degraderControl.getCallCount(), degraderControl.getLatency(), degraderControl.getErrorRate()});
                        quarantineEffect = true;
                    } else {
                        _log.error("Quarantine for service {} is full! Could not add {}", (Object)oldState.getServiceName(), (Object)client);
                    }
                }
            }
            if (!quarantineEffect && newPoints == 0 && clientWeight > 1.0E-5) {
                Double oldMaxDropRate = clientUpdater.getMaxDropRate();
                newPoints = (int)(initialRecoveryLevel * (double)pointsPerWeight);
                if (!newRecoveryMap.containsKey(client) && strategy == PartitionDegraderLoadBalancerState.Strategy.LOAD_BALANCE) {
                    newRecoveryMap.put(client, oldMaxDropRate);
                    clientUpdater.setMaxDropRate(1.0 - initialRecoveryLevel);
                }
            }
            DegraderLoadBalancerStrategyV3.enrollNewClientInRecoveryMap(newRecoveryMap, oldState, config, degraderControl, clientUpdater);
            points.put(clientUri, newPoints);
            if (oldPointsMap.containsKey(clientUri) && oldPointsMap.get(clientUri) == newPoints) continue;
            hashRingChanges = true;
            clientDegraded |= oldPointsMap.containsKey(clientUri) && newPoints < oldPointsMap.get(clientUri);
        }
        if (strategy == PartitionDegraderLoadBalancerState.Strategy.LOAD_BALANCE && hashRingChanges || oldState.getClusterGenerationId() != clusterGenerationId) {
            List<DegraderTrackerClient> unHealthyClients = DegraderLoadBalancerStrategyV3.getUnhealthyTrackerClients(degraderTrackerClientUpdaters, points, quarantineMap, config, partitionId);
            newState = new PartitionDegraderLoadBalancerState(clusterGenerationId, config.getClock().currentTimeMillis(), true, oldState.getRingFactory(), points, PartitionDegraderLoadBalancerState.Strategy.CALL_DROPPING, currentOverrideDropRate, newCurrentAvgClusterLatency, newRecoveryMap, oldState.getServiceName(), oldState.getDegraderProperties(), totalClusterCallCount, clusterDropCount, clusterErrorCount, quarantineMap, quarantineHistory, activeClients, unHealthyClients.size());
            DegraderLoadBalancerStrategyV3.logState(oldState, newState, partitionId, config, unHealthyClients, clientDegraded);
        } else {
            double newDropLevel = DegraderLoadBalancerStrategyV3.calculateNewDropLevel(config, currentOverrideDropRate, newCurrentAvgClusterLatency, totalClusterCallCount);
            if (newDropLevel != currentOverrideDropRate) {
                DegraderLoadBalancerStrategyV3.overrideClusterDropRate(partitionId, newDropLevel, degraderTrackerClientUpdaters);
            }
            List<DegraderTrackerClient> unHealthyClients = DegraderLoadBalancerStrategyV3.getUnhealthyTrackerClients(degraderTrackerClientUpdaters, oldPointsMap, quarantineMap, config, partitionId);
            newState = new PartitionDegraderLoadBalancerState(clusterGenerationId, config.getClock().currentTimeMillis(), true, oldState.getRingFactory(), oldPointsMap, PartitionDegraderLoadBalancerState.Strategy.LOAD_BALANCE, newDropLevel, newCurrentAvgClusterLatency, newRecoveryMap, oldState.getServiceName(), oldState.getDegraderProperties(), totalClusterCallCount, clusterDropCount, clusterErrorCount, quarantineMap, quarantineHistory, activeClients, unHealthyClients.size());
            DegraderLoadBalancerStrategyV3.logState(oldState, newState, partitionId, config, unHealthyClients, clientDegraded);
            points = oldPointsMap;
        }
        DegraderLoadBalancerStrategyV3.overrideMinCallCount(partitionId, currentOverrideDropRate, degraderTrackerClientUpdaters, points, pointsPerWeight);
        return newState;
    }

    private static void enrollNewClientInRecoveryMap(Map<DegraderTrackerClient, Double> recoveryMap, PartitionDegraderLoadBalancerState state, DegraderLoadBalancerStrategyConfig config, DegraderControl degraderControl, DegraderTrackerClientUpdater clientUpdater) {
        DegraderTrackerClient client = clientUpdater.getTrackerClient();
        if (!recoveryMap.containsKey(client) && !state.getTrackerClients().contains(client) && config.getRingRampFactor() > 1.0 && degraderControl.getInitialDropRate() > 0.0 && !degraderControl.isHigh() && !client.doNotSlowStart()) {
            recoveryMap.put(client, clientUpdater.getMaxDropRate());
            double maxDropRate = 1.0 - config.getInitialRecoveryLevel();
            clientUpdater.setMaxDropRate(Math.min(degraderControl.getCurrentComputedDropRate(), maxDropRate));
        }
    }

    public static void overrideClusterDropRate(int partitionId, double override, List<DegraderTrackerClientUpdater> degraderTrackerClientUpdaters) {
        LogUtil.debug(_log, "partitionId=", partitionId, "overriding degrader drop rate to ", override, " for clients: ", degraderTrackerClientUpdaters);
        for (DegraderTrackerClientUpdater clientUpdater : degraderTrackerClientUpdaters) {
            clientUpdater.setOverrideDropRate(override);
        }
    }

    public static void overrideMinCallCount(int partitionId, double newOverrideDropRate, List<DegraderTrackerClientUpdater> degraderTrackerClientUpdaters, Map<URI, Integer> pointsMap, int pointsPerWeight) {
        for (DegraderTrackerClientUpdater clientUpdater : degraderTrackerClientUpdaters) {
            if (!pointsMap.containsKey(clientUpdater.getTrackerClient().getUri())) continue;
            DegraderTrackerClient client = clientUpdater.getTrackerClient();
            DegraderControl degraderControl = client.getDegraderControl(partitionId);
            int currentOverrideMinCallCount = client.getDegraderControl(partitionId).getOverrideMinCallCount();
            double hashFactor = pointsMap.get(client.getUri()) / pointsPerWeight;
            double transmitFactor = 1.0 - newOverrideDropRate;
            int newOverrideMinCallCount = (int)Math.max(Math.round((double)degraderControl.getMinCallCount() * hashFactor * transmitFactor), 1L);
            if (newOverrideMinCallCount == currentOverrideMinCallCount) continue;
            clientUpdater.setOverrideMinCallCount(newOverrideMinCallCount);
            if (currentOverrideMinCallCount == DegraderImpl.DEFAULT_OVERRIDE_MIN_CALL_COUNT) continue;
            LogUtil.warn(_log, "partitionId=", partitionId, "overriding Min Call Count to ", newOverrideMinCallCount, " for client: ", client.getUri());
        }
    }

    protected static boolean shouldUpdatePartition(long clusterGenerationId, PartitionDegraderLoadBalancerState partitionState, DegraderLoadBalancerStrategyConfig config, boolean updateEnabled, boolean shouldForceUpdate, List<DegraderTrackerClient> trackerClients) {
        boolean trackerClientInconsistency = trackerClients.size() != partitionState.getPointsMap().size();
        return updateEnabled && (shouldForceUpdate || !config.isUpdateOnlyAtInterval() && partitionState.getClusterGenerationId() != clusterGenerationId || config.getClock().currentTimeMillis() - partitionState.getLastUpdated() >= config.getUpdateIntervalMs() || trackerClientInconsistency);
    }

    public DegraderLoadBalancerState getState() {
        return this._state;
    }

    public DegraderLoadBalancerStrategyConfig getConfig() {
        return this._config;
    }

    public void setConfig(DegraderLoadBalancerStrategyConfig config) {
        this._config = config;
        String hashMethod = this._config.getHashMethod();
        Map<String, Object> hashConfig = this._config.getHashConfig();
        if (hashMethod == null || hashMethod.equals(HASH_METHOD_NONE)) {
            this._hashFunction = hashConfig.containsKey(HASH_SEED) ? new SeededRandomHash((Long)MapUtil.getWithDefault(hashConfig, (Object)HASH_SEED, (Object)123456789L)) : new RandomHash();
        } else if (HASH_METHOD_URI_REGEX.equals(hashMethod)) {
            this._hashFunction = new URIRegexHash(hashConfig);
        } else {
            _log.warn("Unknown hash method {}, falling back to random", (Object)hashMethod);
            this._hashFunction = new RandomHash();
        }
    }

    @Override
    @Nonnull
    public Ring<URI> getRing(long clusterGenerationId, int partitionId, Map<URI, TrackerClient> trackerClients) {
        return this.getRing(clusterGenerationId, partitionId, trackerClients, false);
    }

    @Override
    @Nonnull
    public Ring<URI> getRing(long clusterGenerationId, int partitionId, Map<URI, TrackerClient> trackerClients, boolean shouldForceUpdate) {
        if (trackerClients.isEmpty()) {
            return new DelegatingRingFactory(this._config).createRing(Collections.emptyMap(), Collections.emptyMap());
        }
        this.checkUpdatePartitionState(clusterGenerationId, partitionId, this.castToDegraderTrackerClients(trackerClients), shouldForceUpdate);
        return this._state.getRing(partitionId);
    }

    public Ring<URI> getRing(int partitionId) {
        return this._state.getRing(partitionId);
    }

    public boolean getUpdateEnabled() {
        return this._updateEnabled;
    }

    public void setUpdateEnabled(boolean enabled) {
        this._updateEnabled = enabled;
    }

    @Override
    public HashFunction<Request> getHashFunction() {
        return this._hashFunction;
    }

    @Override
    public void shutdown() {
        this._state.shutdown(this._config);
    }

    private void checkQuarantineState(List<DegraderTrackerClientUpdater> clients, DegraderLoadBalancerStrategyConfig config) {
        Callback<None> healthCheckCallback = new Callback<None>(){

            public void onError(Throwable e) {
                if (!DegraderLoadBalancerStrategyV3.this._state.isQuarantineEnabled()) {
                    DegraderLoadBalancerStrategyV3.this._rateLimitedLogger.warn("Error enabling quarantine. Health checking failed for service {}: ", (Object)DegraderLoadBalancerStrategyV3.this._state.getServiceName(), (Object)e);
                }
            }

            public void onSuccess(None result) {
                if (DegraderLoadBalancerStrategyV3.this._state.tryEnableQuarantine()) {
                    _log.info("Quarantine is enabled for service {}", (Object)DegraderLoadBalancerStrategyV3.this._state.getServiceName());
                }
            }
        };
        clients.stream().limit(10L).forEach(arg_0 -> this.lambda$checkQuarantineState$6(config, (Callback)healthCheckCallback, arg_0));
        for (DegraderTrackerClientUpdater client : this._state.getHealthCheckMap().keySet()) {
            if (clients.contains(client)) continue;
            this._state.getHealthCheckMap().remove(client);
        }
    }

    private static boolean handleClientInRecoveryMap(DegraderControl degraderControl, DegraderTrackerClientUpdater clientUpdater, double initialRecoveryLevel, double ringRampFactor, long callCount, Map<DegraderTrackerClient, Double> newRecoveryMap, PartitionDegraderLoadBalancerState.Strategy strategy) {
        if (callCount < (long)degraderControl.getMinCallCount()) {
            if (strategy == PartitionDegraderLoadBalancerState.Strategy.LOAD_BALANCE) {
                double oldMaxDropRate = clientUpdater.getMaxDropRate();
                double transmissionRate = 1.0 - oldMaxDropRate;
                if (transmissionRate <= 0.0) {
                    transmissionRate = initialRecoveryLevel;
                } else {
                    transmissionRate *= ringRampFactor;
                    transmissionRate = Math.min(transmissionRate, 1.0);
                }
                clientUpdater.setMaxDropRate(1.0 - transmissionRate);
            }
        } else if (!(ringRampFactor > 1.0) || degraderControl.isHigh() || !(degraderControl.getCurrentComputedDropRate() > Math.min(0.5, clientUpdater.getMaxDropRate()))) {
            DegraderTrackerClient client = clientUpdater.getTrackerClient();
            clientUpdater.setMaxDropRate(newRecoveryMap.get(client));
            newRecoveryMap.remove(client);
        }
        return true;
    }

    private static double calculateNewDropLevel(DegraderLoadBalancerStrategyConfig config, double currentOverrideDropRate, double newCurrentAvgClusterLatency, long totalClusterCallCount) {
        double newDropLevel = Math.max(0.0, currentOverrideDropRate);
        if (newCurrentAvgClusterLatency > 0.0 && totalClusterCallCount >= config.getMinClusterCallCountHighWaterMark()) {
            if (newCurrentAvgClusterLatency >= config.getHighWaterMark() && currentOverrideDropRate != 1.0) {
                newDropLevel = Math.min(1.0, newDropLevel + config.getGlobalStepUp());
            } else if (newCurrentAvgClusterLatency <= config.getLowWaterMark() && currentOverrideDropRate != 0.0) {
                newDropLevel = Math.max(0.0, newDropLevel - config.getGlobalStepDown());
            }
        } else if (newCurrentAvgClusterLatency > 0.0 && totalClusterCallCount >= config.getMinClusterCallCountLowWaterMark()) {
            if (newCurrentAvgClusterLatency <= config.getLowWaterMark() && currentOverrideDropRate != 0.0) {
                newDropLevel = Math.max(0.0, newDropLevel - config.getGlobalStepDown());
            }
        } else {
            newDropLevel = Math.max(0.0, newDropLevel - config.getGlobalStepDown());
        }
        return newDropLevel;
    }

    void setStrategy(int partitionId, PartitionDegraderLoadBalancerState.Strategy strategy) {
        Partition partition = this._state.getPartition(partitionId);
        PartitionDegraderLoadBalancerState oldState = partition.getState();
        PartitionDegraderLoadBalancerState newState = new PartitionDegraderLoadBalancerState(oldState.getClusterGenerationId(), oldState.getLastUpdated(), oldState.isInitialized(), oldState.getRingFactory(), oldState.getPointsMap(), strategy, oldState.getCurrentOverrideDropRate(), oldState.getCurrentAvgClusterLatency(), oldState.getRecoveryMap(), oldState.getServiceName(), oldState.getDegraderProperties(), oldState.getCurrentClusterCallCount(), oldState.getCurrentClusterDropCount(), oldState.getCurrentClusterErrorCount(), oldState.getQuarantineMap(), oldState.getQuarantineHistory(), oldState.getTrackerClients(), oldState.getUnHealthyClientNumber());
        partition.setState(newState);
    }

    public String toString() {
        return "DegraderLoadBalancerStrategyV3 [_config=" + this._config + ", _state=" + this._state + "]";
    }

    private /* synthetic */ void lambda$checkQuarantineState$6(DegraderLoadBalancerStrategyConfig config, Callback healthCheckCallback, DegraderTrackerClientUpdater client) {
        try {
            HealthCheck healthCheckClient = this._state.getHealthCheckMap().get(client);
            if (healthCheckClient == null) {
                healthCheckClient = new HealthCheckClientBuilder().setHealthCheckOperations(config.getHealthCheckOperations()).setHealthCheckPath(config.getHealthCheckPath()).setServicePath(config.getServicePath()).setClock(config.getClock()).setLatency(config.getQuarantineLatency()).setMethod(config.getHealthCheckMethod()).setClient(client.getTrackerClient()).build();
                this._state.putHealthCheckClient(client, healthCheckClient);
            }
            healthCheckClient.checkHealth((Callback<None>)healthCheckCallback);
        }
        catch (URISyntaxException e) {
            _log.error("Error to build healthCheckClient ", (Throwable)e);
        }
    }
}

