/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.d2.balancer.clients.DegraderTrackerClient;
import com.linkedin.util.degrader.DegraderControl;

public class DegraderTrackerClientUpdater {
    private final DegraderTrackerClient _trackerClient;
    private final int _partitionId;
    private double _overrideDropRate;
    private double _maxDropRate;
    private int _overrideMinCallCount;

    DegraderTrackerClientUpdater(DegraderTrackerClient trackerClient, int partitionId) {
        this._trackerClient = trackerClient;
        this._partitionId = partitionId;
        DegraderControl degraderControl = this._trackerClient.getDegraderControl(this._partitionId);
        this._overrideDropRate = degraderControl.getOverrideDropRate();
        this._overrideMinCallCount = degraderControl.getOverrideMinCallCount();
        this._maxDropRate = degraderControl.getMaxDropRate();
    }

    public DegraderTrackerClient getTrackerClient() {
        return this._trackerClient;
    }

    double getMaxDropRate() {
        return this._maxDropRate;
    }

    void setOverrideDropRate(double overrideDropRate) {
        this._overrideDropRate = overrideDropRate;
    }

    void setMaxDropRate(double maxDropRate) {
        this._maxDropRate = maxDropRate;
    }

    void setOverrideMinCallCount(int overrideMinCallCount) {
        this._overrideMinCallCount = overrideMinCallCount;
    }

    void update() {
        DegraderControl degraderControl = this._trackerClient.getDegraderControl(this._partitionId);
        degraderControl.setOverrideDropRate(this._overrideDropRate);
        degraderControl.setMaxDropRate(this._maxDropRate);
        degraderControl.setOverrideMinCallCount(this._overrideMinCallCount);
    }

    public String toString() {
        return this._trackerClient.toString();
    }
}

