/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.d2.balancer.strategies.degrader.PartitionDegraderLoadBalancerState;
import com.linkedin.d2.balancer.strategies.degrader.PartitionDegraderLoadBalancerStateListener;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;

class Partition {
    private final int _id;
    private final Lock _lock;
    private volatile PartitionDegraderLoadBalancerState _state;
    private final List<PartitionDegraderLoadBalancerStateListener> _listeners;

    Partition(int id, Lock lock, PartitionDegraderLoadBalancerState state, List<PartitionDegraderLoadBalancerStateListener> listeners) {
        this._id = id;
        this._lock = lock;
        this._state = state;
        this._listeners = listeners;
    }

    public int getId() {
        return this._id;
    }

    public Lock getLock() {
        return this._lock;
    }

    public PartitionDegraderLoadBalancerState getState() {
        return this._state;
    }

    public void setState(PartitionDegraderLoadBalancerState state) {
        this._state = state;
    }

    public List<PartitionDegraderLoadBalancerStateListener> getListeners() {
        return Collections.unmodifiableList(this._listeners);
    }

    public String toString() {
        return String.valueOf(this._state);
    }
}

