/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.d2.balancer.LoadBalancerClient;
import com.linkedin.d2.balancer.clients.DegraderTrackerClient;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.strategies.LoadBalancerQuarantine;
import com.linkedin.d2.balancer.strategies.RingFactory;
import com.linkedin.d2.balancer.util.hashing.Ring;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PartitionDegraderLoadBalancerState {
    private final RingFactory<URI> _ringFactory;
    private final Ring<URI> _ring;
    private final long _clusterGenerationId;
    private final String _serviceName;
    private final Map<String, String> _degraderProperties;
    private final Map<URI, Integer> _pointsMap;
    private final Map<DegraderTrackerClient, Double> _recoveryMap;
    private final Map<DegraderTrackerClient, LoadBalancerQuarantine> _quarantineMap;
    private final Map<DegraderTrackerClient, LoadBalancerQuarantine> _quarantineHistory;
    private final Strategy _strategy;
    private final long _lastUpdated;
    private final double _currentOverrideDropRate;
    private final double _currentAvgClusterLatency;
    private final long _currentClusterCallCount;
    private final long _currentClusterDropCount;
    private final long _currentClusterErrorCount;
    private final int _unHealthyClientNumber;
    private final boolean _initialized;
    private final Map<TrackerClient, Double> _previousMaxDropRate;
    private final Set<DegraderTrackerClient> _trackerClients;

    PartitionDegraderLoadBalancerState(PartitionDegraderLoadBalancerState state, long clusterGenerationId, long lastUpdated) {
        this._clusterGenerationId = clusterGenerationId;
        this._ringFactory = state._ringFactory;
        this._ring = state._ring;
        this._pointsMap = state._pointsMap;
        this._strategy = state._strategy;
        this._currentOverrideDropRate = state._currentOverrideDropRate;
        this._currentAvgClusterLatency = 0.0;
        this._currentClusterDropCount = 0L;
        this._currentClusterErrorCount = 0L;
        this._recoveryMap = state._recoveryMap;
        this._initialized = state._initialized;
        this._lastUpdated = lastUpdated;
        this._serviceName = state._serviceName;
        this._degraderProperties = state._degraderProperties;
        this._previousMaxDropRate = new HashMap<TrackerClient, Double>();
        this._currentClusterCallCount = 0L;
        this._quarantineMap = state._quarantineMap;
        this._quarantineHistory = state._quarantineHistory;
        this._trackerClients = state._trackerClients;
        this._unHealthyClientNumber = state._unHealthyClientNumber;
    }

    public PartitionDegraderLoadBalancerState(long clusterGenerationId, long lastUpdated, boolean initState, RingFactory<URI> ringFactory, Map<URI, Integer> pointsMap, Strategy strategy, double currentOverrideDropRate, double currentAvgClusterLatency, Map<DegraderTrackerClient, Double> recoveryMap, String serviceName, Map<String, String> degraderProperties, long currentClusterCallCount, long currentClusterDropCount, long currentClusterErrorCount, Map<DegraderTrackerClient, LoadBalancerQuarantine> quarantineMap, Map<DegraderTrackerClient, LoadBalancerQuarantine> quarantineHistory, Set<DegraderTrackerClient> trackerClients, int unHealthyClientNumber) {
        this._clusterGenerationId = clusterGenerationId;
        this._ringFactory = ringFactory;
        this._pointsMap = pointsMap != null ? Collections.unmodifiableMap(new HashMap<URI, Integer>(pointsMap)) : Collections.emptyMap();
        Map callTrackerMap = trackerClients != null ? Collections.unmodifiableMap(trackerClients.stream().collect(Collectors.toMap(LoadBalancerClient::getUri, TrackerClient::getCallTracker))) : Collections.emptyMap();
        this._ring = ringFactory.createRing(pointsMap, callTrackerMap);
        this._strategy = strategy;
        this._currentOverrideDropRate = currentOverrideDropRate;
        this._currentAvgClusterLatency = currentAvgClusterLatency;
        this._currentClusterDropCount = currentClusterDropCount;
        this._currentClusterErrorCount = currentClusterErrorCount;
        this._recoveryMap = recoveryMap != null ? Collections.unmodifiableMap(new HashMap<DegraderTrackerClient, Double>(recoveryMap)) : Collections.emptyMap();
        this._initialized = initState;
        this._lastUpdated = lastUpdated;
        this._serviceName = serviceName;
        this._degraderProperties = degraderProperties != null ? Collections.unmodifiableMap(new HashMap<String, String>(degraderProperties)) : Collections.emptyMap();
        this._previousMaxDropRate = new HashMap<TrackerClient, Double>();
        this._currentClusterCallCount = currentClusterCallCount;
        this._quarantineMap = quarantineMap;
        this._quarantineHistory = quarantineHistory;
        this._trackerClients = trackerClients;
        this._unHealthyClientNumber = unHealthyClientNumber;
    }

    public Map<String, String> getDegraderProperties() {
        return this._degraderProperties;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public long getCurrentClusterCallCount() {
        return this._currentClusterCallCount;
    }

    public long getClusterGenerationId() {
        return this._clusterGenerationId;
    }

    public long getLastUpdated() {
        return this._lastUpdated;
    }

    public Ring<URI> getRing() {
        return this._ring;
    }

    public Map<URI, Integer> getPointsMap() {
        return this._pointsMap;
    }

    public Strategy getStrategy() {
        return this._strategy;
    }

    public Map<DegraderTrackerClient, Double> getRecoveryMap() {
        return this._recoveryMap;
    }

    public Map<DegraderTrackerClient, LoadBalancerQuarantine> getQuarantineMap() {
        return this._quarantineMap;
    }

    public Map<DegraderTrackerClient, LoadBalancerQuarantine> getQuarantineHistory() {
        return this._quarantineHistory;
    }

    public double getCurrentOverrideDropRate() {
        return this._currentOverrideDropRate;
    }

    public double getCurrentAvgClusterLatency() {
        return this._currentAvgClusterLatency;
    }

    public Map<TrackerClient, Double> getPreviousMaxDropRate() {
        return this._previousMaxDropRate;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public RingFactory<URI> getRingFactory() {
        return this._ringFactory;
    }

    public long getCurrentClusterDropCount() {
        return this._currentClusterDropCount;
    }

    public long getCurrentClusterErrorCount() {
        return this._currentClusterErrorCount;
    }

    public int getUnHealthyClientNumber() {
        return this._unHealthyClientNumber;
    }

    public Set<DegraderTrackerClient> getTrackerClients() {
        return Collections.unmodifiableSet(this._trackerClients == null ? Collections.emptySet() : this._trackerClients);
    }

    public String toString() {
        int LOG_RECOVERY_MAP_HOSTS = 10;
        return "DegraderLoadBalancerState [_serviceName=" + this._serviceName + ", _currentClusterCallCount=" + this._currentClusterCallCount + ", _currentAvgClusterLatency=" + this._currentAvgClusterLatency + ", _currentOverrideDropRate=" + this._currentOverrideDropRate + ", _currentClusterDropCount=" + this._currentClusterDropCount + ", _currentClusterErrorCount=" + this._currentClusterErrorCount + ", _clusterGenerationId=" + this._clusterGenerationId + ", _unHealthyClientNumber=" + this._unHealthyClientNumber + ", _strategy=" + (Object)((Object)this._strategy) + ", _numHostsInCluster=" + this.getTrackerClients().size() + ", _recoveryMap={" + this._recoveryMap.entrySet().stream().limit(10L).map(entry -> entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining(",")) + (this._recoveryMap.size() <= 10 ? "}" : "...(total " + this._recoveryMap.size() + ")}") + ", _quarantineList=" + this._quarantineMap.values() + "]";
    }

    public static enum Strategy {
        LOAD_BALANCE,
        CALL_DROPPING;

    }
}

