/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.random;

import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.util.hashing.HashFunction;
import com.linkedin.d2.balancer.util.hashing.RandomHash;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;

public class RandomLoadBalancerStrategy
implements LoadBalancerStrategy {
    public static final String RANDOM_STRATEGY_NAME = "random";
    private final Random _random = new Random();

    @Override
    @Nonnull
    public Ring<URI> getRing(long clusterGenerationId, int partitionId, Map<URI, TrackerClient> trackerClients) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HashFunction<Request> getHashFunction() {
        return new RandomHash();
    }

    @Override
    public TrackerClient getTrackerClient(Request request, RequestContext requestContext, long clusterGenerationId, int partitionId, Map<URI, TrackerClient> trackerClients) {
        int size = trackerClients.size();
        if (size > 0) {
            ArrayList<TrackerClient> trackerClientList = new ArrayList<TrackerClient>(trackerClients.values());
            return (TrackerClient)trackerClientList.get(this._random.nextInt(trackerClients.size()));
        }
        return null;
    }

    @Override
    public String getName() {
        return RANDOM_STRATEGY_NAME;
    }
}

