/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.relative;

import com.linkedin.d2.balancer.KeyMapper;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.util.hashing.HashFunction;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSelector {
    private static final Logger LOG = LoggerFactory.getLogger((String)ClientSelector.class.getName());
    private final HashFunction<Request> _requestHashFunction;

    public ClientSelector(HashFunction<Request> requestHashFunction) {
        this._requestHashFunction = requestHashFunction;
    }

    @Nullable
    public TrackerClient getTrackerClient(Request request, RequestContext requestContext, Ring<URI> ring, Map<URI, TrackerClient> trackerClients) {
        URI targetHostUri = KeyMapper.TargetHostHints.getRequestContextTargetHost(requestContext);
        TrackerClient trackerClient = targetHostUri != null ? this.getTrackerClientFromTarget(targetHostUri, requestContext, trackerClients) : this.getTrackerClientFromRing(request, requestContext, ring, trackerClients);
        this.addToExcludedHosts(trackerClient, requestContext);
        return trackerClient;
    }

    private void addToExcludedHosts(TrackerClient trackerClient, RequestContext requestContext) {
        if (trackerClient != null) {
            LoadBalancerStrategy.ExcludedHostHints.addRequestContextExcludedHost(requestContext, trackerClient.getUri());
        }
    }

    private TrackerClient getTrackerClientFromTarget(URI targetHostUri, RequestContext requestContext, Map<URI, TrackerClient> trackerClients) {
        TrackerClient trackerClient = trackerClients.get(targetHostUri);
        if (trackerClient == null) {
            LOG.warn("No client found for ", (Object)targetHostUri, (Object)". Target host specified is no longer part of cluster");
        }
        return trackerClient;
    }

    private TrackerClient getTrackerClientFromRing(Request request, RequestContext requestContext, Ring<URI> ring, Map<URI, TrackerClient> trackerClients) {
        Set<Object> excludedUris = LoadBalancerStrategy.ExcludedHostHints.getRequestContextExcludedHosts(requestContext) == null ? new HashSet() : LoadBalancerStrategy.ExcludedHostHints.getRequestContextExcludedHosts(requestContext);
        int hashCode = this._requestHashFunction.hash(request);
        URI uri = ring.get(hashCode);
        TrackerClient trackerClient = trackerClients.get(uri);
        if (trackerClient == null || excludedUris.contains(uri)) {
            Iterator<URI> ringIterator = ring.getIterator(hashCode);
            while (ringIterator.hasNext() && ((trackerClient = trackerClients.get(uri = ringIterator.next())) == null || excludedUris.contains(uri))) {
                trackerClient = null;
            }
        }
        if (trackerClient == null && (trackerClient = (TrackerClient)trackerClients.values().stream().filter(latestTrackerClient -> !excludedUris.contains(latestTrackerClient.getUri())).findAny().orElse(null)) != null) {
            LOG.warn("Did not find a valid client from the ring, picked {} instead", (Object)trackerClient.getUri());
        }
        return trackerClient;
    }

    public HashFunction<Request> getRequestHashFunction() {
        return this._requestHashFunction;
    }
}

