/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.relative;

import com.linkedin.d2.balancer.LoadBalancerClient;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.strategies.LoadBalancerQuarantine;
import com.linkedin.d2.balancer.strategies.PartitionStateUpdateListener;
import com.linkedin.d2.balancer.strategies.RingFactory;
import com.linkedin.d2.balancer.strategies.relative.TrackerClientState;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheck;
import com.linkedin.util.degrader.CallTracker;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PartitionState {
    private static final long INITIAL_CLUSTER_GENERATION_ID = -1L;
    private static final int LOG_SIZE_LIMIT = 10;
    private int _partitionId;
    private int _pointsPerWeight;
    private RingFactory<URI> _ringFactory;
    private List<PartitionStateUpdateListener<PartitionState>> _listeners;
    private Set<TrackerClient> _recoveryTrackerClients;
    private long _clusterGenerationId;
    private Map<TrackerClient, LoadBalancerQuarantine> _quarantineMap;
    private Map<TrackerClient, LoadBalancerQuarantine> _quarantineHistory;
    private Map<TrackerClient, HealthCheck> _healthCheckMap;
    private Map<URI, Integer> _pointsMap;
    private Ring<URI> _ring;
    private Map<TrackerClient, TrackerClientState> _trackerClientStateMap;
    private PartitionStats _partitionStats;

    public PartitionState(int partitionId, RingFactory<URI> ringFactory, int pointsPerWeight, List<PartitionStateUpdateListener<PartitionState>> listeners) {
        this(partitionId, ringFactory, pointsPerWeight, new HashSet<TrackerClient>(), -1L, new HashMap<TrackerClient, LoadBalancerQuarantine>(), new HashMap<TrackerClient, LoadBalancerQuarantine>(), new HashMap<TrackerClient, HealthCheck>(), new HashMap<TrackerClient, TrackerClientState>(), listeners);
    }

    PartitionState(int partitionId, RingFactory<URI> ringFactory, int pointsPerWeight, Set<TrackerClient> recoveryTrackerClients, long clusterGenerationId, Map<TrackerClient, LoadBalancerQuarantine> quarantineMap, Map<TrackerClient, LoadBalancerQuarantine> quarantineHistory, Map<TrackerClient, HealthCheck> healthCheckMap, Map<TrackerClient, TrackerClientState> trackerClientStateMap, List<PartitionStateUpdateListener<PartitionState>> listeners) {
        this._partitionId = partitionId;
        this._ringFactory = ringFactory;
        this._pointsPerWeight = pointsPerWeight;
        this._recoveryTrackerClients = recoveryTrackerClients;
        this._clusterGenerationId = clusterGenerationId;
        this._quarantineMap = quarantineMap;
        this._quarantineHistory = quarantineHistory;
        this._healthCheckMap = healthCheckMap;
        this._trackerClientStateMap = trackerClientStateMap;
        this._listeners = listeners;
        this.updateRing();
    }

    PartitionState(PartitionState oldPartitionState) {
        this(oldPartitionState.getPartitionId(), oldPartitionState.getRingFactory(), oldPartitionState.getPointsPerWeight(), new HashSet<TrackerClient>(oldPartitionState.getRecoveryTrackerClients()), oldPartitionState.getClusterGenerationId(), new HashMap<TrackerClient, LoadBalancerQuarantine>(oldPartitionState.getQuarantineMap()), new HashMap<TrackerClient, LoadBalancerQuarantine>(oldPartitionState.getQuarantineHistory()), new HashMap<TrackerClient, HealthCheck>(oldPartitionState.getHealthCheckMap()), new HashMap<TrackerClient, TrackerClientState>(oldPartitionState.getTrackerClientStateMap()), oldPartitionState.getListeners());
    }

    int getPartitionId() {
        return this._partitionId;
    }

    long getClusterGenerationId() {
        return this._clusterGenerationId;
    }

    public Map<TrackerClient, TrackerClientState> getTrackerClientStateMap() {
        return this._trackerClientStateMap;
    }

    Set<TrackerClient> getTrackerClients() {
        return this._trackerClientStateMap.keySet();
    }

    public Map<TrackerClient, LoadBalancerQuarantine> getQuarantineMap() {
        return this._quarantineMap;
    }

    Map<TrackerClient, LoadBalancerQuarantine> getQuarantineHistory() {
        return this._quarantineHistory;
    }

    Map<TrackerClient, HealthCheck> getHealthCheckMap() {
        return this._healthCheckMap;
    }

    Set<TrackerClient> getRecoveryTrackerClients() {
        return this._recoveryTrackerClients;
    }

    RingFactory<URI> getRingFactory() {
        return this._ringFactory;
    }

    Ring<URI> getRing() {
        return this._ring;
    }

    void setClusterGenerationId(long clusterGenerationId) {
        this._clusterGenerationId = clusterGenerationId;
    }

    public Map<URI, Integer> getPointsMap() {
        return this._pointsMap;
    }

    void updateRing() {
        Set<TrackerClient> trackerClients = this._trackerClientStateMap.keySet();
        Map<URI, CallTracker> callTrackerMap = Collections.unmodifiableMap(trackerClients.stream().collect(Collectors.toMap(LoadBalancerClient::getUri, TrackerClient::getCallTracker)));
        this._pointsMap = this._trackerClientStateMap.entrySet().stream().collect(Collectors.toMap(entry -> ((TrackerClient)entry.getKey()).getUri(), entry -> (int)Math.round(((TrackerClientState)entry.getValue()).getHealthScore() * ((TrackerClient)entry.getKey()).getPartitionWeight(this._partitionId) * ((TrackerClient)entry.getKey()).getSubsetWeight(this._partitionId) * (double)this._pointsPerWeight)));
        this._ring = this._ringFactory.createRing(this._pointsMap, callTrackerMap);
    }

    void setPartitionStats(double avgClusterLatency, long clusterCallCount, long clusterErrorCount) {
        this._partitionStats = new PartitionStats(avgClusterLatency, clusterCallCount, clusterErrorCount);
    }

    PartitionStats getPartitionStats() {
        return this._partitionStats;
    }

    List<PartitionStateUpdateListener<PartitionState>> getListeners() {
        return this._listeners;
    }

    void removeTrackerClient(TrackerClient trackerClient) {
        this._trackerClientStateMap.remove(trackerClient);
        this._quarantineMap.remove(trackerClient);
        this._quarantineHistory.remove(trackerClient);
        this._healthCheckMap.remove(trackerClient);
        this._recoveryTrackerClients.remove(trackerClient);
    }

    int getPointsPerWeight() {
        return this._pointsPerWeight;
    }

    public String toString() {
        return "PartitionRelativeLoadBalancerState={_partitionId=" + this._partitionId + ", _clusterGenerationId=" + this._clusterGenerationId + ", _numHostsInCluster=" + this.getTrackerClients().size() + ", _partitionStats={" + this._partitionStats + "}, _recoveryTrackerClients={" + this._recoveryTrackerClients.stream().limit(10L).map(client -> client.getUri().toString()).collect(Collectors.joining(",")) + (this._recoveryTrackerClients.size() > 10 ? "...(total " + this._recoveryTrackerClients.size() + ")" : "") + "}, _quarantineMap={" + this._quarantineMap.keySet().stream().limit(10L).map(client -> client.getUri().toString()).collect(Collectors.joining(",")) + (this._quarantineMap.size() > 10 ? "...(total " + this._quarantineMap.size() + ")" : "") + "}}";
    }

    class PartitionStats {
        private final double _avgClusterLatency;
        private final long _clusterCallCount;
        private final long _clusterErrorCount;

        PartitionStats(double avgClusterLatency, long clusterCallCount, long clusterErrorCount) {
            this._avgClusterLatency = avgClusterLatency;
            this._clusterCallCount = clusterCallCount;
            this._clusterErrorCount = clusterErrorCount;
        }

        double getAvgClusterLatency() {
            return this._avgClusterLatency;
        }

        long getClusterCallCount() {
            return this._clusterCallCount;
        }

        long getClusterErrorCount() {
            return this._clusterErrorCount;
        }

        public String toString() {
            return "_avgClusterLatency=" + this._avgClusterLatency + ", _clusterCallCount=" + this._clusterCallCount + ", _clusterErrorCount= " + this._clusterErrorCount;
        }
    }
}

