/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.relative;

import com.linkedin.common.callback.Callback;
import com.linkedin.d2.D2QuarantineProperties;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.strategies.LoadBalancerQuarantine;
import com.linkedin.d2.balancer.strategies.relative.PartitionState;
import com.linkedin.d2.balancer.strategies.relative.TrackerClientState;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheck;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckClientBuilder;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckOperations;
import com.linkedin.util.RateLimitedLogger;
import com.linkedin.util.clock.Clock;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarantineManager {
    private static final Logger LOG = LoggerFactory.getLogger(QuarantineManager.class);
    public static final double SLOW_START_ENABLED_THRESHOLD = 0.0;
    public static final double FAST_RECOVERY_HEALTH_SCORE_THRESHOLD = 0.5;
    public static final double INITIAL_RECOVERY_HEALTH_SCORE = 0.01;
    private static final double DOUBLE_COMPARISON_THRESHOLD = 0.001;
    private static final double QUARANTINE_ENABLED_PERCENTAGE_THRESHOLD = 0.0;
    private static final double FAST_RECOVERY_FACTOR = 2.0;
    private static final double MIN_ZOOKEEPER_SERVER_WEIGHT = 0.0;
    private static final int MAX_RETRIES_TO_CHECK_QUARANTINE = 5;
    private static final int MAX_HOSTS_TO_PRE_CHECK_QUARANTINE = 10;
    private static final long MIN_QUARANTINE_LATENCY_MS = 300L;
    private static final long MAX_QUARANTINE_LATENCY_MS = 1000L;
    private final String _serviceName;
    private final String _servicePath;
    private final HealthCheckOperations _healthCheckOperations;
    private final D2QuarantineProperties _quarantineProperties;
    private final boolean _slowStartEnabled;
    private final boolean _fastRecoveryEnabled;
    private final ScheduledExecutorService _executorService;
    private final Clock _clock;
    private final long _updateIntervalMs;
    private final double _relativeLatencyLowThresholdFactor;
    private final RateLimitedLogger _rateLimitedLogger;
    private final AtomicBoolean _quarantineEnabled;
    private final AtomicInteger _quarantineRetries;

    QuarantineManager(String serviceName, String servicePath, HealthCheckOperations healthCheckOperations, D2QuarantineProperties quarantineProperties, double slowStartThreshold, boolean fastRecoveryEnabled, ScheduledExecutorService executorService, Clock clock, long updateIntervalMs, double relativeLatencyLowThresholdFactor) {
        this._serviceName = serviceName;
        this._servicePath = servicePath;
        this._healthCheckOperations = healthCheckOperations;
        this._quarantineProperties = quarantineProperties;
        this._slowStartEnabled = slowStartThreshold > 0.0;
        this._fastRecoveryEnabled = fastRecoveryEnabled;
        this._executorService = executorService;
        this._clock = clock;
        this._updateIntervalMs = updateIntervalMs;
        this._relativeLatencyLowThresholdFactor = relativeLatencyLowThresholdFactor;
        this._rateLimitedLogger = new RateLimitedLogger(LOG, 5000L, clock);
        this._quarantineEnabled = new AtomicBoolean(false);
        this._quarantineRetries = new AtomicInteger(0);
    }

    public void updateQuarantineState(PartitionState newPartitionState, PartitionState oldPartitionState, long clusterAvgLatency) {
        long quarantineLatency = Math.max((long)((double)clusterAvgLatency * this._relativeLatencyLowThresholdFactor), 300L);
        quarantineLatency = Math.min(1000L, quarantineLatency);
        long currentTime = this._clock.currentTimeMillis();
        this.preCheckQuarantine(newPartitionState, quarantineLatency);
        this.checkAndRemoveQuarantine(newPartitionState);
        this.handleClientsRecovery(newPartitionState);
        this.enrollNewQuarantineAndRecovery(newPartitionState, oldPartitionState, quarantineLatency, currentTime);
    }

    private void preCheckQuarantine(PartitionState partitionState, long quarantineLatency) {
        boolean isQuarantineConfigured;
        boolean bl = isQuarantineConfigured = this._quarantineProperties.hasQuarantineMaxPercent() && this._quarantineProperties.getQuarantineMaxPercent() > 0.0;
        if (isQuarantineConfigured && !this._quarantineEnabled.get() && this._quarantineRetries.incrementAndGet() <= 5) {
            this._executorService.submit(() -> this.preCheckQuarantineState(partitionState, quarantineLatency));
        }
    }

    boolean tryEnableQuarantine() {
        return this._quarantineEnabled.compareAndSet(false, true);
    }

    private void preCheckQuarantineState(PartitionState partitionState, long quarantineLatency) {
        HealthCheckCallBack healthCheckCallback = new HealthCheckCallBack();
        partitionState.getTrackerClients().stream().limit(10L).forEach(client -> {
            try {
                HealthCheck healthCheckClient = partitionState.getHealthCheckMap().get(client);
                if (healthCheckClient == null) {
                    healthCheckClient = new HealthCheckClientBuilder().setHealthCheckOperations(this._healthCheckOperations).setHealthCheckPath(this._quarantineProperties.getHealthCheckPath()).setServicePath(this._servicePath).setClock(this._clock).setLatency(quarantineLatency).setMethod(this._quarantineProperties.getHealthCheckMethod().toString()).setClient((TrackerClient)client).build();
                    partitionState.getHealthCheckMap().put((TrackerClient)client, healthCheckClient);
                }
                healthCheckClient.checkHealth(healthCheckCallback);
            }
            catch (URISyntaxException e) {
                LOG.error("Error to build healthCheckClient ", (Throwable)e);
            }
        });
    }

    private void checkAndRemoveQuarantine(PartitionState partitionState) {
        Map<TrackerClient, LoadBalancerQuarantine> quarantineMap = partitionState.getQuarantineMap();
        Map<TrackerClient, LoadBalancerQuarantine> quarantineHistory = partitionState.getQuarantineHistory();
        Set<TrackerClient> recoverySet = partitionState.getRecoveryTrackerClients();
        for (TrackerClient trackerClient : partitionState.getTrackerClients()) {
            LoadBalancerQuarantine quarantine = quarantineMap.get(trackerClient);
            if (quarantine == null || !quarantine.checkUpdateQuarantineState()) continue;
            quarantineMap.remove(trackerClient);
            quarantineHistory.put(trackerClient, quarantine);
            recoverySet.add(trackerClient);
        }
    }

    private void handleClientsRecovery(PartitionState partitionState) {
        for (TrackerClient trackerClient : partitionState.getTrackerClients()) {
            Set<TrackerClient> recoverySet = partitionState.getRecoveryTrackerClients();
            if (!recoverySet.contains(trackerClient)) continue;
            this.handleSingleClientInRecovery(trackerClient, partitionState.getTrackerClientStateMap().get(trackerClient), partitionState.getRecoveryTrackerClients());
        }
    }

    private void enrollNewQuarantineAndRecovery(PartitionState newPartitionState, PartitionState oldPartitionState, long quarantineLatency, long currentTime) {
        int partitionId = newPartitionState.getPartitionId();
        Map<TrackerClient, LoadBalancerQuarantine> quarantineMap = newPartitionState.getQuarantineMap();
        Map<TrackerClient, LoadBalancerQuarantine> quarantineHistory = newPartitionState.getQuarantineHistory();
        Set<TrackerClient> recoverySet = newPartitionState.getRecoveryTrackerClients();
        for (TrackerClient trackerClient : newPartitionState.getTrackerClients()) {
            double serverWeight;
            TrackerClientState trackerClientState;
            boolean isQuarantined = this.enrollClientInQuarantineMap(trackerClient, trackerClientState = newPartitionState.getTrackerClientStateMap().get(trackerClient), serverWeight = trackerClient.getPartitionWeight(partitionId).doubleValue(), quarantineMap, quarantineHistory, newPartitionState.getTrackerClientStateMap().size(), quarantineLatency, currentTime);
            if (isQuarantined) continue;
            if (!this._fastRecoveryEnabled) {
                this.performNormalRecovery(trackerClientState);
                continue;
            }
            this.enrollSingleClientInRecoverySet(trackerClient, trackerClientState, serverWeight, recoverySet, oldPartitionState);
        }
    }

    private void handleSingleClientInRecovery(TrackerClient trackerClient, TrackerClientState trackerClientState, Set<TrackerClient> recoverySet) {
        if (trackerClientState.getCallCount() < trackerClientState.getAdjustedMinCallCount()) {
            double healthScore = trackerClientState.getHealthScore();
            if (healthScore <= 0.001) {
                trackerClientState.setHealthScore(0.01);
            } else {
                trackerClientState.setHealthScore(Math.min(healthScore *= 2.0, 1.0));
            }
        } else if (trackerClientState.isUnhealthy() || trackerClientState.getHealthScore() > 0.5) {
            recoverySet.remove(trackerClient);
        }
    }

    private boolean enrollClientInQuarantineMap(TrackerClient trackerClient, TrackerClientState trackerClientState, double serverWeight, Map<TrackerClient, LoadBalancerQuarantine> quarantineMap, Map<TrackerClient, LoadBalancerQuarantine> quarantineHistory, int trackerClientSize, long quarantineLatency, long currentTime) {
        if (this._quarantineEnabled.get()) {
            double healthScore = trackerClientState.getHealthScore();
            if (quarantineMap.containsKey(trackerClient)) {
                return true;
            }
            if (healthScore <= 0.001 && serverWeight > 0.0 && trackerClientState.isUnhealthy()) {
                if ((double)quarantineMap.size() < Math.ceil((double)trackerClientSize * this._quarantineProperties.getQuarantineMaxPercent())) {
                    LoadBalancerQuarantine quarantine = quarantineHistory.remove(trackerClient);
                    if (quarantine == null) {
                        quarantine = new LoadBalancerQuarantine(trackerClient, this._executorService, this._clock, this._updateIntervalMs, quarantineLatency, this._quarantineProperties.getHealthCheckMethod().toString(), this._quarantineProperties.getHealthCheckPath(), this._serviceName, this._servicePath, this._healthCheckOperations);
                    }
                    quarantine.reset(currentTime);
                    quarantineMap.put(trackerClient, quarantine);
                    return true;
                }
                LOG.warn("Quarantine for service {} is full! Could not add {}", (Object)this._serviceName, (Object)trackerClient);
            }
        }
        return false;
    }

    private void performNormalRecovery(TrackerClientState trackerClientState) {
        if (trackerClientState.getHealthScore() <= 0.001) {
            trackerClientState.setHealthScore(0.01);
        }
    }

    private void enrollSingleClientInRecoverySet(TrackerClient trackerClient, TrackerClientState trackerClientState, double serverWeight, Set<TrackerClient> recoverySet, PartitionState oldPartitionState) {
        if (trackerClientState.getHealthScore() <= 0.001 && serverWeight > 0.0) {
            trackerClientState.setHealthScore(0.01);
            if (!recoverySet.contains(trackerClient)) {
                recoverySet.add(trackerClient);
            }
        }
        if (!recoverySet.contains(trackerClient) && !oldPartitionState.getTrackerClients().contains(trackerClient) && this._slowStartEnabled && !trackerClient.doNotSlowStart()) {
            recoverySet.add(trackerClient);
        }
    }

    private class HealthCheckCallBack<None>
    implements Callback<None> {
        private HealthCheckCallBack() {
        }

        public void onError(Throwable e) {
            if (!QuarantineManager.this._quarantineEnabled.get()) {
                QuarantineManager.this._rateLimitedLogger.warn("Error enabling quarantine. Health checking failed for service {}: ", (Object)QuarantineManager.this._serviceName, (Object)e);
            }
        }

        public void onSuccess(None result) {
            if (QuarantineManager.this.tryEnableQuarantine()) {
                LOG.info("Quarantine is enabled for service {}", (Object)QuarantineManager.this._serviceName);
            }
        }
    }
}

