/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.relative;

import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.relative.ClientSelector;
import com.linkedin.d2.balancer.strategies.relative.PartitionState;
import com.linkedin.d2.balancer.strategies.relative.StateUpdater;
import com.linkedin.d2.balancer.util.hashing.HashFunction;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelativeLoadBalancerStrategy
implements LoadBalancerStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RelativeLoadBalancerStrategy.class);
    public static final String RELATIVE_LOAD_BALANCER_STRATEGY_NAME = "relative";
    public static final String HASH_METHOD_RANDOM = "random";
    public static final String HASH_METHOD_URI_REGEX = "uriRegex";
    private final StateUpdater _stateUpdater;
    private final ClientSelector _clientSelector;

    public RelativeLoadBalancerStrategy(StateUpdater stateUpdater, ClientSelector clientSelector) {
        this._stateUpdater = stateUpdater;
        this._clientSelector = clientSelector;
    }

    @Override
    public String getName() {
        return RELATIVE_LOAD_BALANCER_STRATEGY_NAME;
    }

    @Override
    @Nullable
    public TrackerClient getTrackerClient(Request request, RequestContext requestContext, long clusterGenerationId, int partitionId, Map<URI, TrackerClient> trackerClients) {
        return this.getTrackerClient(request, requestContext, clusterGenerationId, partitionId, trackerClients, false);
    }

    @Override
    @Nullable
    public TrackerClient getTrackerClient(Request request, RequestContext requestContext, long clusterGenerationId, int partitionId, Map<URI, TrackerClient> trackerClients, boolean shouldForceUpdate) {
        if (trackerClients == null || trackerClients.size() == 0) {
            LOG.warn("getTrackerClient called with null/empty trackerClients, so returning null");
            return null;
        }
        this._stateUpdater.updateState(new HashSet<TrackerClient>(trackerClients.values()), partitionId, clusterGenerationId, shouldForceUpdate);
        Ring<URI> ring = this._stateUpdater.getRing(partitionId);
        return this._clientSelector.getTrackerClient(request, requestContext, ring, trackerClients);
    }

    @Override
    @Nonnull
    public Ring<URI> getRing(long clusterGenerationId, int partitionId, Map<URI, TrackerClient> trackerClients) {
        return this.getRing(clusterGenerationId, partitionId, trackerClients, false);
    }

    @Override
    @Nonnull
    public Ring<URI> getRing(long clusterGenerationId, int partitionId, Map<URI, TrackerClient> trackerClients, boolean shouldForceUpdate) {
        this._stateUpdater.updateState(new HashSet<TrackerClient>(trackerClients.values()), partitionId, clusterGenerationId, shouldForceUpdate);
        return this._stateUpdater.getRing(partitionId);
    }

    public PartitionState getPartitionState(int partitionId) {
        return this._stateUpdater.getPartitionState(partitionId);
    }

    public int getFirstValidPartitionId() {
        return this._stateUpdater.getFirstValidPartitionId();
    }

    Map<URI, Integer> getPointsMap(int partitionId) {
        return this._stateUpdater.getPointsMap(partitionId);
    }

    @Override
    public HashFunction<Request> getHashFunction() {
        return this._clientSelector.getRequestHashFunction();
    }
}

