/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.relative;

import com.linkedin.d2.D2QuarantineProperties;
import com.linkedin.d2.D2RelativeStrategyProperties;
import com.linkedin.d2.D2RingProperties;
import com.linkedin.d2.HashConfig;
import com.linkedin.d2.HashMethod;
import com.linkedin.d2.HttpMethod;
import com.linkedin.d2.HttpStatusCodeRange;
import com.linkedin.d2.HttpStatusCodeRangeArray;
import com.linkedin.d2.balancer.config.RelativeStrategyPropertiesConverter;
import com.linkedin.d2.balancer.event.EventEmitter;
import com.linkedin.d2.balancer.event.NoopEventEmitter;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.strategies.PartitionStateUpdateListener;
import com.linkedin.d2.balancer.strategies.relative.ClientSelector;
import com.linkedin.d2.balancer.strategies.relative.PartitionState;
import com.linkedin.d2.balancer.strategies.relative.QuarantineManager;
import com.linkedin.d2.balancer.strategies.relative.RelativeLoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.relative.RelativeMonitorEventEmitter;
import com.linkedin.d2.balancer.strategies.relative.StateUpdater;
import com.linkedin.d2.balancer.util.hashing.HashFunction;
import com.linkedin.d2.balancer.util.hashing.RandomHash;
import com.linkedin.d2.balancer.util.hashing.URIRegexHash;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckOperations;
import com.linkedin.r2.message.Request;
import com.linkedin.util.clock.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class RelativeLoadBalancerStrategyFactory
implements LoadBalancerStrategyFactory<RelativeLoadBalancerStrategy> {
    public static final long DEFAULT_UPDATE_INTERVAL_MS = 5000L;
    public static final int DEFAULT_MIN_CALL_COUNT = 1;
    public static final double DEFAULT_INITIAL_HEALTH_SCORE = 1.0;
    public static final double DEFAULT_SLOW_START_THRESHOLD = 0.0;
    public static final int DEFAULT_ERROR_STATUS_LOWER_BOUND = 500;
    public static final int DEFAULT_ERROR_STATUS_UPPER_BOUND = 599;
    public static final HttpStatusCodeRangeArray DEFAULT_ERROR_STATUS_FILTER = new HttpStatusCodeRangeArray(new HttpStatusCodeRange().setLowerBound(500).setUpperBound(599), new HttpStatusCodeRange[0]);
    public static final double DEFAULT_UP_STEP = 0.05;
    public static final double DEFAULT_DOWN_STEP = 0.2;
    public static final double DEFAULT_RELATIVE_LATENCY_HIGH_THRESHOLD_FACTOR = 1.3;
    public static final double DEFAULT_RELATIVE_LATENCY_LOW_THRESHOLD_FACTOR = 1.2;
    public static final double DEFAULT_HIGH_ERROR_RATE = 1.1;
    public static final double DEFAULT_LOW_ERROR_RATE = 1.1;
    public static final long DEFAULT_EMITTING_INTERVAL_MS = 0L;
    public static final boolean DEFAULT_ENABLE_FAST_RECOVERY = false;
    public static final double DEFAULT_QUARANTINE_MAX_PERCENT = 0.0;
    public static final HttpMethod DEFAULT_HTTP_METHOD = HttpMethod.OPTIONS;
    public static final int DEFAULT_POINTS_PER_WEIGHT = 100;
    private final ScheduledExecutorService _executorService;
    private final HealthCheckOperations _healthCheckOperations;
    private final List<PartitionStateUpdateListener.Factory<PartitionState>> _stateListenerFactories;
    private final EventEmitter _eventEmitter;
    private final Clock _clock;

    public RelativeLoadBalancerStrategyFactory(ScheduledExecutorService executorService, HealthCheckOperations healthCheckOperations, List<PartitionStateUpdateListener.Factory<PartitionState>> stateListenerFactories, EventEmitter eventEmitter, Clock clock) {
        this._executorService = executorService;
        this._healthCheckOperations = healthCheckOperations;
        this._stateListenerFactories = stateListenerFactories;
        this._eventEmitter = eventEmitter == null ? new NoopEventEmitter() : eventEmitter;
        this._clock = clock;
    }

    @Override
    public RelativeLoadBalancerStrategy newLoadBalancer(ServiceProperties serviceProperties) {
        D2RelativeStrategyProperties relativeStrategyProperties = RelativeStrategyPropertiesConverter.toProperties(serviceProperties.getRelativeStrategyProperties());
        relativeStrategyProperties = RelativeLoadBalancerStrategyFactory.putDefaultValues(relativeStrategyProperties);
        return new RelativeLoadBalancerStrategy(this.getRelativeStateUpdater(relativeStrategyProperties, serviceProperties.getServiceName(), serviceProperties.getClusterName(), serviceProperties.getPath()), this.getClientSelector(relativeStrategyProperties));
    }

    private StateUpdater getRelativeStateUpdater(D2RelativeStrategyProperties relativeStrategyProperties, String serviceName, String clusterName, String servicePath) {
        QuarantineManager quarantineManager = this.getQuarantineManager(relativeStrategyProperties, serviceName, servicePath);
        ArrayList<PartitionStateUpdateListener.Factory<PartitionState>> listenerFactories = new ArrayList<PartitionStateUpdateListener.Factory<PartitionState>>();
        listenerFactories.add(new RelativeMonitorEventEmitter.Factory(serviceName, clusterName, this._clock, relativeStrategyProperties.getEmittingIntervalMs(), relativeStrategyProperties.getRingProperties().getPointsPerWeight(), this._eventEmitter));
        if (this._stateListenerFactories != null) {
            listenerFactories.addAll(this._stateListenerFactories);
        }
        return new StateUpdater(relativeStrategyProperties, quarantineManager, this._executorService, listenerFactories, serviceName);
    }

    private ClientSelector getClientSelector(D2RelativeStrategyProperties relativeStrategyProperties) {
        return new ClientSelector(this.getRequestHashFunction(relativeStrategyProperties));
    }

    private QuarantineManager getQuarantineManager(D2RelativeStrategyProperties relativeStrategyProperties, String serviceName, String servicePath) {
        return new QuarantineManager(serviceName, servicePath, this._healthCheckOperations, relativeStrategyProperties.getQuarantineProperties(), relativeStrategyProperties.getSlowStartThreshold(), relativeStrategyProperties.isEnableFastRecovery(), this._executorService, this._clock, relativeStrategyProperties.getUpdateIntervalMs(), relativeStrategyProperties.getRelativeLatencyLowThresholdFactor());
    }

    private HashFunction<Request> getRequestHashFunction(D2RelativeStrategyProperties relativeStrategyProperties) {
        if (relativeStrategyProperties.hasRingProperties() && relativeStrategyProperties.getRingProperties().hasHashConfig()) {
            HashMethod hashMethod = relativeStrategyProperties.getRingProperties().getHashMethod();
            HashConfig hashConfig = relativeStrategyProperties.getRingProperties().getHashConfig();
            switch (hashMethod) {
                case URI_REGEX: {
                    return new URIRegexHash(RelativeStrategyPropertiesConverter.toHashConfigMap(hashConfig));
                }
            }
            return new RandomHash();
        }
        return new RandomHash();
    }

    static D2RelativeStrategyProperties putDefaultValues(D2RelativeStrategyProperties properties) {
        properties.setUpStep(RelativeLoadBalancerStrategyFactory.getOrDefault(properties.getUpStep(), 0.05));
        properties.setDownStep(RelativeLoadBalancerStrategyFactory.getOrDefault(properties.getDownStep(), 0.2));
        properties.setHighErrorRate(RelativeLoadBalancerStrategyFactory.getOrDefault(properties.getHighErrorRate(), 1.1));
        properties.setLowErrorRate(RelativeLoadBalancerStrategyFactory.getOrDefault(properties.getLowErrorRate(), 1.1));
        properties.setRelativeLatencyHighThresholdFactor(RelativeLoadBalancerStrategyFactory.getOrDefault(properties.getRelativeLatencyHighThresholdFactor(), 1.3));
        properties.setRelativeLatencyLowThresholdFactor(RelativeLoadBalancerStrategyFactory.getOrDefault(properties.getRelativeLatencyLowThresholdFactor(), 1.2));
        properties.setMinCallCount(RelativeLoadBalancerStrategyFactory.getOrDefault(properties.getMinCallCount(), 1));
        properties.setUpdateIntervalMs(RelativeLoadBalancerStrategyFactory.getOrDefault(properties.getUpdateIntervalMs(), 5000L));
        properties.setInitialHealthScore(RelativeLoadBalancerStrategyFactory.getOrDefault(properties.getInitialHealthScore(), 1.0));
        properties.setSlowStartThreshold(RelativeLoadBalancerStrategyFactory.getOrDefault(properties.getSlowStartThreshold(), 0.0));
        properties.setErrorStatusFilter(RelativeLoadBalancerStrategyFactory.getOrDefault(properties.getErrorStatusFilter(), DEFAULT_ERROR_STATUS_FILTER));
        properties.setEmittingIntervalMs(RelativeLoadBalancerStrategyFactory.getOrDefault(properties.getEmittingIntervalMs(), 0L));
        properties.setEnableFastRecovery(RelativeLoadBalancerStrategyFactory.getOrDefault(properties.isEnableFastRecovery(), false));
        D2QuarantineProperties quarantineProperties = properties.hasQuarantineProperties() ? properties.getQuarantineProperties() : new D2QuarantineProperties();
        quarantineProperties.setQuarantineMaxPercent(RelativeLoadBalancerStrategyFactory.getOrDefault(quarantineProperties.getQuarantineMaxPercent(), 0.0));
        quarantineProperties.setHealthCheckMethod(RelativeLoadBalancerStrategyFactory.getOrDefault(quarantineProperties.getHealthCheckMethod(), DEFAULT_HTTP_METHOD));
        properties.setQuarantineProperties(quarantineProperties);
        D2RingProperties ringProperties = properties.hasRingProperties() ? properties.getRingProperties() : new D2RingProperties();
        ringProperties.setPointsPerWeight(RelativeLoadBalancerStrategyFactory.getOrDefault(ringProperties.getPointsPerWeight(), 100));
        properties.setRingProperties(ringProperties);
        return properties;
    }

    private static <R> R getOrDefault(R value, R defaultValue) {
        return value == null ? defaultValue : value;
    }
}

