/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.relative;

import com.linkedin.d2.balancer.event.D2MonitorEventEmitter;
import com.linkedin.d2.balancer.event.EventEmitter;
import com.linkedin.d2.balancer.strategies.PartitionStateUpdateListener;
import com.linkedin.d2.balancer.strategies.relative.PartitionState;
import com.linkedin.util.clock.Clock;

public class RelativeMonitorEventEmitter
implements PartitionStateUpdateListener<PartitionState> {
    private final D2MonitorEventEmitter _d2MonitorEventEmitter;

    public RelativeMonitorEventEmitter(D2MonitorEventEmitter d2MonitorEventEmitter) {
        this._d2MonitorEventEmitter = d2MonitorEventEmitter;
    }

    @Override
    public void onUpdate(PartitionState state) {
        this._d2MonitorEventEmitter.emitEvent(new D2MonitorEventEmitter.ClusterStatsProvider(state.getPointsMap(), state.getQuarantineMap(), state.getTrackerClients(), state.getPartitionStats().getClusterCallCount(), state.getPartitionStats().getAvgClusterLatency(), -1L, state.getPartitionStats().getClusterErrorCount(), -1.0));
    }

    public static class Factory
    implements PartitionStateUpdateListener.Factory<PartitionState> {
        private final String _serviceName;
        private final String _clusterName;
        private final Clock _clock;
        private final long _emitIntervalMs;
        private final int _pointsPerWeight;
        private final EventEmitter _eventEmitter;

        public Factory(String serviceName, String clusterName, Clock clock, long emitIntervalMs, int pointsPerWeight, EventEmitter eventEmitter) {
            this._serviceName = serviceName;
            this._clusterName = clusterName;
            this._clock = clock;
            this._emitIntervalMs = emitIntervalMs;
            this._pointsPerWeight = pointsPerWeight;
            this._eventEmitter = eventEmitter;
        }

        public RelativeMonitorEventEmitter create(int partitionId) {
            D2MonitorEventEmitter d2MonitorEventEmitter = new D2MonitorEventEmitter(this._clusterName, this._serviceName, partitionId, this._clock, this._eventEmitter, this._emitIntervalMs, this._pointsPerWeight);
            return new RelativeMonitorEventEmitter(d2MonitorEventEmitter);
        }
    }
}

