/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.relative;

public class TrackerClientState {
    private static final int MIN_CALL_COUNT_THRESHOLD = 1;
    private static final int INITIAL_CALL_COUNT = 0;
    private final int _minCallCount;
    private int _callCount;
    private double _healthScore;
    private HealthState _healthState;

    public TrackerClientState(double initialHealthScore, int minCallCount) {
        this._healthScore = initialHealthScore;
        this._minCallCount = minCallCount;
        this._callCount = 0;
        this._healthState = HealthState.NEUTRAL;
    }

    public void setCallCount(int callCount) {
        this._callCount = callCount;
    }

    public void setHealthState(HealthState healthState) {
        this._healthState = healthState;
    }

    public void setHealthScore(double healthScore) {
        this._healthScore = healthScore;
    }

    public int getCallCount() {
        return this._callCount;
    }

    public int getAdjustedMinCallCount() {
        return Math.max((int)Math.round(this._healthScore * (double)this._minCallCount), 1);
    }

    public double getHealthScore() {
        return this._healthScore;
    }

    public boolean isUnhealthy() {
        return this._healthState == HealthState.UNHEALTHY;
    }

    public String toString() {
        return "_healthScore=" + this._healthScore;
    }

    static enum HealthState {
        UNHEALTHY,
        NEUTRAL,
        HEALTHY;

    }
}

