/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.subsetting;

import com.linkedin.d2.balancer.subsetting.DeterministicSubsettingMetadata;
import com.linkedin.d2.balancer.subsetting.SubsettingStrategy;
import com.linkedin.d2.balancer.util.hashing.MD5Hash;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeterministicSubsettingStrategy<T extends Comparable<T>>
implements SubsettingStrategy<T> {
    public static final int WEIGHT_DECIMAL_PLACE = 5;
    private final Logger _log = LoggerFactory.getLogger(DeterministicSubsettingStrategy.class);
    private final long _randomSeed;
    private final int _minSubsetSize;

    public DeterministicSubsettingStrategy(String clusterName, int minSubsetSize) {
        MD5Hash hashFunction = new MD5Hash();
        String[] keyTokens = new String[]{clusterName};
        this._randomSeed = hashFunction.hashLong(keyTokens);
        this._minSubsetSize = minSubsetSize;
    }

    @Override
    public Map<T, Double> getWeightedSubset(Map<T, Double> weightMap, DeterministicSubsettingMetadata metadata) {
        if (metadata != null) {
            ArrayList<T> points = new ArrayList<T>(weightMap.keySet());
            Collections.sort(points);
            Collections.shuffle(points, new Random(this._randomSeed));
            List<Double> weights = points.stream().map(weightMap::get).collect(Collectors.toList());
            double totalWeight = weights.stream().mapToDouble(Double::doubleValue).sum();
            if (totalWeight == 0.0) {
                return null;
            }
            Ring ring = new Ring(weights, totalWeight);
            double offset = (double)metadata.getInstanceId() / (double)metadata.getTotalInstanceCount();
            double subsetSliceWidth = this.getSubsetSliceWidth(metadata.getTotalInstanceCount(), points.size());
            List<Integer> indices = ring.getIndices(offset, subsetSliceWidth);
            return indices.stream().collect(Collectors.toMap(points::get, i -> DeterministicSubsettingStrategy.round(ring.getWeight(i, offset, subsetSliceWidth), 5)));
        }
        this._log.warn("Cannot retrieve metadata required for D2 subsetting. Revert to use all available hosts.");
        return null;
    }

    private static double round(double value, int places) {
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    private static boolean isEqual(double a, double b, double delta) {
        return Math.abs(a - b) <= delta;
    }

    private double getSubsetSliceWidth(int totalClientCount, int totalHostCount) {
        double clientUnitWidth = 1.0 / (double)totalClientCount;
        double hostUnitWidth = 1.0 / (double)totalHostCount;
        double adjustedSubsetSliceWidth = (double)((int)Math.ceil((double)this._minSubsetSize * hostUnitWidth / clientUnitWidth)) * clientUnitWidth;
        return Double.min(1.0, adjustedSubsetSliceWidth);
    }

    private static class Ring {
        private static final double DELTA = 1.0E-5;
        private final int _totalPoints;
        private final List<Double> _weights;
        private final double _totalWeight;

        Ring(List<Double> weights, double totalWeight) {
            this._weights = weights;
            this._totalPoints = weights.size();
            this._totalWeight = totalWeight;
        }

        public List<Integer> getIndices(double offset, double width) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            int begin = this.getIndex(offset);
            for (int range = this.getRange(offset, width); range > 0; --range) {
                int index = begin % this._totalPoints;
                indices.add(index);
                ++begin;
            }
            return indices;
        }

        private double getUnitWidth(int index) {
            return this._weights.get(index) / this._totalWeight;
        }

        private double getWidthUntil(int index) {
            double weightsSum = 0.0;
            for (int i = 0; i < index; ++i) {
                weightsSum += this._weights.get(i).doubleValue();
            }
            return weightsSum / this._totalWeight;
        }

        public int getIndex(double offset) {
            double length = 0.0;
            for (int index = 0; index < this._totalPoints; ++index) {
                if (DeterministicSubsettingStrategy.isEqual(length += this.getUnitWidth(index), offset, 1.0E-5)) {
                    return (index + 1) % this._totalPoints;
                }
                if (!(length > offset)) continue;
                return index;
            }
            return 0;
        }

        private int getRange(double offset, double width) {
            int end;
            if (width == 1.0) {
                return this._totalPoints;
            }
            int begin = this.getIndex(offset);
            if (begin == (end = this.getIndex((offset + width) % 1.0))) {
                if (width > this.getUnitWidth(begin)) {
                    return this._totalPoints;
                }
                return 1;
            }
            int adjustedEnd = DeterministicSubsettingStrategy.isEqual(this.getWeight(end, offset, width), 0.0, 1.0E-5) ? end : end + 1;
            int diff = adjustedEnd - begin;
            return diff <= 0 ? diff + this._totalPoints : diff;
        }

        private double getWeight(int index, double offset, double width) {
            double unitWidth = this.getUnitWidth(index);
            if (unitWidth == 0.0) {
                return 0.0;
            }
            double ringSegmentStart = this.getWidthUntil(index);
            double ringSegmentEnd = ringSegmentStart + unitWidth;
            if (offset + width > 1.0) {
                double start = (offset + width) % 1.0;
                double end = offset;
                return 1.0 - this.intersect(ringSegmentStart, ringSegmentEnd, start, end) / unitWidth;
            }
            return this.intersect(ringSegmentStart, ringSegmentEnd, offset, offset + width) / unitWidth;
        }

        private double intersect(double start0, double end0, double start1, double end1) {
            double length = Double.min(end0, end1) - Double.max(start0, start1);
            return Double.min(Double.max(0.0, length), 1.0);
        }
    }
}

