/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.subsetting;

import com.linkedin.d2.balancer.simple.SimpleLoadBalancerState;
import com.linkedin.d2.balancer.subsetting.DeterministicSubsettingMetadata;
import com.linkedin.d2.balancer.subsetting.DeterministicSubsettingMetadataProvider;
import com.linkedin.d2.balancer.subsetting.SubsettingStrategy;
import com.linkedin.d2.balancer.subsetting.SubsettingStrategyFactory;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsettingState {
    private static final Logger LOG = LoggerFactory.getLogger(SubsettingState.class);
    private final ConcurrentMap<String, Object> _lockMap = new ConcurrentHashMap<String, Object>();
    private final SubsettingStrategyFactory _subsettingStrategyFactory;
    private final DeterministicSubsettingMetadataProvider _subsettingMetadataProvider;
    private final Map<String, SubsetCache> _subsetCache;

    public SubsettingState(SubsettingStrategyFactory subsettingStrategyFactory, DeterministicSubsettingMetadataProvider subsettingMetadataProvider) {
        this._subsettingMetadataProvider = subsettingMetadataProvider;
        this._subsettingStrategyFactory = subsettingStrategyFactory;
        this._subsetCache = new HashMap<String, SubsetCache>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubsetItem getClientsSubset(String serviceName, int minClusterSubsetSize, int partitionId, Map<URI, Double> possibleUris, long version, SimpleLoadBalancerState state) {
        SubsettingStrategy<URI> subsettingStrategy = this._subsettingStrategyFactory.get(serviceName, minClusterSubsetSize, partitionId);
        if (subsettingStrategy == null) {
            return new SubsetItem(false, false, possibleUris, Collections.emptySet());
        }
        DeterministicSubsettingMetadata metadata = this._subsettingMetadataProvider.getSubsettingMetadata(state);
        if (metadata == null) {
            return new SubsetItem(false, false, possibleUris, Collections.emptySet());
        }
        Object object = this._lockMap.computeIfAbsent(serviceName, name -> new Object());
        synchronized (object) {
            SubsetCache subsetCache = this._subsetCache.get(serviceName);
            if (this.isCacheValid(version, metadata.getPeerClusterVersion(), minClusterSubsetSize, subsetCache) && subsetCache.getWeightedSubsets().containsKey(partitionId)) {
                return new SubsetItem(true, false, subsetCache.getWeightedSubsets().get(partitionId), Collections.emptySet());
            }
            Map<URI, Double> subsetMap = subsettingStrategy.getWeightedSubset(possibleUris, metadata);
            if (subsetMap == null) {
                return new SubsetItem(false, false, possibleUris, Collections.emptySet());
            }
            LOG.info("Force updating subset cache for service " + serviceName);
            HashSet<URI> doNotSlowStartUris = new HashSet<URI>();
            if (subsetCache != null) {
                Set oldPossibleUris = subsetCache.getPossibleUris().getOrDefault(partitionId, Collections.emptySet());
                for (URI uri : subsetMap.keySet()) {
                    if (!oldPossibleUris.contains(uri)) continue;
                    doNotSlowStartUris.add(uri);
                }
                subsetCache.setVersion(version);
                subsetCache.setPeerClusterVersion(metadata.getPeerClusterVersion());
                subsetCache.setMinClusterSubsetSize(minClusterSubsetSize);
                subsetCache.getPossibleUris().put(partitionId, possibleUris.keySet());
                subsetCache.getWeightedSubsets().put(partitionId, subsetMap);
            } else {
                HashMap<Integer, Set<URI>> servicePossibleUris = new HashMap<Integer, Set<URI>>();
                HashMap<Integer, Map<URI, Double>> serviceWeightedSubset = new HashMap<Integer, Map<URI, Double>>();
                servicePossibleUris.put(partitionId, possibleUris.keySet());
                serviceWeightedSubset.put(partitionId, subsetMap);
                subsetCache = new SubsetCache(version, metadata.getPeerClusterVersion(), minClusterSubsetSize, servicePossibleUris, serviceWeightedSubset);
                this._subsetCache.put(serviceName, subsetCache);
            }
            LOG.debug("Subset cache updated for service " + serviceName + ": " + subsetCache);
            return new SubsetItem(true, true, subsetMap, doNotSlowStartUris);
        }
    }

    private boolean isCacheValid(long version, long peerClusterVersion, int minClusterSubsetSize, SubsetCache subsetCache) {
        return subsetCache != null && version == subsetCache.getVersion() && peerClusterVersion == subsetCache.getPeerClusterVersion() && minClusterSubsetSize == subsetCache.getMinClusterSubsetSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(String serviceName) {
        Object object = this._lockMap.computeIfAbsent(serviceName, name -> new Object());
        synchronized (object) {
            LOG.info("Invalidating subset cache for service " + serviceName);
            this._subsetCache.remove(serviceName);
        }
    }

    public static class SubsetItem {
        private final boolean _isWeightedSubset;
        private final boolean _shouldForceUpdate;
        private final Map<URI, Double> _weightedUriSubset;
        private final Set<URI> _doNotSlowStartUris;

        public SubsetItem(boolean isWeightedSubset, boolean shouldForceUpdate, Map<URI, Double> weightedUriSubset, Set<URI> doNotSlowStartUris) {
            this._isWeightedSubset = isWeightedSubset;
            this._shouldForceUpdate = shouldForceUpdate;
            this._weightedUriSubset = weightedUriSubset;
            this._doNotSlowStartUris = doNotSlowStartUris;
        }

        public boolean isWeightedSubset() {
            return this._isWeightedSubset;
        }

        public boolean shouldForceUpdate() {
            return this._shouldForceUpdate;
        }

        public Map<URI, Double> getWeightedUriSubset() {
            return this._weightedUriSubset;
        }

        public Set<URI> getDoNotSlowStartUris() {
            return this._doNotSlowStartUris;
        }
    }

    private static class SubsetCache {
        private long _version;
        private long _peerClusterVersion;
        private int _minClusterSubsetSize;
        private final Map<Integer, Set<URI>> _possibleUris;
        private final Map<Integer, Map<URI, Double>> _weightedSubsets;

        SubsetCache(long version, long peerClusterVersion, int minClusterSubsetSize, Map<Integer, Set<URI>> possibleUris, Map<Integer, Map<URI, Double>> weightedSubsets) {
            this._version = version;
            this._peerClusterVersion = peerClusterVersion;
            this._minClusterSubsetSize = minClusterSubsetSize;
            this._possibleUris = possibleUris;
            this._weightedSubsets = weightedSubsets;
        }

        public long getVersion() {
            return this._version;
        }

        public long getPeerClusterVersion() {
            return this._peerClusterVersion;
        }

        public int getMinClusterSubsetSize() {
            return this._minClusterSubsetSize;
        }

        public Map<Integer, Set<URI>> getPossibleUris() {
            return this._possibleUris;
        }

        public Map<Integer, Map<URI, Double>> getWeightedSubsets() {
            return this._weightedSubsets;
        }

        public void setVersion(long version) {
            this._version = version;
        }

        public void setPeerClusterVersion(long peerClusterVersion) {
            this._peerClusterVersion = peerClusterVersion;
        }

        public void setMinClusterSubsetSize(int minClusterSubsetSize) {
            this._minClusterSubsetSize = minClusterSubsetSize;
        }

        public String toString() {
            return "SubsetCache{_version=" + this._version + ", _peerClusterVersion=" + this._peerClusterVersion + ", _minClusterSubsetSize=" + this._minClusterSubsetSize + ", _possibleUris=" + this._possibleUris + ", _weightedSubsets=" + this._weightedSubsets + '}';
        }
    }
}

