/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.subsetting;

import com.linkedin.d2.balancer.subsetting.DeterministicSubsettingStrategy;
import com.linkedin.d2.balancer.subsetting.SubsettingStrategy;
import com.linkedin.d2.balancer.subsetting.SubsettingStrategyFactory;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SubsettingStrategyFactoryImpl
implements SubsettingStrategyFactory {
    private final ConcurrentMap<String, ConcurrentMap<Integer, SubsettingStrategy<URI>>> _subsettingStrategyMap = new ConcurrentHashMap<String, ConcurrentMap<Integer, SubsettingStrategy<URI>>>();
    private final ConcurrentMap<String, Integer> _minClusterSubsetSizeMap = new ConcurrentHashMap<String, Integer>();

    @Override
    public SubsettingStrategy<URI> get(String serviceName, int minClusterSubsetSize, int partitionId) {
        if (minClusterSubsetSize <= 0) {
            return null;
        }
        if (this._subsettingStrategyMap.containsKey(serviceName)) {
            Map strategyMap = (Map)this._subsettingStrategyMap.get(serviceName);
            if (minClusterSubsetSize == (Integer)this._minClusterSubsetSizeMap.get(serviceName) && strategyMap.containsKey(partitionId)) {
                return (SubsettingStrategy)strategyMap.get(partitionId);
            }
            strategyMap.put(partitionId, new DeterministicSubsettingStrategy(serviceName, minClusterSubsetSize));
        } else {
            ConcurrentHashMap strategyMap = new ConcurrentHashMap();
            strategyMap.put(partitionId, new DeterministicSubsettingStrategy(serviceName, minClusterSubsetSize));
            this._subsettingStrategyMap.put(serviceName, strategyMap);
        }
        this._minClusterSubsetSizeMap.put(serviceName, minClusterSubsetSize);
        return (SubsettingStrategy)((ConcurrentMap)this._subsettingStrategyMap.get(serviceName)).get(partitionId);
    }
}

