/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.subsetting;

import com.linkedin.common.callback.FutureCallback;
import com.linkedin.d2.balancer.LoadBalancerState;
import com.linkedin.d2.balancer.LoadBalancerStateItem;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.subsetting.DeterministicSubsettingMetadata;
import com.linkedin.d2.balancer.subsetting.DeterministicSubsettingMetadataProvider;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.http.annotation.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKDeterministicSubsettingMetadataProvider
implements DeterministicSubsettingMetadataProvider {
    private static final Logger _log = LoggerFactory.getLogger(ZKDeterministicSubsettingMetadataProvider.class);
    private final String _clusterName;
    private final String _hostName;
    private final long _timeout;
    private final TimeUnit _unit;
    private final Object _lock = new Object();
    @GuardedBy(value="_lock")
    private long _peerClusterVersion = -1L;
    @GuardedBy(value="_lock")
    private DeterministicSubsettingMetadata _subsettingMetadata;

    public ZKDeterministicSubsettingMetadataProvider(String clusterName, String hostName, long timeout, TimeUnit unit) {
        this._clusterName = clusterName;
        this._hostName = hostName;
        this._timeout = timeout;
        this._unit = unit;
    }

    @Override
    public DeterministicSubsettingMetadata getSubsettingMetadata(LoadBalancerState state) {
        FutureCallback metadataFutureCallback = new FutureCallback();
        state.listenToCluster(this._clusterName, (type, name) -> {
            LoadBalancerStateItem<UriProperties> uriItem = state.getUriProperties(this._clusterName);
            Object object = this._lock;
            synchronized (object) {
                if (uriItem.getVersion() != this._peerClusterVersion) {
                    List sortedHosts;
                    int instanceId;
                    this._peerClusterVersion = uriItem.getVersion();
                    UriProperties uriProperties = uriItem.getProperty();
                    this._subsettingMetadata = uriProperties != null ? ((instanceId = (sortedHosts = uriProperties.getPartitionDesc().keySet().stream().map(URI::getHost).sorted().distinct().collect(Collectors.toList())).indexOf(this._hostName)) >= 0 ? new DeterministicSubsettingMetadata(instanceId, sortedHosts.size(), this._peerClusterVersion) : null) : null;
                    _log.debug("Got deterministic subsetting metadata for cluster {}: {}", (Object)this._clusterName, (Object)this._subsettingMetadata);
                }
            }
            metadataFutureCallback.onSuccess((Object)this._subsettingMetadata);
        });
        try {
            return (DeterministicSubsettingMetadata)metadataFutureCallback.get(this._timeout, this._unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            _log.warn("Failed to fetch deterministic subsetting metadata from ZooKeeper for cluster " + this._clusterName, (Throwable)e);
            return null;
        }
    }
}

