/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util;

public class BurstyBarrier {
    static final double MAX_ARRIVALS_WITH_PRECISION = 8.796093022207E12;
    private final Object _lock = new Object();
    private final double _windowSize;
    private final double[] _passThroughHistory;
    private final int _maxBurst;
    private int _oldestPassThroughIdx = 0;
    private double _arrivalsSoFar;

    public BurstyBarrier(double percent, int maxBurst) {
        if (percent <= 0.0 || percent >= 100.0) {
            throw new IllegalArgumentException("percent parameter has to be within range: (0, 100), excluding 0 and 100, got: " + percent);
        }
        if (maxBurst <= 0) {
            throw new IllegalArgumentException("maxBurst parameter has to be a positive number, got: " + maxBurst);
        }
        this._maxBurst = maxBurst;
        this._passThroughHistory = new double[maxBurst];
        this._windowSize = (double)maxBurst * 100.0 / percent;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arrive() {
        Object object = this._lock;
        synchronized (object) {
            this._arrivalsSoFar += 1.0;
            if (this._arrivalsSoFar > 8.796093022207E12) {
                this.reset();
            }
        }
    }

    private void reset() {
        this._arrivalsSoFar = this._windowSize;
        for (int i = 0; i < this._maxBurst; ++i) {
            this._passThroughHistory[i] = 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canPassThrough() {
        Object object = this._lock;
        synchronized (object) {
            double nextAllowedToPass = this._passThroughHistory[this._oldestPassThroughIdx] + this._windowSize;
            if (this._arrivalsSoFar >= nextAllowedToPass) {
                this._passThroughHistory[this._oldestPassThroughIdx] = Math.max(nextAllowedToPass, this._arrivalsSoFar - 1.0);
                ++this._oldestPassThroughIdx;
                if (this._oldestPassThroughIdx == this._maxBurst) {
                    this._oldestPassThroughIdx = 0;
                }
                return true;
            }
            return false;
        }
    }
}

