/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util;

import com.linkedin.d2.balancer.util.URIRewriter;
import com.linkedin.jersey.api.uri.UriBuilder;
import com.linkedin.util.ArgumentUtil;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class D2URIRewriter
implements URIRewriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(D2URIRewriter.class);
    private final URI _httpURI;

    public D2URIRewriter(URI httpURI) {
        this._httpURI = (URI)ArgumentUtil.ensureNotNull((Object)httpURI, (String)"httpURI");
    }

    @Override
    public URI rewriteURI(URI d2Uri) {
        String path = d2Uri.getRawPath();
        UriBuilder builder = UriBuilder.fromUri((URI)this._httpURI);
        if (path != null) {
            builder.path(path);
        }
        builder.replaceQuery(d2Uri.getRawQuery());
        builder.fragment(d2Uri.getRawFragment());
        URI rewrittenUri = builder.build(new Object[0]);
        LOGGER.debug("rewrite uri {} -> {}", (Object)d2Uri, (Object)rewrittenUri);
        return rewrittenUri;
    }
}

