/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDirectory {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemDirectory.class);
    public static final String FILE_STORE_EXTENSION = ".ini";
    public static final String CLUSTER_DIRECTORY = "clusters";
    public static final String DEFAULT_SERVICES_DIRECTORY = "services";
    private final String _d2FsDirPath;
    private String _d2ServicePath;

    public FileSystemDirectory(String d2FsDirPath, String d2ServicePath) {
        this._d2FsDirPath = d2FsDirPath;
        this._d2ServicePath = d2ServicePath;
    }

    public List<String> getServiceNames() {
        return FileSystemDirectory.getFileListWithoutExtension(FileSystemDirectory.getServiceDirectory(this._d2FsDirPath, this._d2ServicePath));
    }

    public void removeAllServicesWithExcluded(Set<String> excludedServices) {
        List<String> serviceNames = this.getServiceNames();
        serviceNames.removeAll(excludedServices);
        FileSystemDirectory.removeAllPropertiesFromDirectory(FileSystemDirectory.getServiceDirectory(this._d2FsDirPath, this._d2ServicePath), serviceNames);
    }

    public void removeAllClustersWithExcluded(Set<String> excludedClusters) {
        List<String> serviceNames = this.getClusterNames();
        serviceNames.removeAll(excludedClusters);
        FileSystemDirectory.removeAllPropertiesFromDirectory(FileSystemDirectory.getServiceDirectory(this._d2FsDirPath, this._d2ServicePath), serviceNames);
    }

    public static void removeAllPropertiesFromDirectory(String path, List<String> properties) {
        for (String property : properties) {
            try {
                Files.deleteIfExists(Paths.get(path + File.separator + property + FILE_STORE_EXTENSION, new String[0]));
            }
            catch (IOException e) {
                LOG.warn("IO Error, continuing deletion", (Throwable)e);
            }
        }
    }

    public List<String> getClusterNames() {
        return FileSystemDirectory.getFileListWithoutExtension(FileSystemDirectory.getClusterDirectory(this._d2ServicePath));
    }

    public static List<String> getFileListWithoutExtension(String path) {
        File dir = new File(path);
        File[] files = dir.listFiles((dir1, name) -> name.endsWith(FILE_STORE_EXTENSION));
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).map(file -> file.getName().replace(FILE_STORE_EXTENSION, "")).collect(Collectors.toList());
    }

    public static String getServiceDirectory(String d2FsDirPath, String d2ServicePath) {
        if (d2ServicePath == null || d2ServicePath.isEmpty()) {
            d2ServicePath = DEFAULT_SERVICES_DIRECTORY;
        }
        return d2FsDirPath + File.separator + d2ServicePath;
    }

    public static String getClusterDirectory(String d2FsDirPath) {
        return d2FsDirPath + File.separator + CLUSTER_DIRECTORY;
    }
}

