/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util;

import com.linkedin.util.ArgumentUtil;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class HostOverrideList {
    private Map<Key, URI> _overrides = new LinkedHashMap<Key, URI>();

    public void addClusterOverride(String cluster, URI uri) {
        ArgumentUtil.notNull((Object)cluster, (String)"cluster");
        ArgumentUtil.notNull((Object)uri, (String)"uri");
        this._overrides.put(new Key(cluster, null), uri);
    }

    public void addServiceOverride(String service, URI uri) {
        ArgumentUtil.notNull((Object)service, (String)"service");
        ArgumentUtil.notNull((Object)uri, (String)"uri");
        this._overrides.put(new Key(null, service), uri);
    }

    public void addOverride(URI uri) {
        ArgumentUtil.notNull((Object)uri, (String)"uri");
        this._overrides.put(Key.WILDCARD_KEY, uri);
    }

    public URI getOverride(String cluster, String service) {
        for (Map.Entry<Key, URI> override : this._overrides.entrySet()) {
            if (!override.getKey().match(cluster, service)) continue;
            return override.getValue();
        }
        return null;
    }

    private static class Key {
        private static final Key WILDCARD_KEY = new Key(null, null);
        private final String _cluster;
        private final String _service;

        public Key(String cluster, String service) {
            this._cluster = cluster;
            this._service = service;
        }

        public boolean match(String cluster, String service) {
            if (this == WILDCARD_KEY) {
                return true;
            }
            if (this._cluster == null) {
                return Objects.equals(this._service, service);
            }
            if (this._service == null) {
                return Objects.equals(this._cluster, cluster);
            }
            return Objects.equals(this._cluster, cluster) && Objects.equals(this._service, service);
        }
    }
}

