/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.clients.DynamicClient;
import com.linkedin.d2.balancer.properties.ClusterProperties;
import com.linkedin.d2.balancer.properties.ClusterPropertiesJsonSerializer;
import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.properties.ServicePropertiesJsonSerializer;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.properties.UriPropertiesJsonSerializer;
import com.linkedin.d2.balancer.properties.UriPropertiesMerger;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancer;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancerState;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyFactoryV3;
import com.linkedin.d2.balancer.strategies.random.RandomLoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.strategies.relative.RelativeLoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.util.JacksonUtil;
import com.linkedin.d2.balancer.util.LoadBalancerUtil;
import com.linkedin.d2.balancer.zkfs.ZKFSComponentFactory;
import com.linkedin.d2.balancer.zkfs.ZKFSLoadBalancer;
import com.linkedin.d2.balancer.zkfs.ZKFSTogglingLoadBalancerFactoryImpl;
import com.linkedin.d2.balancer.zkfs.ZKFSUtil;
import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.d2.discovery.event.PropertyEventBusImpl;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.d2.discovery.stores.PropertyStore;
import com.linkedin.d2.discovery.stores.PropertyStoreException;
import com.linkedin.d2.discovery.stores.file.FileStore;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeper;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperEphemeralStore;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperPermanentStore;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperPropertyMerger;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperStore;
import com.linkedin.d2.discovery.util.D2Config;
import com.linkedin.d2.jmx.JmxManager;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.http.client.HttpClientFactory;
import com.linkedin.r2.util.NamedThreadFactory;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitoredHost;

public class LoadBalancerClientCli {
    private ZKFSLoadBalancer _zkfsLoadBalancer;
    private ZKConnection _zkclient;
    private File _tmpDir;
    private static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static final long TIMEOUT = 5000L;
    private static final int SESSION_TIMEOUT = 60000;
    private String _zkConnectionString = null;
    private String _d2path = null;
    private String _cluster = null;
    private String _service = "";
    private String _method = "";
    private String _request = null;
    private DynamicClient _client = null;
    private static String _tmpdirName = "temp-d2TmpFileStore" + Long.toString(System.nanoTime());
    private ZooKeeperPermanentStore<ClusterProperties> _zkClusterRegistry = null;
    private ZooKeeperPermanentStore<ServiceProperties> _zkServiceRegistry = null;
    private ZooKeeperEphemeralStore<UriProperties> _zkUriRegistry = null;
    private static final Options OPTIONS = new Options();
    private static final Logger _log = LoggerFactory.getLogger(LoadBalancerClientCli.class);

    public static void main(String[] args) throws Exception {
        new LoadBalancerClientCli(args);
    }

    public static List<String> asList(String ... args) {
        return Arrays.asList(args);
    }

    public LoadBalancerClientCli(String[] args) throws Exception {
        OPTIONS.addOption("h", "help", false, "Show help.");
        OPTIONS.addOption("z", "zkserver", true, "Zookeeper server string (example:zk://localhost:2121).");
        OPTIONS.addOption("p", "path", true, "Discovery path (example: /d2).");
        OPTIONS.addOption("h", "host", true, "Host name.");
        OPTIONS.addOption("b", "enabled", true, "Enabled toggling store (value either 'true' or 'false'.");
        OPTIONS.addOption("f", "file", true, "D2 clusters/services configuration file.");
        OPTIONS.addOption("c", "cluster", true, "Cluster name.");
        OPTIONS.addOption("s", "service", true, "Service name.");
        OPTIONS.addOption("m", "method", true, "Service method name.");
        OPTIONS.addOption("r", "request", true, "Request string or file.");
        OPTIONS.addOption("t", "requestype", true, "Request type: value either rpc or rest (default - rest).");
        OPTIONS.addOption("d", "delete", true, "Delete store (cluster or service name).");
        OPTIONS.addOption("n", "storename", true, "Store name (value either 'clusters' or 'services' or 'uris').");
        OPTIONS.addOption("D", "rundiscovery", false, "Run discovery (register clusters/services with zk).");
        OPTIONS.addOption("P", "printstore", false, "Print single store.");
        OPTIONS.addOption("S", "printstores", false, "Print all stores.");
        OPTIONS.addOption("H", "printschema", false, "Print service schema.");
        OPTIONS.addOption("R", "sendrequest", false, "Send request to service.");
        OPTIONS.addOption("e", "endpoints", false, "Print service endpoints.");
        OPTIONS.addOption("T", "toggle", false, "Reset toggling store.");
        CommandLine cl = null;
        try {
            GnuParser parser = new GnuParser();
            cl = parser.parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.err.println("Invalid arguments: " + e.getMessage());
            this.usage();
        }
        if (cl.hasOption("z") && cl.hasOption("p")) {
            LoadBalancerClientCli clobj = new LoadBalancerClientCli(cl.getOptionValue("z"), cl.getOptionValue("p"));
            clobj.createZkClient(cl.getOptionValue("z"));
            clobj.startZkClient();
            if (cl.hasOption("D") && cl.hasOption("f")) {
                LoadBalancerClientCli.runDiscovery(cl.getOptionValue("z"), cl.getOptionValue("p"), new File(cl.getOptionValue("f")));
                clobj.shutdown();
            } else if (cl.hasOption("d") && cl.hasOption("n")) {
                this.deleteStore(clobj.getZKClient(), cl.getOptionValue("z"), cl.getOptionValue("p"), cl.getOptionValue("n"), cl.getOptionValue("d"));
                clobj.shutdown();
            } else if (cl.hasOption("S")) {
                System.err.println(LoadBalancerClientCli.printStores(clobj.getZKClient(), cl.getOptionValue("z"), cl.getOptionValue("p")));
            } else if (cl.hasOption("T") && cl.hasOption("h") && cl.hasOption("b")) {
                String host = cl.getOptionValue("h");
                boolean toggled = !"false".equals(cl.getOptionValue("b"));
                LoadBalancerClientCli.resetTogglingStores(host == null ? "localhost" : host, toggled);
            } else if (cl.hasOption("c") && cl.hasOption("s")) {
                String requestType = "rest";
                if (cl.hasOption("t")) {
                    requestType = cl.getOptionValue("t");
                }
                clobj.setCluster(cl.getOptionValue("c"));
                clobj.setService(cl.getOptionValue("s"));
                if (cl.hasOption("P")) {
                    LoadBalancerClientCli.printStore(clobj.getZKClient(), cl.getOptionValue("z"), cl.getOptionValue("p"), clobj.getCluster(), clobj.getService());
                } else if (cl.hasOption("H")) {
                    System.err.println(this.getSchema(clobj.getZKClient(), cl.getOptionValue("z"), cl.getOptionValue("p"), clobj.getCluster(), clobj.getService(), requestType));
                    clobj.shutdown();
                } else if (cl.hasOption("e")) {
                    clobj.getEndpoints(cl.getOptionValue("z"), cl.getOptionValue("p"), clobj.getCluster(), clobj.getService());
                    clobj.shutdown();
                } else if (cl.hasOption("R") && cl.hasOption("r")) {
                    if (cl.hasOption("m")) {
                        clobj.setMethod("/" + cl.getOptionValue("m"));
                    }
                    clobj.setRequest(cl.getOptionValue("r"));
                    clobj.createClient();
                    System.err.println("RESPONSE:" + this.sendRequest(clobj.getClient(), clobj.getZKClient(), cl.getOptionValue("z"), cl.getOptionValue("p"), clobj.getCluster(), clobj.getService(), "", clobj.getRequest(), requestType, true));
                } else {
                    this.usage();
                }
            } else {
                this.usage();
            }
        } else {
            this.usage();
        }
    }

    public LoadBalancerClientCli(String zkserverHostPort, String d2path) throws Exception {
        this._zkConnectionString = zkserverHostPort;
        this._zkclient = this.createZkClient(zkserverHostPort);
        this._d2path = d2path;
        this.startZkClient();
    }

    public LoadBalancerClientCli(String zkserverHostPort, String d2path, String serviceName) throws Exception {
        this._zkConnectionString = zkserverHostPort;
        this._zkclient = this.createZkClient(zkserverHostPort);
        this._d2path = d2path;
        this._service = serviceName;
        this.startZkClient();
    }

    private void usage() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("\nExamples");
        sb.append("\n========");
        sb.append("\nExample RunDiscovery (register clusters/services with zk): lb-client.sh -z zk://localhost:2121 -p /d2 -f d2_config_example.json -D");
        sb.append("\nExample RunDiscovery (register clusters/services with zk): lb-client.sh --zkserver zk://localhost:2121 --path /d2 --file d2_config_example.json --rundiscovery");
        sb.append("\nExample Print zk stores: lb-client.sh -z zk://localhost:2121 -p /d2 -c cluster-1 -s service-1_1 -S");
        sb.append("\nExample Print zk stores: lb-client.sh --zkserver zk://localhost:2121 --path /d2 --cluster cluster-1 --service service-1_1 --printstores");
        sb.append("\nExample Print single store: lb-client.sh -z=zk://localhost:2181 -p=/d2 -c='cluster-1' -s=service-1_1 -P");
        sb.append("\nExample Print single store: lb-client.sh --zkserver=zk://localhost:2181 --path=/d2 --cluster='cluster-1' --service=service-1_1 --printstore");
        sb.append("\nExample Delete store: lb-client.sh -z zk://localhost:2121 -p /d2 -d cluster-2 -n clusters");
        sb.append("\nExample Delete store: lb-client.sh -z zk://localhost:2121 -p /d2 -d service-3_3 -n services");
        sb.append("\nExample Delete store: lb-client.sh --zkserver zk://localhost:2121 --path /d2  --delete cluster-2 -storename clusters");
        sb.append("\nExample Print Service Schema: lb-client.sh -z zk://localhost:2121 -p /d2 -c 'cluster-1' -s service-1_1 -H");
        sb.append("\nExample Print Service Schema: lb-client.sh --zkserver zk://localhost:2181 --path /d2 --cluster 'cluster-1' --service service-1_1 --printschema");
        sb.append("\nExample Get Endpoints: lb-client.sh --zkserver zk://localhost:2121 --path /d2 --cluster cluster-1 --endpoints --service service-1_1");
        sb.append("\nExample Send request to service: lb-client.sh -z zk://localhost:2181 -p /d2 -c 'cluster-1' -s service-1_1 -r 'test' -R");
        sb.append("\nExample Send request to service: lb-client.sh -z zk://localhost:2181 -p /d2 -c 'cluster-1' -s service-1_1 -r 'test' -t rpc -R");
        sb.append("\nExample Send request to service: lb-client.sh --zkserver zk://localhost:2181 --path /d2 --cluster 'cluster-1' --service service-1_1 --request 'test' --sendrequest");
        sb.append("\nExample Send request to service: lb-client.sh -z zk://localhost:2181 -p /d2 -c 'history-write-1' -s HistoryService -m getCube -r 'test' -R");
        sb.append("\nExample Send request to service: lb-client.sh --zkserver zk://localhost:2181 --path /d2 --cluster 'history-write-1' --service HistoryService --method getCube --request 'test' --sendrequest");
        sb.append("\nExample Reset toggling stores: lb-client.sh -z zk://localhost:2121 -p /d2 -h localhost -b false -T");
        sb.append("\nExample Reset toggling stores: lb-client.sh --zkserver zk://localhost:2121 --path /d2 --host localhost --enabled false --toggle");
        sb.append("\n");
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("lb-client.sh -z=zk://<zk host port> -p=<d2 path> ... parameters..." + sb.toString(), OPTIONS);
        System.exit(0);
    }

    public void getEndpoints(String zkServer, String d2path, String cluster, String service) throws Exception {
        Map<String, UriProperties> scMap = this.getServiceClustersURIsInfo(zkServer, d2path, service);
        if (scMap != null && scMap.get(cluster) != null) {
            for (Map.Entry<URI, Map<Integer, PartitionData>> uriEntry : scMap.get(cluster).getPartitionDesc().entrySet()) {
                System.out.println("uri: " + uriEntry.getKey());
                for (Map.Entry<Integer, PartitionData> pData : uriEntry.getValue().entrySet()) {
                    System.out.println("  " + pData.getKey() + ": " + pData.getValue());
                }
            }
        } else {
            System.out.println("No cluster information found for service: " + service + ", in cluster: " + cluster);
        }
    }

    public static int runDiscovery(String zkserverHostPort, String d2path, File jsonConfigFile) throws Exception {
        if (jsonConfigFile.exists()) {
            _log.info("Reading d2 config data:" + jsonConfigFile.getAbsolutePath());
            Map configMap = (Map)JacksonUtil.getObjectMapper().readValue(jsonConfigFile, HashMap.class);
            return LoadBalancerClientCli.runDiscovery(zkserverHostPort, d2path, configMap);
        }
        _log.error("File " + jsonConfigFile.getAbsolutePath() + " does not exist. Check your data.");
        return -1;
    }

    public static int runDiscovery(String zkserverHostPort, String d2path, String jsonConfigData) throws Exception {
        _log.info("Reading d2 config data:" + jsonConfigData);
        Map configMap = (Map)JacksonUtil.getObjectMapper().readValue(jsonConfigData, HashMap.class);
        return LoadBalancerClientCli.runDiscovery(zkserverHostPort, d2path, configMap);
    }

    private static int runDiscovery(String zkserverHostPort, String d2path, Map<String, Object> configMap) throws Exception {
        String zkHosts = zkserverHostPort.replace("zk://", "");
        Map clusterDefaults = (Map)configMap.get("clusterDefaults");
        Map serviceDefaults = (Map)configMap.get("serviceDefaults");
        Map clusterServiceConfigurations = (Map)configMap.get("clusterServiceConfigurations");
        Map extraClusterServiceConfigurations = (Map)configMap.get("extraClusterServiceConfigurations");
        Map serviceVariants = (Map)configMap.get("serviceVariants");
        D2Config d2conf = new D2Config(zkHosts, 10000, d2path, 5000L, 10, clusterDefaults, serviceDefaults, clusterServiceConfigurations, extraClusterServiceConfigurations, serviceVariants);
        return d2conf.configure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchema(ZKConnection zkclient, String zkserver, String d2path, String cluster, String service, String requestType) throws URISyntaxException, InterruptedException, ExecutionException, IOException, PropertyStoreException, TimeoutException {
        String responseString = null;
        if (LoadBalancerClientCli.hasService(zkclient, zkserver, d2path, cluster, service)) {
            DynamicClient client = new DynamicClient(LoadBalancerClientCli.getLoadBalancer(zkclient, zkserver, d2path, service), null);
            URI uri = URI.create("d2://" + service + "/");
            try {
                RestRequest restRequest = new RestRequestBuilder(uri).setEntity("".getBytes("UTF-8")).build();
                Future response = client.restRequest(restRequest, new RequestContext());
                responseString = ((RestResponse)response.get()).getEntity().asString("UTF-8");
            }
            finally {
                LoadBalancerUtil.syncShutdownClient(this._client, _log);
                zkclient.shutdown();
            }
        } else {
            System.out.println("Service '" + service + "' is not defined for cluster '" + cluster + "'.");
        }
        return responseString;
    }

    public void createClient() throws URISyntaxException, InterruptedException, ExecutionException, IOException, PropertyStoreException, TimeoutException {
        this._client = this.createClient(this._zkclient, this._zkConnectionString, this._d2path, this._service);
    }

    public DynamicClient createClient(ZKConnection zkclient, String zkserver, String d2path, String service) throws URISyntaxException, InterruptedException, ExecutionException, IOException, PropertyStoreException, TimeoutException {
        return new DynamicClient(LoadBalancerClientCli.getLoadBalancer(zkclient, zkserver, d2path, service), null);
    }

    public DynamicClient createZKFSTogglingLBClient(String zkHostsPortsConnectionString, String d2path, String servicePath) throws URISyntaxException, InterruptedException, ExecutionException, IOException, PropertyStoreException, TimeoutException, Exception {
        this._zkfsLoadBalancer = this.getZKFSLoadBalancer(zkHostsPortsConnectionString, d2path, servicePath);
        FutureCallback startupCallback = new FutureCallback();
        this._zkfsLoadBalancer.start((Callback<None>)startupCallback);
        startupCallback.get(5000L, TimeUnit.MILLISECONDS);
        return new DynamicClient(this._zkfsLoadBalancer, null);
    }

    public DynamicClient getClient() {
        return this._client;
    }

    public String sendRequest(DynamicClient client, String cluster, String service, String request) throws Exception {
        return this.sendRequest(client, this._zkclient, this._zkConnectionString, this._d2path, cluster, service, "", request, "rest", false);
    }

    public String sendRequest(DynamicClient client, String cluster, String service, String request, String requestType) throws Exception {
        return this.sendRequest(client, this._zkclient, this._zkConnectionString, this._d2path, cluster, service, "", request, requestType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendRequest(DynamicClient client, ZKConnection zkclient, String zkserver, String d2path, String cluster, String service, String method, String request, String requestType, boolean performShutdown) throws Exception {
        String responseString = null;
        URI uri = URI.create("d2://" + service + method);
        try {
            RestRequest restRequest = new RestRequestBuilder(uri).setEntity(request.getBytes("UTF-8")).build();
            Future response = client.restRequest(restRequest, new RequestContext());
            responseString = ((RestResponse)response.get()).getEntity().asString("UTF-8");
        }
        finally {
            if (performShutdown) {
                LoadBalancerUtil.syncShutdownClient(this._client, _log);
                zkclient.shutdown();
            }
        }
        return responseString;
    }

    public void setCluster(String cluster) {
        this._cluster = cluster;
    }

    public String getCluster() {
        return this._cluster;
    }

    public void setD2Path(String d2path) {
        this._d2path = d2path;
    }

    public String getD2Path() {
        return this._d2path;
    }

    public void setService(String service) {
        this._service = service;
    }

    public String getService() {
        return this._service;
    }

    public ZKConnection createZkClient(String zkserverHostPort) {
        this._zkclient = new ZKConnection(zkserverHostPort.replace("zk://", ""), 10000);
        return this._zkclient;
    }

    public ZKConnection getZKClient() {
        return this._zkclient;
    }

    public void startZkClient() throws IOException, InterruptedException, TimeoutException {
        this._zkclient.start();
        this._zkclient.waitForState(Watcher.Event.KeeperState.SyncConnected, 40L, TimeUnit.SECONDS);
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public String getMethod() {
        return this._method;
    }

    public void setRequest(String request) {
        this._request = request;
    }

    public String getRequest() {
        return this._request;
    }

    public void deleteStore(ZKConnection zkclient, String zkserverHostPort, String d2path, String storeName, String listenTo) throws Exception {
        String storeString = zkserverHostPort + d2path + "/" + storeName;
        PropertyStore store = LoadBalancerClientCli.getStore(zkclient, storeString, null);
        store.remove(listenTo);
        this.shutdownPropertyStore(store, 60L, TimeUnit.SECONDS);
    }

    public static <T> PropertyStore<T> getStore(ZKConnection zkclient, String store, PropertySerializer<T> serializer) throws URISyntaxException, IOException, PropertyStoreException {
        URI storeUri = URI.create(store);
        if (storeUri.getScheme() != null) {
            if (storeUri.getScheme().equals("zk")) {
                ZooKeeperPermanentStore<T> zkStore = new ZooKeeperPermanentStore<T>(zkclient, serializer, storeUri.getPath());
                LoadBalancerClientCli.startStore(zkStore);
                return zkStore;
            }
            throw new URISyntaxException(store, "Unable to parse store uri. Only zk and file stores are supported.");
        }
        return new FileStore<T>(storeUri.getPath(), ".json", serializer);
    }

    public static List<String> getServicesGroups(ZKConnection zkclient, String basePath) throws Exception {
        ArrayList<String> servicesGroups = new ArrayList<String>();
        ZooKeeper zook = zkclient.getZooKeeper();
        List<String> children = zook.getChildren(basePath, false);
        for (String child : children) {
            if (child.equalsIgnoreCase("clusters") || child.equalsIgnoreCase("uris")) continue;
            servicesGroups.add(child);
        }
        return servicesGroups;
    }

    public static <T> PropertyStore<T> getEphemeralStore(ZKConnection zkclient, String store, PropertySerializer<T> serializer, ZooKeeperPropertyMerger<T> merger) throws URISyntaxException, IOException, PropertyStoreException {
        URI storeUri = URI.create(store);
        if (storeUri.getScheme() != null) {
            if (storeUri.getScheme().equals("zk")) {
                ZooKeeperEphemeralStore<T> zkStore = new ZooKeeperEphemeralStore<T>(zkclient, serializer, merger, storeUri.getPath());
                LoadBalancerClientCli.startStore(zkStore);
                return zkStore;
            }
            throw new URISyntaxException(store, "Unable to parse store uri. Only zk and file stores are supported.");
        }
        return new FileStore<T>(storeUri.getPath(), ".json", serializer);
    }

    private static <T> void startStore(PropertyStore<T> store) throws PropertyStoreException {
        try {
            FutureCallback callback = new FutureCallback();
            store.start((Callback<None>)callback);
            callback.get(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new PropertyStoreException("Failed to start store", e);
        }
    }

    public static SimpleLoadBalancer getLoadBalancer(ZKConnection zkclient, String zkserver, String d2path, String service) throws IOException, IllegalStateException, URISyntaxException, PropertyStoreException, ExecutionException, TimeoutException, InterruptedException {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("D2 PropertyEventExecutor"));
        SimpleLoadBalancerState state = LoadBalancerClientCli.createSimpleLoadBalancerState(zkclient, zkserver, d2path, executor);
        SimpleLoadBalancer balancer = new SimpleLoadBalancer(state, 5L, TimeUnit.SECONDS, executor);
        FutureCallback callback = new FutureCallback();
        balancer.start((Callback<None>)callback);
        callback.get(5L, TimeUnit.SECONDS);
        new JmxManager().registerLoadBalancer("balancer", balancer);
        return balancer;
    }

    public static SimpleLoadBalancerState createSimpleLoadBalancerState(ZKConnection zkclient, String zkserver, String d2path, ScheduledThreadPoolExecutor executor) throws PropertyStoreException, URISyntaxException, IOException {
        String clstoreString = zkserver + ZKFSUtil.clusterPath(d2path);
        String scstoreString = zkserver + ZKFSUtil.servicePath(d2path);
        String uristoreString = zkserver + ZKFSUtil.uriPath(d2path);
        ZooKeeperPermanentStore zkClusterRegistry = (ZooKeeperPermanentStore)LoadBalancerClientCli.getStore(zkclient, clstoreString, new ClusterPropertiesJsonSerializer());
        ZooKeeperPermanentStore zkServiceRegistry = (ZooKeeperPermanentStore)LoadBalancerClientCli.getStore(zkclient, scstoreString, new ServicePropertiesJsonSerializer());
        ZooKeeperEphemeralStore zkUriRegistry = (ZooKeeperEphemeralStore)LoadBalancerClientCli.getEphemeralStore(zkclient, uristoreString, new UriPropertiesJsonSerializer(), new UriPropertiesMerger());
        PropertyEventBusImpl<ServiceProperties> serviceBus = new PropertyEventBusImpl<ServiceProperties>(executor, zkServiceRegistry);
        PropertyEventBusImpl<UriProperties> uriBus = new PropertyEventBusImpl<UriProperties>(executor, zkUriRegistry);
        PropertyEventBusImpl<ClusterProperties> clusterBus = new PropertyEventBusImpl<ClusterProperties>(executor, zkClusterRegistry);
        HashMap<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories = new HashMap<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>>();
        loadBalancerStrategyFactories.put("random", new RandomLoadBalancerStrategyFactory());
        loadBalancerStrategyFactories.put("degrader", new DegraderLoadBalancerStrategyFactoryV3());
        loadBalancerStrategyFactories.put("degraderV2", new DegraderLoadBalancerStrategyFactoryV3());
        loadBalancerStrategyFactories.put("degraderV3", new DegraderLoadBalancerStrategyFactoryV3());
        loadBalancerStrategyFactories.put("degraderV2_1", new DegraderLoadBalancerStrategyFactoryV3());
        loadBalancerStrategyFactories.put("relative", new RelativeLoadBalancerStrategyFactory(executor, null, null, null, (Clock)SystemClock.instance()));
        HashMap<String, TransportClientFactory> clientFactories = new HashMap<String, TransportClientFactory>();
        clientFactories.put("http", (TransportClientFactory)new HttpClientFactory.Builder().build());
        SimpleLoadBalancerState state = new SimpleLoadBalancerState((ScheduledExecutorService)executor, uriBus, clusterBus, serviceBus, clientFactories, loadBalancerStrategyFactories, null, null, false);
        new JmxManager().registerLoadBalancerState("state", state).registerScheduledThreadPoolExecutor("executorService", executor).registerZooKeeperPermanentStore("zkClusterRegistry", zkClusterRegistry).registerZooKeeperPermanentStore("zkServiceRegistry", zkServiceRegistry).registerZooKeeperEphemeralStore("zkUriRegistry", zkUriRegistry);
        return state;
    }

    public ZKFSLoadBalancer getZKFSLoadBalancer(String zkConnectString, String d2path, String d2ServicePath) throws Exception {
        this._tmpDir = LoadBalancerClientCli.createTempDirectory(_tmpdirName);
        ZKFSComponentFactory componentFactory = new ZKFSComponentFactory();
        if (d2ServicePath == null || d2ServicePath.isEmpty()) {
            d2ServicePath = "services";
        }
        HashMap<String, TransportClientFactory> clientFactories = new HashMap<String, TransportClientFactory>();
        clientFactories.put("http", (TransportClientFactory)new HttpClientFactory.Builder().build());
        HashMap<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories = new HashMap<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>>();
        loadBalancerStrategyFactories.put("random", new RandomLoadBalancerStrategyFactory());
        loadBalancerStrategyFactories.put("degrader", new DegraderLoadBalancerStrategyFactoryV3());
        loadBalancerStrategyFactories.put("degraderV2", new DegraderLoadBalancerStrategyFactoryV3());
        loadBalancerStrategyFactories.put("degraderV3", new DegraderLoadBalancerStrategyFactoryV3());
        loadBalancerStrategyFactories.put("degraderV2_1", new DegraderLoadBalancerStrategyFactoryV3());
        ZKFSTogglingLoadBalancerFactoryImpl factory = new ZKFSTogglingLoadBalancerFactoryImpl(componentFactory, 5000L, TimeUnit.MILLISECONDS, d2path, this._tmpDir.getAbsolutePath(), clientFactories, loadBalancerStrategyFactories, d2ServicePath, null, null, false);
        return new ZKFSLoadBalancer(zkConnectString, 60000, 5000, factory, null, d2path);
    }

    public Set<UriProperties> getServiceURIsProps(String zkserver, String d2path, String serviceName) throws IOException, IllegalStateException, URISyntaxException, PropertyStoreException {
        HashSet<UriProperties> uriprops = new HashSet<UriProperties>();
        String scstoreString = zkserver + ZKFSUtil.servicePath(d2path);
        String uristoreString = zkserver + ZKFSUtil.uriPath(d2path);
        ZooKeeperPermanentStore zkServiceRegistry = (ZooKeeperPermanentStore)LoadBalancerClientCli.getStore(this._zkclient, scstoreString, new ServicePropertiesJsonSerializer());
        ZooKeeperEphemeralStore zkUriRegistry = (ZooKeeperEphemeralStore)LoadBalancerClientCli.getEphemeralStore(this._zkclient, uristoreString, new UriPropertiesJsonSerializer(), new UriPropertiesMerger());
        String clusterName = ((ServiceProperties)zkServiceRegistry.get(serviceName)).getClusterName();
        UriProperties uripros = (UriProperties)zkUriRegistry.get(clusterName);
        uriprops.add(uripros);
        return uriprops;
    }

    public Map<String, UriProperties> getServiceClustersURIsInfo(String zkserver, String d2path, String serviceName) throws IOException, IllegalStateException, URISyntaxException, PropertyStoreException {
        HashMap<String, UriProperties> map = new HashMap<String, UriProperties>();
        String scstoreString = zkserver + ZKFSUtil.servicePath(d2path);
        String uristoreString = zkserver + ZKFSUtil.uriPath(d2path);
        ZooKeeperPermanentStore zkServiceRegistry = (ZooKeeperPermanentStore)LoadBalancerClientCli.getStore(this._zkclient, scstoreString, new ServicePropertiesJsonSerializer());
        ZooKeeperEphemeralStore zkUriRegistry = (ZooKeeperEphemeralStore)LoadBalancerClientCli.getEphemeralStore(this._zkclient, uristoreString, new UriPropertiesJsonSerializer(), new UriPropertiesMerger());
        List<String> currentservices = zkServiceRegistry.ls();
        for (String service : currentservices) {
            if (!service.equals(serviceName)) continue;
            String clusterName = ((ServiceProperties)zkServiceRegistry.get(serviceName)).getClusterName();
            UriProperties uripros = (UriProperties)zkUriRegistry.get(clusterName);
            map.put(clusterName, uripros);
        }
        return map;
    }

    public static boolean hasService(ZKConnection zkclient, String zkserver, String d2path, String cluster, String service) throws URISyntaxException, IOException, PropertyStoreException {
        ZooKeeperPermanentStore zkServiceRegistry = null;
        String scstoreString = zkserver + ZKFSUtil.servicePath(d2path);
        zkServiceRegistry = (ZooKeeperPermanentStore)LoadBalancerClientCli.getStore(zkclient, scstoreString, new ServicePropertiesJsonSerializer());
        return ((ServiceProperties)zkServiceRegistry.get(service)).getClusterName().equals(cluster);
    }

    public static String printStore(ZKConnection zkclient, String zkserver, String d2path, String cluster, String service) throws URISyntaxException, IOException, PropertyStoreException {
        return LoadBalancerClientCli.printStore(zkclient, zkserver, d2path, cluster, service, null);
    }

    public static String printStore(ZKConnection zkclient, String zkserver, String d2path, String cluster, String service, String serviceGroup) throws URISyntaxException, IOException, PropertyStoreException {
        StringBuilder sb = new StringBuilder();
        ZooKeeperPermanentStore zkClusterRegistry = null;
        ZooKeeperPermanentStore zkServiceRegistry = null;
        ZooKeeperEphemeralStore zkUriRegistry = null;
        String clstoreString = zkserver + ZKFSUtil.clusterPath(d2path);
        String uristoreString = zkserver + ZKFSUtil.uriPath(d2path);
        zkClusterRegistry = (ZooKeeperPermanentStore)LoadBalancerClientCli.getStore(zkclient, clstoreString, new ClusterPropertiesJsonSerializer());
        zkUriRegistry = (ZooKeeperEphemeralStore)LoadBalancerClientCli.getEphemeralStore(zkclient, uristoreString, new UriPropertiesJsonSerializer(), new UriPropertiesMerger());
        if (serviceGroup != null) {
            String scstoreString = zkserver + ZKFSUtil.servicePath(d2path, serviceGroup);
            zkServiceRegistry = (ZooKeeperPermanentStore)LoadBalancerClientCli.getStore(zkclient, scstoreString, new ServicePropertiesJsonSerializer());
        } else {
            String scstoreString = zkserver + ZKFSUtil.servicePath(d2path);
            zkServiceRegistry = (ZooKeeperPermanentStore)LoadBalancerClientCli.getStore(zkclient, scstoreString, new ServicePropertiesJsonSerializer());
        }
        sb.append(LoadBalancerClientCli.printStore(zkClusterRegistry, zkUriRegistry, cluster));
        if (((ServiceProperties)zkServiceRegistry.get(service)).getClusterName().equals(cluster)) {
            sb.append(LoadBalancerClientCli.printService(zkServiceRegistry, service));
        }
        return sb.toString();
    }

    private static <T> String printService(PropertyStore<T> zkServiceRegistry, String service) throws URISyntaxException, PropertyStoreException {
        String serviceInfo = "Service '" + service + "':" + zkServiceRegistry.get(service).toString();
        System.out.println(serviceInfo);
        return serviceInfo;
    }

    private static <T> String printStore(PropertyStore<T> zkClusterRegistry, ZooKeeperEphemeralStore<UriProperties> zkUriRegistry, String cluster) throws URISyntaxException, PropertyStoreException {
        StringBuilder sb = new StringBuilder();
        sb.append("\nCluster '");
        sb.append(cluster);
        sb.append("':");
        sb.append(zkClusterRegistry.get(cluster).toString());
        sb.append("\nCluster '");
        sb.append(cluster);
        sb.append("' UriProperties:");
        sb.append(zkUriRegistry.get(cluster));
        return sb.toString();
    }

    public static String printStore(ZooKeeperPermanentStore<ClusterProperties> zkClusterRegistry, ZooKeeperEphemeralStore<UriProperties> zkUriRegistry, ZooKeeperPermanentStore<ServiceProperties> zkServiceRegistry, String cluster, String service) throws URISyntaxException, PropertyStoreException {
        StringBuilder sb = new StringBuilder();
        sb.append(LoadBalancerClientCli.printStore(zkClusterRegistry, zkUriRegistry, cluster));
        if (((ServiceProperties)zkServiceRegistry.get(service)).getClusterName().equals(cluster)) {
            sb.append(LoadBalancerClientCli.printService(zkServiceRegistry, service));
        }
        return sb.toString();
    }

    public static String printStores(ZKConnection zkclient, String zkserver, String d2path) throws IOException, IllegalStateException, URISyntaxException, PropertyStoreException, Exception {
        int serviceCount = 0;
        String zkstr = "\nZKServer:" + zkserver;
        StringBuilder sb = new StringBuilder();
        HashSet<String> currentservices = new HashSet<String>();
        HashMap<String, ZooKeeperPermanentStore> zkServiceRegistryMap = new HashMap<String, ZooKeeperPermanentStore>();
        HashMap<String, List<String>> servicesGroupMap = new HashMap<String, List<String>>();
        String clstoreString = zkserver + ZKFSUtil.clusterPath(d2path);
        String uristoreString = zkserver + ZKFSUtil.uriPath(d2path);
        ZooKeeperPermanentStore zkClusterRegistry = (ZooKeeperPermanentStore)LoadBalancerClientCli.getStore(zkclient, clstoreString, new ClusterPropertiesJsonSerializer());
        ZooKeeperEphemeralStore zkUriRegistry = (ZooKeeperEphemeralStore)LoadBalancerClientCli.getEphemeralStore(zkclient, uristoreString, new UriPropertiesJsonSerializer(), new UriPropertiesMerger());
        List<String> currentclusters = zkClusterRegistry.ls();
        List<String> currenturis = zkUriRegistry.ls();
        List<String> servicesGroups = LoadBalancerClientCli.getServicesGroups(zkclient, d2path);
        for (String serviceGroup : servicesGroups) {
            String scstoreString = zkserver + ZKFSUtil.servicePath(d2path, serviceGroup);
            ZooKeeperPermanentStore zkServiceRegistry = (ZooKeeperPermanentStore)LoadBalancerClientCli.getStore(zkclient, scstoreString, new ServicePropertiesJsonSerializer());
            zkServiceRegistryMap.put(serviceGroup, zkServiceRegistry);
            List<String> services = zkServiceRegistry.ls();
            currentservices.addAll(services);
            servicesGroupMap.put(serviceGroup, services);
            serviceCount += services.size();
        }
        sb.append(zkstr);
        sb.append(" Total Clusters:");
        sb.append(currentclusters.size());
        sb.append(zkstr);
        sb.append(" Total Services:");
        sb.append(serviceCount);
        sb.append(zkstr);
        sb.append(" Total URIs:");
        sb.append(currenturis.size());
        sb.append("\n============================================================");
        sb.append("\nSERVICE GROUPS");
        for (String serviceGroup : servicesGroupMap.keySet()) {
            sb.append("\nGROUP:" + serviceGroup + "           Services:" + servicesGroupMap.get(serviceGroup));
        }
        for (String cluster : currentclusters) {
            int count = 0;
            sb.append("\n============================================================");
            sb.append("\nCLUSTER '");
            sb.append(cluster);
            sb.append("':");
            block3: for (String service : currentservices) {
                for (String serviceGroup : servicesGroupMap.keySet()) {
                    ServiceProperties serviceProps;
                    ZooKeeperPermanentStore zkStorePropsForSerivceGroup = (ZooKeeperPermanentStore)zkServiceRegistryMap.get(serviceGroup);
                    if (zkStorePropsForSerivceGroup == null || (serviceProps = (ServiceProperties)zkStorePropsForSerivceGroup.get(service)) == null || !cluster.equals(serviceProps.getClusterName())) continue;
                    sb.append("\n-------------------");
                    sb.append("\nSERVICE '" + service + "':");
                    sb.append(LoadBalancerClientCli.printStore(zkClusterRegistry, zkUriRegistry, (ZooKeeperPermanentStore)zkServiceRegistryMap.get(serviceGroup), cluster, service));
                    ++count;
                    continue block3;
                }
            }
            if (count != 0) continue;
            sb.append(LoadBalancerClientCli.printStore(zkClusterRegistry, zkUriRegistry, cluster));
            sb.append("\nNo services were found in this cluster.");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetTogglingStores(String host, boolean enabled) throws Exception {
        MonitoredHost _host = MonitoredHost.getMonitoredHost(new HostIdentifier(host));
        for (Integer pidObj : _host.activeVms()) {
            int pid = pidObj;
            System.out.println("checking pid: " + pid);
            JMXServiceURL jmxUrl = null;
            VirtualMachine vm = VirtualMachine.attach(pid + "");
            try {
                String connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
                if (connectorAddress != null) {
                    jmxUrl = new JMXServiceURL(connectorAddress);
                }
            }
            finally {
                vm.detach();
            }
            if (jmxUrl != null) {
                System.out.println("got jmx url: " + jmxUrl);
                JMXConnector connector = JMXConnectorFactory.connect(jmxUrl);
                connector.connect();
                MBeanServerConnection mbeanServer = connector.getMBeanServerConnection();
                Set<ObjectInstance> objectInstances = mbeanServer.queryMBeans(new ObjectName("com.linkedin.d2:*"), null);
                for (ObjectInstance objectInstance : objectInstances) {
                    System.err.println("checking object: " + objectInstance.getObjectName());
                    if (!objectInstance.getObjectName().toString().endsWith("TogglingStore")) continue;
                    System.out.println("found toggling zk store, so toggling to: " + enabled);
                    mbeanServer.invoke(objectInstance.getObjectName(), "setEnabled", new Object[]{enabled}, new String[]{"boolean"});
                }
                continue;
            }
            System.out.println("pid is not a jmx process: " + pid);
        }
    }

    private void deleteTempDir() throws IOException {
        if (this._tmpDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)this._tmpDir);
            }
            catch (IOException e) {
                throw new IOException("Could not delete temp file: " + this._tmpDir.getAbsolutePath());
            }
        }
    }

    private static File createTempDirectory(String name) throws IOException {
        File temp = new File(System.getProperty("java.io.tmpdir") + File.separator + name);
        if (temp.exists() && temp.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)temp);
            }
            catch (IOException e) {
                throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
            }
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public void shutdown() throws Exception {
        if (this._zkClusterRegistry != null) {
            try {
                this.shutdownZKRegistry(this._zkClusterRegistry);
            }
            catch (Exception e) {
                _log.error("Failed to shutdown ZooKeeperPermanentStore<ClusterProperties> zkClusterRegistry.");
            }
        }
        if (this._zkServiceRegistry != null) {
            try {
                this.shutdownZKRegistry(this._zkServiceRegistry);
            }
            catch (Exception e) {
                _log.error("Failed to shutdown ZooKeeperPermanentStore<ServiceProperties> zkServiceRegistry.");
            }
        }
        if (this._zkUriRegistry != null) {
            try {
                this.shutdownZKRegistry(this._zkUriRegistry);
            }
            catch (Exception e) {
                _log.error("Failed to shutdown ZooKeeperEphemeralStore<UriProperties> zkUriRegistry.");
            }
        }
        try {
            if (this._client != null) {
                LoadBalancerUtil.syncShutdownClient(this._client, _log);
            }
        }
        catch (Exception e) {
            _log.error("Failed to shutdown dynamic client.");
        }
        if (this._zkfsLoadBalancer != null) {
            try {
                final CountDownLatch latch = new CountDownLatch(1);
                this._zkfsLoadBalancer.shutdown(new PropertyEventThread.PropertyEventShutdownCallback(){

                    @Override
                    public void done() {
                        latch.countDown();
                    }
                });
                if (!latch.await(5L, TimeUnit.SECONDS)) {
                    _log.error("unable to shut down store");
                }
            }
            catch (Exception e) {
                _log.error("Failed to shutdown zkfsLoadBalancer.");
            }
        }
        try {
            this.deleteTempDir();
        }
        catch (Exception e) {
            _log.error("Failed to delete directory " + this._tmpDir);
        }
        try {
            this._zkclient.shutdown();
        }
        catch (Exception e) {
            _log.error("Failed to shutdown zk client.");
        }
    }

    private void shutdownZKRegistry(ZooKeeperStore<?> zkregistry) throws Exception {
        if (zkregistry != null) {
            FutureCallback shutdownCallback = new FutureCallback();
            zkregistry.shutdown((Callback<None>)shutdownCallback);
            shutdownCallback.get(5000L, TimeUnit.MILLISECONDS);
        }
    }

    private void shutdownPropertyStore(PropertyStore<?> store, long timeout, TimeUnit unit) throws Exception {
        FutureCallback callback = new FutureCallback();
        store.shutdown((Callback<None>)callback);
        try {
            callback.get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            System.err.println("unable to shutdown store: " + store);
        }
    }
}

