/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.common.util.None;
import com.linkedin.d2.DarkClusterConfigMap;
import com.linkedin.d2.balancer.LoadBalancer;
import com.linkedin.d2.balancer.LoadBalancerClusterListener;
import com.linkedin.d2.balancer.ServiceUnavailableException;
import com.linkedin.d2.balancer.WarmUpService;
import com.linkedin.d2.balancer.clusterfailout.FailoutConfig;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancer;
import com.linkedin.d2.balancer.util.ClientFactoryProvider;
import com.linkedin.d2.balancer.util.ClusterInfoProvider;
import com.linkedin.d2.balancer.util.HostToKeyMapper;
import com.linkedin.d2.balancer.util.MapKeyResult;
import com.linkedin.d2.balancer.util.hashing.HashFunction;
import com.linkedin.d2.balancer.util.hashing.HashRingProvider;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.PartitionInfoProvider;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.d2.discovery.stores.toggling.TogglingPublisher;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import java.net.URI;
import java.util.Collection;
import java.util.Map;

public class TogglingLoadBalancer
implements LoadBalancer,
HashRingProvider,
ClientFactoryProvider,
PartitionInfoProvider,
WarmUpService,
ClusterInfoProvider {
    private final LoadBalancer _balancer;
    private final WarmUpService _warmUpService;
    private final HashRingProvider _hashRingProvider;
    private final PartitionInfoProvider _partitionInfoProvider;
    private final ClientFactoryProvider _clientFactoryProvider;
    private final TogglingPublisher<?>[] _toggles;
    private final ClusterInfoProvider _clusterInfoProvider;

    public TogglingLoadBalancer(SimpleLoadBalancer balancer, TogglingPublisher<?> ... toggles) {
        this._balancer = balancer;
        this._warmUpService = balancer;
        this._hashRingProvider = balancer;
        this._partitionInfoProvider = balancer;
        this._clientFactoryProvider = balancer;
        this._toggles = toggles;
        this._clusterInfoProvider = balancer;
    }

    public TogglingLoadBalancer(LoadBalancer balancer, TogglingPublisher<?> ... toggles) {
        this((SimpleLoadBalancer)balancer, toggles);
    }

    public void enablePrimary(Callback<None> callback) {
        Callback multiCallback = Callbacks.countDown(callback, (int)this._toggles.length);
        for (TogglingPublisher<?> toggle : this._toggles) {
            toggle.enablePrimary((Callback<None>)multiCallback);
        }
    }

    public void enableBackup(Callback<None> callback) {
        Callback multiCallback = Callbacks.countDown(callback, (int)this._toggles.length);
        for (TogglingPublisher<?> toggle : this._toggles) {
            toggle.enableBackup((Callback<None>)multiCallback);
        }
    }

    @Override
    public void start(Callback<None> callback) {
        this._balancer.start(callback);
    }

    @Override
    public void shutdown(PropertyEventThread.PropertyEventShutdownCallback shutdown) {
        this._balancer.shutdown(shutdown);
    }

    @Override
    public void getLoadBalancedServiceProperties(String serviceName, Callback<ServiceProperties> clientCallback) {
        this._balancer.getLoadBalancedServiceProperties(serviceName, clientCallback);
    }

    @Override
    public void getClient(Request request, RequestContext requestContext, Callback<TransportClient> clientCallback) {
        this._balancer.getClient(request, requestContext, clientCallback);
    }

    @Override
    public <K> MapKeyResult<Ring<URI>, K> getRings(URI serviceUri, Iterable<K> keys) throws ServiceUnavailableException {
        this.checkLoadBalancer();
        return this._hashRingProvider.getRings(serviceUri, keys);
    }

    @Override
    public Map<Integer, Ring<URI>> getRings(URI serviceUri) throws ServiceUnavailableException {
        this.checkLoadBalancer();
        return this._hashRingProvider.getRings(serviceUri);
    }

    @Override
    public HashFunction<Request> getRequestHashFunction(String serviceName) throws ServiceUnavailableException {
        this.checkLoadBalancer();
        return this._hashRingProvider.getRequestHashFunction(serviceName);
    }

    @Override
    public <K> HostToKeyMapper<K> getPartitionInformation(URI serviceUri, Collection<K> keys, int limitHostPerPartition, int hash) throws ServiceUnavailableException {
        this.checkPartitionInfoProvider();
        return this._partitionInfoProvider.getPartitionInformation(serviceUri, keys, limitHostPerPartition, hash);
    }

    @Override
    public PartitionAccessor getPartitionAccessor(String serviceName) throws ServiceUnavailableException {
        this.checkPartitionInfoProvider();
        return this._partitionInfoProvider.getPartitionAccessor(serviceName);
    }

    private void checkLoadBalancer() {
        if (this._hashRingProvider == null) {
            throw new IllegalStateException("No HashRingProvider available to TogglingLoadBalancer - this could be because the load balancer is not yet initialized, or because it has been configured with strategies that do not support consistent hashing.");
        }
    }

    private void checkPartitionInfoProvider() {
        if (this._partitionInfoProvider == null) {
            throw new IllegalStateException("No PartitionInfoProvider available to TogglingLoadBalancer - this could be because the load balancer is not yet initialized, or because it has been configured with strategies that do not support consistent hashing.");
        }
    }

    @Override
    public TransportClientFactory getClientFactory(String scheme) {
        if (this._clientFactoryProvider == null) {
            throw new IllegalStateException("No ClientFactoryProvider available to TogglingLoadBalancer - this could be because the load balancer is not yet initialized, or because it has beenconfigured with a LoadBalancer which does notsupport obtaining client factories");
        }
        return this._clientFactoryProvider.getClientFactory(scheme);
    }

    @Override
    public void warmUpService(String serviceName, Callback<None> callback) {
        this._warmUpService.warmUpService(serviceName, callback);
    }

    @Override
    public int getClusterCount(String clusterName, String scheme, int partitionId) throws ServiceUnavailableException {
        return this._clusterInfoProvider.getClusterCount(clusterName, scheme, partitionId);
    }

    @Override
    public DarkClusterConfigMap getDarkClusterConfigMap(String clusterName) throws ServiceUnavailableException {
        return this._clusterInfoProvider.getDarkClusterConfigMap(clusterName);
    }

    @Override
    public void getDarkClusterConfigMap(String clusterName, Callback<DarkClusterConfigMap> callback) {
        this._clusterInfoProvider.getDarkClusterConfigMap(clusterName, callback);
    }

    @Override
    public FailoutConfig getFailoutConfig(String clusterName) {
        return this._clusterInfoProvider.getFailoutConfig(clusterName);
    }

    @Override
    public void registerClusterListener(LoadBalancerClusterListener clusterListener) {
        this._clusterInfoProvider.registerClusterListener(clusterListener);
    }

    @Override
    public void unregisterClusterListener(LoadBalancerClusterListener clusterListener) {
        this._clusterInfoProvider.unregisterClusterListener(clusterListener);
    }
}

