/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util;

import com.linkedin.util.ArgumentUtil;
import java.net.URI;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class URIKeyPair<KEY> {
    private final KEY _key;
    private final URI _requestUri;
    private final Set<Integer> _overriddenPartitionIds;

    public URIKeyPair(KEY key, URI uri) {
        ArgumentUtil.notNull(key, (String)"key");
        ArgumentUtil.notNull((Object)uri, (String)"uri");
        assert (uri.getScheme().equals("d2"));
        this._key = key;
        this._requestUri = uri;
        this._overriddenPartitionIds = Collections.emptySet();
    }

    public URIKeyPair(URI uri, Set<Integer> overriddenPartitionIds) {
        ArgumentUtil.notNull(overriddenPartitionIds, (String)"overridden partition ids");
        ArgumentUtil.notNull((Object)uri, (String)"uri");
        this._key = null;
        this._requestUri = uri;
        this._overriddenPartitionIds = Collections.unmodifiableSet(overriddenPartitionIds);
    }

    public KEY getKey() {
        return this._key;
    }

    public URI getRequestUri() {
        return this._requestUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URIKeyPair that = (URIKeyPair)o;
        return Objects.equals(this._key, that._key) && Objects.equals(this._requestUri, that._requestUri) && Objects.equals(this._overriddenPartitionIds, that._overriddenPartitionIds);
    }

    public int hashCode() {
        return Objects.hash(this._key, this._requestUri, this._overriddenPartitionIds);
    }

    public boolean hasOverriddenPartitionIds() {
        return !this._overriddenPartitionIds.isEmpty();
    }

    public Set<Integer> getOverriddenPartitionIds() {
        return this._overriddenPartitionIds;
    }
}

