/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class URIMappingResult<KEY> {
    private final Map<URI, Set<KEY>> _mappedKeys;
    private final Map<Integer, Set<KEY>> _unmappedKeys;
    private final Map<URI, Integer> _hostToPartitionId;

    public URIMappingResult(Map<URI, Set<KEY>> mappingResults, Map<Integer, Set<KEY>> unmappedKeys, Map<URI, Integer> hostToPartitionId) {
        this._mappedKeys = Collections.unmodifiableMap(mappingResults);
        this._unmappedKeys = Collections.unmodifiableMap(unmappedKeys);
        this._hostToPartitionId = Collections.unmodifiableMap(hostToPartitionId);
    }

    public Map<URI, Set<KEY>> getMappedKeys() {
        return this._mappedKeys;
    }

    public Map<Integer, Set<KEY>> getUnmappedKeys() {
        return this._unmappedKeys;
    }

    public Map<URI, Integer> getHostPartitionInfo() {
        return this._hostToPartitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URIMappingResult that = (URIMappingResult)o;
        return Objects.equals(this._mappedKeys, that._mappedKeys) && Objects.equals(this._unmappedKeys, that._unmappedKeys);
    }

    public int hashCode() {
        return Objects.hash(this._mappedKeys, this._unmappedKeys);
    }
}

