/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.canary;

import com.linkedin.d2.D2CanaryDistributionStrategy;
import com.linkedin.d2.PercentageStrategyProperties;
import com.linkedin.d2.TargetApplicationsStrategyProperties;
import com.linkedin.d2.TargetHostsStrategyProperties;
import com.linkedin.d2.balancer.util.canary.CanaryDistributionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCanaryDistributionProviderImpl
implements CanaryDistributionProvider {
    private static final Logger _log = LoggerFactory.getLogger(BasicCanaryDistributionProviderImpl.class);
    private final String _serviceName;
    private final String _hostName;

    public BasicCanaryDistributionProviderImpl(String serviceName, String hostName) {
        this._serviceName = serviceName;
        this._hostName = hostName;
    }

    @Override
    public CanaryDistributionProvider.Distribution distribute(D2CanaryDistributionStrategy strategy) {
        switch (strategy.getStrategy()) {
            case TARGET_HOSTS: {
                return this.distributeByTargetHosts(strategy);
            }
            case TARGET_APPLICATIONS: {
                return this.distributeByTargetApplications(strategy);
            }
            case PERCENTAGE: {
                return this.distributeByPercentage(strategy);
            }
            case DISABLED: {
                return CanaryDistributionProvider.Distribution.STABLE;
            }
        }
        _log.warn("Invalid distribution strategy type: " + strategy.getStrategy().name());
        return CanaryDistributionProvider.Distribution.STABLE;
    }

    protected CanaryDistributionProvider.Distribution distributeByTargetHosts(D2CanaryDistributionStrategy strategy) {
        TargetHostsStrategyProperties targetHostsProperties = strategy.getTargetHostsStrategyProperties();
        if (targetHostsProperties == null) {
            _log.warn("Empty target hosts properties in distribution strategy type.");
            return CanaryDistributionProvider.Distribution.STABLE;
        }
        return targetHostsProperties.getTargetHosts().stream().anyMatch(this::isHostMatch) ? CanaryDistributionProvider.Distribution.CANARY : CanaryDistributionProvider.Distribution.STABLE;
    }

    protected CanaryDistributionProvider.Distribution distributeByTargetApplications(D2CanaryDistributionStrategy strategy) {
        TargetApplicationsStrategyProperties targetAppsProperties = strategy.getTargetApplicationsStrategyProperties();
        if (targetAppsProperties == null) {
            _log.warn("Empty target applications properties in distribution strategy type.");
            return CanaryDistributionProvider.Distribution.STABLE;
        }
        return targetAppsProperties.getTargetApplications().stream().anyMatch(this::isServiceMatch) && this.isCanaryByRampScope(targetAppsProperties.getScope()) ? CanaryDistributionProvider.Distribution.CANARY : CanaryDistributionProvider.Distribution.STABLE;
    }

    protected CanaryDistributionProvider.Distribution distributeByPercentage(D2CanaryDistributionStrategy strategy) {
        PercentageStrategyProperties percentageProperties = strategy.getPercentageStrategyProperties();
        if (percentageProperties == null) {
            _log.warn("Empty percentage properties in distribution strategy type.");
            return CanaryDistributionProvider.Distribution.STABLE;
        }
        return this.isCanaryByRampScope(percentageProperties.getScope()) ? CanaryDistributionProvider.Distribution.CANARY : CanaryDistributionProvider.Distribution.STABLE;
    }

    protected String getServiceName() {
        return this._serviceName == null ? "" : this._serviceName;
    }

    protected String getHostName() {
        return this._hostName == null ? "" : this._hostName;
    }

    protected String getHashKey() {
        return this.getServiceName() + this.getHostName();
    }

    public int getHashResult() {
        return Math.abs(this.getHashKey().hashCode());
    }

    protected boolean isServiceMatch(String target) {
        return this.getServiceName().equals(target);
    }

    protected boolean isHostMatch(String target) {
        return this.getHostName().equals(target);
    }

    protected boolean isCanaryByRampScope(Double scope) {
        return scope > 0.0 && this.getHashResult() % 100 <= (int)(scope * 100.0);
    }
}

