/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing;

import com.linkedin.d2.balancer.strategies.RingFactory;
import com.linkedin.d2.balancer.util.hashing.ConsistentHashRing;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.util.degrader.CallTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedLoadConsistentHashRing<T>
implements Ring<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ConsistentHashRing.class);
    private final Map<T, Integer> _pointsMap;
    private final Map<T, CallTracker> _callTrackerMap;
    private final int _totalPoints;
    private final Map<T, Integer> _hosts;
    private final double _boundedLoadBalancingFactor;
    private final Ring<T> _ring;
    private final Lock _lock;
    private volatile LoadDistribution<T> _loadDistribution;

    public BoundedLoadConsistentHashRing(RingFactory<T> ringFactory, Map<T, Integer> pointsMap, Map<T, CallTracker> callTrackerMap, double boundedLoadBalancingFactor) {
        this._pointsMap = pointsMap;
        this._callTrackerMap = callTrackerMap;
        this._hosts = new HashMap<T, Integer>();
        this._boundedLoadBalancingFactor = boundedLoadBalancingFactor;
        this._ring = ringFactory.createRing(pointsMap);
        this._lock = new ReentrantLock();
        this._totalPoints = this.initHostCumulativePoints(pointsMap);
    }

    private int initHostCumulativePoints(Map<T, Integer> pointsMap) {
        HashMap<T, Integer> loadMap = new HashMap<T, Integer>();
        int cumulative = 0;
        for (Map.Entry<T, Integer> entry : this._pointsMap.entrySet()) {
            if (pointsMap.get(entry.getKey()) <= 0) continue;
            loadMap.put(entry.getKey(), 0);
            this._hosts.put(entry.getKey(), cumulative += this._pointsMap.get(entry.getKey()).intValue());
        }
        this._loadDistribution = new LoadDistribution(loadMap, 0);
        return cumulative;
    }

    int getCapacity(T host) {
        int cumulativePoints = this._hosts.get(host);
        int totalCapacity = this._loadDistribution.getTotalCapacity();
        int capacityPerPoint = totalCapacity / this._totalPoints;
        int remainder = totalCapacity % this._totalPoints;
        int capacity = this._pointsMap.get(host) * capacityPerPoint;
        return Integer.max(1, capacity += (cumulativePoints + this._pointsMap.get(host)) * remainder / this._totalPoints - cumulativePoints * remainder / this._totalPoints);
    }

    private List<T> getOrderByKey(int key, T mostWantedHost) {
        ArrayList<T> hosts = new ArrayList<T>(this._hosts.keySet());
        Collections.shuffle(hosts, new Random(key));
        if (!hosts.isEmpty()) {
            Collections.swap(hosts, 0, hosts.indexOf(mostWantedHost));
        }
        return hosts;
    }

    @Override
    @Nullable
    public T get(int key) {
        if (this._ring.isEmpty()) {
            LOG.debug("get called on a hash ring with nothing in it");
            return null;
        }
        T mostWantedHost = this._ring.get(key);
        this.updateLoad();
        if (this._loadDistribution.getLoad(mostWantedHost) < this.getCapacity(mostWantedHost)) {
            return mostWantedHost;
        }
        for (T host : this.getOrderByKey(key, mostWantedHost)) {
            if (this._loadDistribution.getLoad(host) >= this.getCapacity(host)) continue;
            return host;
        }
        return mostWantedHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLoad() {
        if (this._lock.tryLock()) {
            try {
                HashMap<T, Integer> newLoadMap = new HashMap<T, Integer>();
                int loadSum = 0;
                for (Map.Entry<T, CallTracker> entry : this._callTrackerMap.entrySet()) {
                    int load = entry.getValue().getCurrentConcurrency();
                    loadSum += load;
                    newLoadMap.put(entry.getKey(), load);
                }
                int totalCapacity = (int)Math.ceil((double)(loadSum + 1) * this._boundedLoadBalancingFactor);
                this._loadDistribution = new LoadDistribution(newLoadMap, totalCapacity);
            }
            finally {
                this._lock.unlock();
            }
        }
    }

    @Override
    @Nonnull
    public Iterator<T> getIterator(int key) {
        this.updateLoad();
        return this.getOrderByKey(key, this.get(key)).listIterator();
    }

    @Override
    public boolean isStickyRoutingCapable() {
        return this._ring.isStickyRoutingCapable();
    }

    @Override
    public boolean isEmpty() {
        return this._ring.isEmpty();
    }

    private static class LoadDistribution<T> {
        private final Map<T, Integer> _loadMap;
        private final int _totalCapacity;

        LoadDistribution(Map<T, Integer> loadMap, int totalCapacity) {
            this._loadMap = loadMap;
            this._totalCapacity = totalCapacity;
        }

        int getTotalCapacity() {
            return this._totalCapacity;
        }

        int getLoad(T host) {
            return this._loadMap.getOrDefault(host, 0);
        }
    }
}

