/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing;

import com.linkedin.d2.balancer.util.hashing.Ring;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributionNonDiscreteRing<T>
implements Ring<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DistributionNonDiscreteRing.class);
    private final TreeMap<Integer, T> _cumulativePointsMap;
    private final int _totalPoints;

    public DistributionNonDiscreteRing(Map<T, Integer> pointsMap) {
        this._cumulativePointsMap = this.calculateCDF(pointsMap);
        this._totalPoints = this._cumulativePointsMap.isEmpty() ? 0 : this._cumulativePointsMap.lastKey();
    }

    @Override
    public T get(int unused) {
        if (this._cumulativePointsMap.isEmpty()) {
            LOG.warn("Calling get on an empty ring, null value will be returned");
            return null;
        }
        int rand = ThreadLocalRandom.current().nextInt(this._totalPoints);
        return this._cumulativePointsMap.higherEntry(rand).getValue();
    }

    @Override
    @Nonnull
    public Iterator<T> getIterator(int unused) {
        ArrayList<T> hosts = new ArrayList<T>(this._cumulativePointsMap.values());
        if (!hosts.isEmpty()) {
            Collections.shuffle(hosts);
            try {
                Collections.swap(hosts, 0, hosts.indexOf(this.get(0)));
            }
            catch (IndexOutOfBoundsException e) {
                LOG.warn("Got indexOutOfBound when trying to shuffle list:" + e.getMessage());
            }
        }
        return hosts.iterator();
    }

    @Override
    public boolean isStickyRoutingCapable() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this._cumulativePointsMap.isEmpty();
    }

    private TreeMap<Integer, T> calculateCDF(Map<T, Integer> pointsMap) {
        int cumulativeSum = 0;
        TreeMap<Integer, T> cumulativePointsMap = new TreeMap<Integer, T>();
        for (Map.Entry<T, Integer> entry : pointsMap.entrySet()) {
            if (entry.getValue() == 0) continue;
            cumulativePointsMap.put(cumulativeSum += entry.getValue().intValue(), entry.getKey());
        }
        return cumulativePointsMap;
    }
}

