/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing;

import com.linkedin.d2.balancer.util.hashing.ConsistentHashRing;
import com.linkedin.d2.balancer.util.hashing.Ring;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.openhft.hashing.LongHashFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPConsistentHashRing<T>
implements Ring<T> {
    public static final int DEFAULT_NUM_PROBES = 21;
    public static final int DEFAULT_POINTS_PER_HOST = 1;
    private static final Logger LOG = LoggerFactory.getLogger(ConsistentHashRing.class);
    private static final LongHashFunction HASH_FUNCTION_0 = LongHashFunction.xx_r39((long)-559038737L);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final long MASK = 0xFFFFFFFFL;
    private final List<Bucket> _buckets;
    private final List<T> _hosts;
    private final LongHashFunction[] _hashFunctions;
    private final int _numProbes;

    public MPConsistentHashRing(Map<T, Integer> pointsMap) {
        this(pointsMap, 21, 1);
    }

    public MPConsistentHashRing(Map<T, Integer> pointsMap, int numProbes, int pointsPerHost) {
        this._buckets = new ArrayList<Bucket>(pointsMap.size());
        this._hosts = new ArrayList<T>(pointsMap.size());
        for (Map.Entry<T, Integer> entry : pointsMap.entrySet()) {
            if (entry.getValue() <= 0) continue;
            byte[] bytesToHash = entry.getKey().toString().getBytes(UTF8);
            long hash = HASH_FUNCTION_0.hashBytes(bytesToHash) & 0xFFFFFFFFL;
            this._buckets.add(new Bucket(entry.getKey(), hash, entry.getValue()));
            this._hosts.add(entry.getKey());
            long hashOfHash = hash;
            int duplicate = pointsPerHost - 1;
            while (duplicate-- > 0) {
                hashOfHash = HASH_FUNCTION_0.hashLong(hashOfHash) & 0xFFFFFFFFL;
                this._buckets.add(new Bucket(entry.getKey(), hashOfHash, entry.getValue()));
            }
        }
        this._numProbes = numProbes;
        this._hashFunctions = new LongHashFunction[this._numProbes];
        for (int i = 0; i < this._numProbes; ++i) {
            this._hashFunctions[i] = LongHashFunction.xx_r39((long)i);
        }
    }

    @Override
    public T get(int key) {
        if (this._buckets.isEmpty()) {
            LOG.debug("get called on a hash ring with nothing in it");
            return null;
        }
        int index = this.getIndex(key);
        return this._buckets.get(index).getT();
    }

    @Override
    @Nonnull
    public Iterator<T> getIterator(int key) {
        return new QuasiMPConsistentHashRingIterator(key, this._hosts);
    }

    public Iterator<T> getOrderedIterator(final int key) {
        return new Iterator<T>(){
            private final Set<T> _iterated = new HashSet();

            @Override
            public boolean hasNext() {
                return this._iterated.size() < MPConsistentHashRing.this._hosts.size();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int index = MPConsistentHashRing.this.getIndex(key, this._iterated);
                Object item = ((Bucket)MPConsistentHashRing.this._buckets.get(index)).getT();
                this._iterated.add(item);
                return item;
            }
        };
    }

    private int getIndex(int key) {
        return this.getIndex(key, Collections.emptySet());
    }

    private int getIndex(int key, Set<T> excludes) {
        float minDistance = Float.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < this._numProbes; ++i) {
            long hash = this._hashFunctions[i].hashInt(key) & 0xFFFFFFFFL;
            for (int j = 0; j < this._buckets.size(); ++j) {
                float distance;
                Bucket bucket = this._buckets.get(j);
                if (excludes.contains(bucket.getT()) || !((distance = (float)Math.abs(bucket.getHash() - hash) / (float)bucket.getPoints()) < minDistance)) continue;
                minDistance = distance;
                index = j;
            }
        }
        return index;
    }

    public String toString() {
        return "MPConsistentHashRing [" + this._buckets + "]";
    }

    @Override
    public boolean isStickyRoutingCapable() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this._hosts.isEmpty();
    }

    private class QuasiMPConsistentHashRingIterator
    implements Iterator<T> {
        private final List<T> _rankedList;
        private final Iterator<T> _rankedListIter;

        public QuasiMPConsistentHashRingIterator(int startKey, List<T> hosts) {
            this._rankedList = new LinkedList(hosts);
            Collections.shuffle(this._rankedList, new Random(startKey));
            if (!hosts.isEmpty()) {
                Object mostWantedHost = MPConsistentHashRing.this.get(startKey);
                this._rankedList.remove(mostWantedHost);
                this._rankedList.add(0, mostWantedHost);
            }
            this._rankedListIter = this._rankedList.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this._rankedListIter.hasNext();
        }

        @Override
        public T next() {
            return this._rankedListIter.next();
        }
    }

    private class Bucket {
        private final T _t;
        private final long _hash;
        private final int _points;

        public Bucket(T t, long hash, int points) {
            this._t = t;
            this._hash = hash;
            this._points = points;
        }

        public T getT() {
            return this._t;
        }

        public long getHash() {
            return this._hash;
        }

        public int getPoints() {
            return this._points;
        }

        public String toString() {
            return "Bucket [_hash=" + this._hash + ", _t=" + this._t + ", _points=" + this._points + "]";
        }
    }
}

