/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing.simulator;

import com.linkedin.d2.balancer.util.hashing.simulator.ConsistentHashRingSimulator;
import com.linkedin.d2.balancer.util.hashing.simulator.ConsistentHashRingSimulatorConfig;
import java.util.Random;

public class Arrival {
    private final int _minInterval;
    private final int _maxInterval;
    private final double _stddev;
    private final ConsistentHashRingSimulatorConfig.RandomStrategy _randomStrategy;
    private final Random _random = new Random();

    public Arrival(ConsistentHashRingSimulatorConfig.Arrival arrival) {
        this(arrival.getMinInterval(), arrival.getMaxInterval(), arrival.getStddev(), arrival.getRandomStrategy());
    }

    public Arrival(int minInterval, int maxInterval, double stddev, ConsistentHashRingSimulatorConfig.RandomStrategy randomStrategy) {
        this._minInterval = minInterval;
        this._maxInterval = maxInterval;
        this._stddev = stddev;
        this._randomStrategy = randomStrategy;
    }

    public int getNextInterval() {
        switch (this._randomStrategy) {
            case UNIFORM: {
                return this._random.nextInt(this._maxInterval - this._minInterval) + this._minInterval;
            }
            case GAUSSIAN: {
                return ConsistentHashRingSimulator.getNormal(this._minInterval, this._maxInterval, this._stddev);
            }
        }
        throw new IllegalStateException(String.format("Error: cannot recognize random strategy %s", new Object[]{this._randomStrategy}));
    }
}

