/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing.simulator;

import com.linkedin.d2.balancer.util.hashing.simulator.Arrival;
import com.linkedin.d2.balancer.util.hashing.simulator.ConsistentHashRingSimulator;
import com.linkedin.d2.balancer.util.hashing.simulator.ConsistentHashRingSimulatorConfig;
import com.linkedin.d2.balancer.util.hashing.simulator.Request;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Client {
    private final String _name;
    private final List<Request> _requests;
    private final Arrival _arrival;

    public Client(String name, ConsistentHashRingSimulatorConfig.Client client, boolean shuffleRequests) {
        this._name = name;
        this._requests = new ArrayList<Request>();
        for (ConsistentHashRingSimulatorConfig.Request request : client.getRequests()) {
            this._requests.addAll(ConsistentHashRingSimulator.getRequest(request));
        }
        this._arrival = new Arrival(client.getArrival());
        if (shuffleRequests) {
            Collections.shuffle(this._requests);
        }
    }

    public Client(String name, List<Request> requests, Arrival arrival, boolean shuffleRequests) {
        this._name = name;
        this._requests = requests;
        this._arrival = arrival;
        if (shuffleRequests) {
            Collections.shuffle(this._requests);
        }
    }

    public String getName() {
        return this._name;
    }

    public Arrival getArrival() {
        return this._arrival;
    }

    public List<Request> getRequests() {
        return this._requests;
    }
}

