/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing.simulator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linkedin.d2.balancer.strategies.RingFactory;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.balancer.util.hashing.simulator.Arrival;
import com.linkedin.d2.balancer.util.hashing.simulator.Client;
import com.linkedin.d2.balancer.util.hashing.simulator.ConsistentHashRingSimulatorConfig;
import com.linkedin.d2.balancer.util.hashing.simulator.ConsistentHashRingState;
import com.linkedin.d2.balancer.util.hashing.simulator.Request;
import com.linkedin.util.degrader.CallCompletion;
import com.linkedin.util.degrader.CallTracker;
import com.linkedin.util.degrader.CallTrackerImpl;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.CategoryChartBuilder;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class ConsistentHashRingSimulator {
    private static final String CONFIG_RESOURCE_PATH = "d2/src/main/java/com/linkedin/d2/balancer/util/hashing/simulator/config/simulator.config";
    private static final int REQUEST_TIMEOUT_TIME = 1000;
    private static final int CIR_SNAPSHOT_INTERVAL = 20;
    private final List<Client> _clients;
    private final List<String> _servers;
    private final ConsistentHashRingState _testRingState;
    private final ConsistentHashRingState _consistentRingState;
    private final Map<String, ConsistentHashRingState> _clientState;
    private final Map<String, ConsistentHashRingState> _consistentClientState;
    private final int _serverCapacity;
    private final Map<String, Map<String, AtomicInteger>> _consistencyTracker;
    private final Map<String, List<Integer>> _testRingCIRTracker;
    private final Map<String, List<Integer>> _consistentRingCIRTracker;
    private static Random _random = new Random();
    private static AtomicInteger _consistencyCount = new AtomicInteger(0);
    private static AtomicInteger _callCount = new AtomicInteger(0);

    public ConsistentHashRingSimulator(RingFactory<String> testRingFactory, RingFactory<String> consistentRingFactory, List<Client> clients, Map<String, Integer> pointsMap, int serverCapacity) {
        this._clients = clients;
        this._servers = new ArrayList<String>(pointsMap.keySet());
        this._serverCapacity = serverCapacity;
        this._testRingState = this.initState(testRingFactory, pointsMap);
        this._consistentRingState = this.initState(consistentRingFactory, pointsMap);
        this._clientState = new ConcurrentHashMap<String, ConsistentHashRingState>();
        this._consistentClientState = new ConcurrentHashMap<String, ConsistentHashRingState>();
        this._consistencyTracker = new ConcurrentHashMap<String, Map<String, AtomicInteger>>();
        this._testRingCIRTracker = new ConcurrentHashMap<String, List<Integer>>();
        this._consistentRingCIRTracker = new ConcurrentHashMap<String, List<Integer>>();
        clients.forEach(e -> this._clientState.put(e.getName(), this.initState(testRingFactory, pointsMap)));
        clients.forEach(e -> this._consistentClientState.put(e.getName(), this.initState(consistentRingFactory, pointsMap)));
        this._servers.forEach(e -> {
            this._testRingCIRTracker.put((String)e, new ArrayList());
            this._consistentRingCIRTracker.put((String)e, new ArrayList());
        });
    }

    private ConsistentHashRingState initState(RingFactory<String> ringFactory, Map<String, Integer> pointsMap) {
        ConcurrentHashMap<String, CallTracker> callTrackerMap = new ConcurrentHashMap<String, CallTracker>();
        ConcurrentHashMap<String, List<Integer>> latencyMap = new ConcurrentHashMap<String, List<Integer>>();
        for (String server : pointsMap.keySet()) {
            CallTrackerImpl callTracker = new CallTrackerImpl(5000L);
            callTrackerMap.put(server, (CallTracker)callTracker);
            latencyMap.put(server, new ArrayList());
        }
        Ring<String> ring = ringFactory.createRing(pointsMap, callTrackerMap);
        return new ConsistentHashRingState(ring, callTrackerMap, latencyMap);
    }

    private static ConsistentHashRingSimulator readFromJson(Path path) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            ConsistentHashRingSimulatorConfig config = (ConsistentHashRingSimulatorConfig)mapper.readValue(new File(path.toUri()), ConsistentHashRingSimulatorConfig.class);
            return config.toSimulator();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Error reading JSON file");
        }
    }

    static List<Request> getRequest(ConsistentHashRingSimulatorConfig.Request request) {
        ArrayList<Request> requests = new ArrayList<Request>();
        int id = request.getId();
        int randomIdentifier = new Random(id).nextInt();
        switch (request.getRandomStrategy()) {
            case GAUSSIAN: {
                for (int i = 0; i < request.getNumber(); ++i) {
                    int internalID = id == -1 ? _random.nextInt() : randomIdentifier;
                    requests.add(new Request(internalID, ConsistentHashRingSimulator.getNormal(request.getMinLatency(), request.getMaxLatency(), request.getStddev())));
                }
                break;
            }
            case UNIFORM: {
                for (int i = 0; i < request.getNumber(); ++i) {
                    int internalID = id == -1 ? _random.nextInt() : randomIdentifier;
                    requests.add(new Request(internalID, _random.nextInt(request.getMaxLatency() - request.getMinLatency()) + request.getMinLatency()));
                }
                break;
            }
        }
        return requests;
    }

    static int getNormal(int lower, int upper, double stddev) {
        int mean = lower + (upper - lower) / 2;
        int x = (int)(_random.nextGaussian() * stddev + (double)mean);
        while (x > upper || x < lower) {
            x = (int)(_random.nextGaussian() * stddev + (double)mean);
        }
        return x;
    }

    private void setActualLatency(Request request, int serverLoad, int serverCapacity, boolean isTestRing) {
        double utilRatio = Double.min(0.9, (double)serverLoad / (double)serverCapacity);
        int actualLatency = (int)(utilRatio / (1.0 - utilRatio) * (double)request.getLatency() * 0.9);
        actualLatency = Integer.max(request.getLatency(), Integer.min(1000, actualLatency));
        if (isTestRing) {
            request.setActualLatency(actualLatency);
        } else {
            request.setConsistentActualLatency(actualLatency);
        }
    }

    private synchronized CallCompletion startCall(String server, ConsistentHashRingState state) {
        CallTracker callTracker = state.getCallTrackerMap().get(server);
        return callTracker.startCall();
    }

    private synchronized void endCall(CallCompletion callCompletion, String server, ConsistentHashRingState state, int latency) {
        callCompletion.endCall();
        state.getLatencyMap().get(server).add(latency);
    }

    private Thread runRequest(String clientName, Request request) {
        return new Thread(() -> {
            String server = this._clientState.get(clientName).getRing().get(request.getId());
            String consistentServer = this._consistentClientState.get(clientName).getRing().get(request.getId());
            if (server != null && server.equals(consistentServer)) {
                _consistencyCount.incrementAndGet();
            }
            if (!this._consistencyTracker.containsKey(server)) {
                this._consistencyTracker.put(server, new ConcurrentHashMap());
            }
            if (!this._consistencyTracker.get(server).containsKey(consistentServer)) {
                this._consistencyTracker.get(server).put(consistentServer, new AtomicInteger(0));
            }
            this._consistencyTracker.get(server).get(consistentServer).incrementAndGet();
            CallCompletion testRingCompletion = this.startCall(server, this._testRingState);
            CallCompletion consistentRingCompletion = this.startCall(consistentServer, this._consistentRingState);
            CallCompletion clientCompletion = this.startCall(server, this._clientState.get(clientName));
            this.setActualLatency(request, this._testRingState.getPendingRequestsNum().get(server), this._serverCapacity, true);
            this.setActualLatency(request, this._consistentRingState.getPendingRequestsNum().get(consistentServer), this._serverCapacity, false);
            this.printRequestInfo(_callCount.incrementAndGet(), request, server, consistentServer, this._testRingState.getPendingRequestsNum());
            try {
                Thread.sleep(request.getActualLatency());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.endCall(testRingCompletion, server, this._testRingState, request.getActualLatency());
            this.endCall(consistentRingCompletion, consistentServer, this._consistentRingState, request.getConsistentActualLatency());
            this.endCall(clientCompletion, server, this._clientState.get(clientName), request.getActualLatency());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printRequestInfo(int id, Request request, String server, String origServer, Map<String, Integer> loadMap) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.printf("Request #%d is sent to %s. Most consistent server: %s, Latency: %d, Actual latency: %d\n", id, server, origServer, request.getLatency(), request.getActualLatency());
            System.out.print("\t Current server loads: ");
            if (!loadMap.isEmpty()) {
                loadMap.forEach((k, v) -> System.out.printf("%s : %d\t", k, v));
            }
            System.out.println();
            System.out.println();
        }
    }

    private Thread runClient(String clientName, List<Request> requests, Arrival arrival) {
        return new Thread(() -> {
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (Request request : requests) {
                Thread thread = this.runRequest(clientName, request);
                thread.start();
                threads.add(thread);
                try {
                    Thread.sleep(arrival.getNextInterval());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            for (Thread thread : threads) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void run() throws InterruptedException {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Timer timer = new Timer();
        TimerTask monitorTask = new TimerTask(){

            @Override
            public void run() {
                ConsistentHashRingSimulator.this._testRingState.getPendingRequestsNum().forEach((k, v) -> ((List)ConsistentHashRingSimulator.this._testRingCIRTracker.get(k)).add(v));
                ConsistentHashRingSimulator.this._consistentRingState.getPendingRequestsNum().forEach((k, v) -> ((List)ConsistentHashRingSimulator.this._consistentRingCIRTracker.get(k)).add(v));
            }
        };
        timer.schedule(monitorTask, 0L, 20L);
        for (Client client : this._clients) {
            Thread thread = this.runClient(client.getName(), client.getRequests(), client.getArrival());
            thread.start();
            threads.add(thread);
        }
        for (Thread thread : threads) {
            thread.join();
        }
        timer.cancel();
        timer.purge();
        this.printSummary();
        this.showChart();
    }

    private void printSummary() {
        Integer averageLatency;
        System.out.println();
        System.out.println("****** SUMMARY ******");
        System.out.println("Request distribution on the testing hash ring: ");
        for (String server : this._servers) {
            System.out.printf("%s : %d\n", server, this._testRingState.getTotalRequestsNum().get(server));
        }
        System.out.println();
        System.out.println("Request distribution on the consistent hash ring: ");
        for (String server : this._servers) {
            System.out.printf("%s : %d\n", server, this._consistentRingState.getTotalRequestsNum().get(server));
        }
        System.out.println();
        System.out.println("Average latency (actual) on the testing hash ring: ");
        for (String server : this._servers) {
            averageLatency = this._testRingState.getAverageLatency().get(server);
            System.out.printf("%s, %d\n", server, averageLatency);
        }
        System.out.println();
        System.out.println("Average latency (actual) on the consistent hash ring: ");
        for (String server : this._servers) {
            averageLatency = this._consistentRingState.getAverageLatency().get(server);
            System.out.printf("%s, %d\n", server, averageLatency);
        }
        System.out.println();
        System.out.printf("Percentage of consistent requests: %.2f", (double)_consistencyCount.get() / (double)_callCount.get());
    }

    private XYChart getCIRChart(Map<String, List<Integer>> CIRTracker, String title) {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().title(title)).xAxisTitle("Time (ms)").yAxisTitle("CIR").width(600)).height(400)).build();
        for (Map.Entry<String, List<Integer>> entry : CIRTracker.entrySet()) {
            List xData = IntStream.range(0, entry.getValue().size()).mapToObj(i -> i * 20).collect(Collectors.toList());
            XYSeries series = chart.addSeries(entry.getKey(), xData, entry.getValue());
            series.setMarker(SeriesMarkers.NONE);
        }
        return chart;
    }

    private void showChart() {
        ArrayList<XYChart> charts = new ArrayList<XYChart>();
        CategoryChart chart = ((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)new CategoryChartBuilder().width(800)).height(600)).title("Consistency of hashing algorithm")).xAxisTitle("Distribution of requests on test ring").yAxisTitle("Number of requests").build();
        ((CategoryStyler)chart.getStyler()).setPlotGridVerticalLinesVisible(false);
        ((CategoryStyler)chart.getStyler()).setStacked(true);
        for (String server : this._servers) {
            ArrayList yData = new ArrayList();
            this._servers.forEach(orig -> yData.add(((Map)this._consistencyTracker.getOrDefault(orig, new HashMap())).getOrDefault(server, new AtomicInteger(0)).get()));
            chart.addSeries(server, this._servers, yData);
        }
        charts.add(this.getCIRChart(this._testRingCIRTracker, "CIR changes over time on test ring"));
        charts.add(this.getCIRChart(this._consistentRingCIRTracker, "CIR changes over time on consistent hash ring"));
        new SwingWrapper((Chart)chart).displayChart();
        new SwingWrapper(charts).displayChartMatrix();
    }

    public static void main(String[] args) throws InterruptedException {
        ConsistentHashRingSimulator simulator = ConsistentHashRingSimulator.readFromJson(Paths.get(CONFIG_RESOURCE_PATH, new String[0]));
        simulator.run();
    }
}

