/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing.simulator;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.linkedin.d2.balancer.strategies.DelegatingRingFactory;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyConfig;
import com.linkedin.d2.balancer.util.hashing.simulator.ConsistentHashRingSimulator;
import com.linkedin.util.degrader.DegraderImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ConsistentHashRingSimulatorConfig {
    @JsonProperty(value="hashingAlgorithm")
    private String _hashingAlgorithm;
    @JsonProperty(value="boundedLoadBalancingFactor")
    private double _boundedLoadBalancingFactor;
    @JsonProperty(value="servers")
    private Server[] _servers;
    @JsonProperty(value="serverCapacity")
    private int _serverCapacity;
    @JsonProperty(value="clients")
    private Client[] _clients;
    @JsonProperty(value="shuffleRequests")
    private boolean _shuffleRequests = true;

    public String getHashingAlgorithm() {
        return this._hashingAlgorithm;
    }

    public double getBoundedLoadBalancingFactor() {
        return this._boundedLoadBalancingFactor;
    }

    public Client[] getClients() {
        return this._clients;
    }

    public Server[] getServers() {
        return this._servers;
    }

    public int getServerCapacity() {
        return this._serverCapacity;
    }

    public boolean getShuffleRequests() {
        return this._shuffleRequests;
    }

    public ConsistentHashRingSimulator toSimulator() {
        String hashingAlgorithm = this.getHashingAlgorithm();
        double balancingFactor = this.getBoundedLoadBalancingFactor();
        DegraderLoadBalancerStrategyConfig degraderLoadBalancerStrategyConfig = ConsistentHashRingSimulatorConfig.getConfig(hashingAlgorithm, balancingFactor);
        DelegatingRingFactory<String> testFactory = new DelegatingRingFactory<String>(degraderLoadBalancerStrategyConfig);
        HashMap<String, Integer> pointsMap = new HashMap<String, Integer>();
        int serverID = 0;
        for (Server server : this.getServers()) {
            for (int i = 0; i < server.getNumber(); ++i) {
                pointsMap.put("Server" + serverID, server.getPoints());
                ++serverID;
            }
        }
        DegraderLoadBalancerStrategyConfig consistentConfig = ConsistentHashRingSimulatorConfig.getConfig(hashingAlgorithm, Double.POSITIVE_INFINITY);
        DelegatingRingFactory<String> consistentFactory = new DelegatingRingFactory<String>(consistentConfig);
        ArrayList<com.linkedin.d2.balancer.util.hashing.simulator.Client> clients = new ArrayList<com.linkedin.d2.balancer.util.hashing.simulator.Client>();
        int clientID = 0;
        for (Client client : this.getClients()) {
            for (int i = 0; i < client.getNumber(); ++i) {
                clients.add(new com.linkedin.d2.balancer.util.hashing.simulator.Client("Client" + clientID, client, this.getShuffleRequests()));
                ++clientID;
            }
        }
        int serverCapacity = this.getServerCapacity();
        return new ConsistentHashRingSimulator(testFactory, consistentFactory, clients, pointsMap, serverCapacity);
    }

    private static DegraderLoadBalancerStrategyConfig getConfig(String hashingAlgorithm, double balancingFactor) {
        return new DegraderLoadBalancerStrategyConfig(1000L, false, 100, "uriRegex", Collections.emptyMap(), DegraderLoadBalancerStrategyConfig.DEFAULT_CLOCK, 0.01, 2.0, 600.0, 200.0, 0.2, 0.2, 10L, 5L, 0.2, hashingAlgorithm, 21, 1, balancingFactor, null, 0.0, null, null, "OPTIONS", null, DegraderImpl.DEFAULT_LOW_LATENCY, null, 0L, 0L, "UNDEFINED_CLUSTER");
    }

    public static class Server {
        @JsonProperty(value="number")
        private int _number;
        @JsonProperty(value="points")
        private int _points;

        public int getNumber() {
            return this._number;
        }

        public int getPoints() {
            return this._points;
        }
    }

    public static class Client {
        @JsonProperty(value="number")
        private int _number;
        @JsonProperty(value="requests")
        private Request[] _requests;
        @JsonProperty(value="arrival")
        private Arrival _arrival;

        public int getNumber() {
            return this._number;
        }

        public Request[] getRequests() {
            return this._requests;
        }

        public Arrival getArrival() {
            return this._arrival;
        }
    }

    public static class Request {
        @JsonProperty(value="id")
        private int _id = -1;
        @JsonProperty(value="number")
        private int _number;
        @JsonProperty(value="minLatency")
        private int _minLatency;
        @JsonProperty(value="maxLatency")
        private int _maxLatency;
        @JsonProperty(value="stddev")
        private double _stddev = 1.0;
        @JsonProperty(value="randomStrategy")
        private RandomStrategy _randomStrategy = RandomStrategy.GAUSSIAN;

        public int getId() {
            return this._id;
        }

        public int getNumber() {
            return this._number;
        }

        public int getMinLatency() {
            return this._minLatency;
        }

        public int getMaxLatency() {
            return this._maxLatency;
        }

        public RandomStrategy getRandomStrategy() {
            return this._randomStrategy;
        }

        public double getStddev() {
            return this._stddev;
        }
    }

    public static class Arrival {
        @JsonProperty(value="minInterval")
        private int _minInterval;
        @JsonProperty(value="maxInterval")
        private int _maxInterval;
        @JsonProperty(value="stddev")
        private double _stddev = 1.0;
        @JsonProperty(value="randomStrategy")
        private RandomStrategy _randomStrategy = RandomStrategy.GAUSSIAN;

        public RandomStrategy getRandomStrategy() {
            return this._randomStrategy;
        }

        public int getMaxInterval() {
            return this._maxInterval;
        }

        public int getMinInterval() {
            return this._minInterval;
        }

        public double getStddev() {
            return this._stddev;
        }
    }

    public static enum RandomStrategy {
        UNIFORM,
        GAUSSIAN;

    }
}

