/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing.simulator;

import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.util.degrader.CallTracker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class ConsistentHashRingState {
    private final Ring<String> _ring;
    private final Map<String, CallTracker> _callTrackerMap;
    private final Map<String, List<Integer>> _latencyMap;

    public ConsistentHashRingState(Ring<String> ring, Map<String, CallTracker> callTrackerMap, Map<String, List<Integer>> latencyMap) {
        this._ring = ring;
        this._callTrackerMap = callTrackerMap;
        this._latencyMap = latencyMap;
    }

    public Map<String, Integer> getPendingRequestsNum() {
        return this._callTrackerMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((CallTracker)e.getValue()).getCurrentConcurrency()));
    }

    public Map<String, Long> getTotalRequestsNum() {
        return this._callTrackerMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((CallTracker)e.getValue()).getCurrentCallStartCountTotal()));
    }

    public Map<String, Integer> getAverageLatency() {
        HashMap<String, Integer> averageLatency = new HashMap<String, Integer>();
        for (Map.Entry<String, List<Integer>> entry : this._latencyMap.entrySet()) {
            int average = (int)entry.getValue().stream().mapToInt(Integer::intValue).average().orElse(0.0);
            averageLatency.put(entry.getKey(), average);
        }
        return averageLatency;
    }

    public Map<String, CallTracker> getCallTrackerMap() {
        return this._callTrackerMap;
    }

    public Map<String, List<Integer>> getLatencyMap() {
        return this._latencyMap;
    }

    public Ring<String> getRing() {
        return this._ring;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.getTotalRequestsNum().forEach((k, v) -> {
            long complete = this.getTotalRequestsNum().get(k) == null ? 0L : this.getTotalRequestsNum().get(k);
            sb.append(String.format("%s : Pending = %d, Total = %d\t", k, v, complete));
        });
        return sb.toString();
    }
}

